/*
 
 * File    : spore.cpp
 * Version : 0.2
 * Grp     : laptopligan
 * Code    : ziL (peter@codeseven.org)
 * Desc    : Partyprod (Birdie 15)
 
 */

#include <string>
#include <iostream>

// SDL and SDL_image
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

// Our header files 
#include "functions.h"
#include "font.h"

#include "xistdraw.h"

// Physics iterations per second
#define PHYSICSFPS 30


// The screen surface
SDL_Surface *screen, *back, *logo, *birdie, *starback;
// The font
SDLFont *font1;

// The xist draw object
xistDraw 	*xd;

// The color variables
Uint8 r, g, b;

// The current scene id
int currentScene = 1;
int totalFps 	 = 0;
int windowMode   = 0;

// Last iterations tick value
int gLastTick;
Uint32 nticks;
bool done = 0;


int starX[198], starY[198], i,b2, anotherY; //  "'Cause I'm like a star child..."
       
 // This function draws to the screen; replace this with your own code!
static void DrawScene () {
	// nticks = SDL_GetTicks();
	totalFps++;
	
	// Ask SDL for the time in milliseconds
  	int tick = SDL_GetTicks();

  	if (tick <= gLastTick) {
    	SDL_Delay(1);
    	return;
  	}
	
  	// Lock surface if needed
    if (SDL_MUSTLOCK(screen))
    	if (SDL_LockSurface(screen) < 0) 
			return;
	
	int alpha = 0;
	
	switch(currentScene) {
		case 1:
			
		while (gLastTick < tick) {		
			// Put precomputing stuff here
    		gLastTick += 1000 / PHYSICSFPS;
  		}
		  
		xd->Image(screen,starback,0,0);
		   
//  Control over the pixels and their respective places
    for(i=0; i<=198; i++) {       
      starX[i]++;
      if(i>=100) {
        starX[i]++;
      }
      if(starX[i]>640) {
        starX[i]=0;                  
      }
    }
      
        for(i=0; i<=99; i++) {
      anotherY = (int)(starY[i] - 5 * sin(starX[i]/20));
      if( !(anotherY < 0 || anotherY > 480) )       
        xd->Pixel(screen, starX[i], anotherY, 255,255,255,639,479);
    }
    for(i=100; i<=198; i++) {
		// the "+1" makes the faster moving pixels look bigger (four pixels)
      	xd->Pixel(screen, starX[i],   starY[i],   200,200,200,639,479); 
      	xd->Pixel(screen, starX[i],   starY[i]+1, 200,200,200,639,479);
      	xd->Pixel(screen, starX[i]+1, starY[i]+1,200,200,200,639,479);
      	xd->Pixel(screen, starX[i]+1, starY[i],   200,200,200,639,479);
    }
 
 		xd->Image(screen,logo,320,380);
 
 		if(tick>20000) {
			currentScene = 3;
		}
 
		break;
			
		case 2:			
			while (gLastTick < tick) {		
				// Put precomputing stuff here
    			gLastTick += 1000 / PHYSICSFPS;
  			}

			// For fuck sake, make this an external function
		for(int j=0;j<480;j++) {
			if(j%2){alpha++;}
			for(int i=0;i<640;i++) {
				xd->Pixel(screen, i, j, int (alpha/2.5), int (alpha/1.1), int (alpha/2.5), 640, 480);								
			}			
		}
		
		xd->Image(screen,logo,10,10);
				
		break;

		case 3:
			alpha = 255;
			while (gLastTick < tick) {		
				// Put precomputing stuff here
    			gLastTick += 1000 / PHYSICSFPS;
  			}
		
			// For fuck sake, make this an external function
			for(int j=0;j<480;j++) {
				if(j%2){alpha--;}
				for(int i=0;i<640;i++) {
					xd->Pixel(screen, i, j, int (alpha/2), int (alpha/1.4), int (alpha/3.8), 640, 480);								
				}			
			}
			
			xd->Image(screen,logo,320,380);
			xd->Image(screen,birdie,450,100);
			
			drawString(screen,font1,50,55,"SPORE, released at Birdie 15");
			drawString(screen,font1,65,85,"code: ziL, tw1nk, wired");
			drawString(screen,font1,65,115,"gfx: ziL");
			
			drawString(screen,font1,65,200,"notes: Our musicer couldn't make");
			drawString(screen,font1,100,230,"it to birdie this year :(");
			
			if(tick>40000) {
				done = 1;
			}

		break;
		
	}
	
    /* Make sure everything is displayed on screen */
    SDL_Flip (screen);
    
    // Tell SDL to update the whole screen
  	SDL_UpdateRect(screen, 0, 0, 640, 480);   
    
}

int main (int argc, char *argv[]) {
	
	if(argc>1) { 
		currentScene = atoi(argv[1]);
		
		if(argc>2) {
			windowMode = 1;
		}
		
	} else {
		currentScene = 1;
	}
	
	printf("SPORE (SPaced Out Rjj Effekkts) by laptopligan\nProgrammed by ziL, tw1nk, klopaz and wired\n");
    
    	
    // Initialize SDL
    if (SDL_Init (SDL_INIT_VIDEO) < 0) {
        printf ("Couldn't initialize SDL: %s\n", SDL_GetError ());
        exit (1);
    }
    
    atexit (SDL_Quit);
	
	if(windowMode) {
    	screen = SDL_SetVideoMode (640, 480, 16, SDL_HWSURFACE|SDL_HWACCEL|SDL_DOUBLEBUF|SDL_ANYFORMAT);
	} else {
		screen = SDL_SetVideoMode (640, 480, 16, SDL_FULLSCREEN|SDL_HWSURFACE|SDL_HWACCEL|SDL_DOUBLEBUF|SDL_ANYFORMAT);
	}
     
    if (screen == NULL) {
        printf ("Couldn't set 640x480x16 video mode: %s\n",SDL_GetError ());
        exit (2);
    }
    
    // Init pictures
    back  	= IMG_Load("data/gfx/bg.png");
    logo 	= IMG_Load("data/gfx/logo.png");    
 	starback  = IMG_Load("data/gfx/galax.jpg");
   
   	srand (time(NULL));
    
    for(int i=0; i<=198; i++) {
      starX[i] = rand()%639;
      starY[i] = rand()%479;
    }
    

    logo 	= IMG_Load("data/gfx/logo.png");    
    birdie 	= IMG_Load("data/gfx/birdie.png");
     	 	
    // Init fonts
    font1 = initFont("data/fonts/font1");
    
    // Set caption, cursor and icon
    SDL_WM_SetCaption("SPORE (SPaced Out Rjj Effekkts) by laptopligan", "SPORE!");
 	SDL_ShowCursor(1);
    SDL_WM_SetIcon(birdie, NULL);

  	while (!done) {
  		SDL_Event event;
  		SDL_PollEvent(&event);
  		
  		DrawScene();
  		
  		if(	event.type == SDL_QUIT || 
  			event.key.keysym.sym == SDLK_ESCAPE || 
  			event.key.keysym.sym == SDLK_q ) {
        	done = true;
        }
  	}
	
	SDL_FreeSurface(back);	
    SDL_FreeSurface(logo);	
    
	freeFont(font1);
    Quit(0);
}
