/* Project : Projekt Ruhr
 * Groups  : xist
 * Code    : ziL and OrreBorre
 * Gfx     : ziL and Orreborre
 * Sfx     : 'Ruhrbania' by OrreBorre
 * Desc    : Partyprod (Birdie 14)
 */

#include <stdlib.h>
#include <string.h>

// LibSDL!!!
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>

#include <math.h>

#define MAX_PARTS 1200
#define MAX_PARTS2 2000

#define PART_DRAW 0
#define PART_X 1
#define PART_Y 2
#define PART_DIR 3
#define PART_SPEED 4
#define PART_TX 5
#define PART_TY 6

#define PART_RSPEED (10+rand()%9)
#define NUM_LETTERS 4
#define POINT_LENGTH 15

int shakeit = 10;
int MusicStart;

int scene = 1;
int fademusic = 0;

// We are using the std namespace!
using namespace std;

/* The screen surface */
SDL_Surface *screen, *part = NULL, *back = NULL, *cog = NULL, *icon = NULL, *frame, *scroller, *img_icon, *birdie_logo;

Uint32 color;

int partwave[100][1];
int sine_nr = 0;


// Initialize particles
    float parts[MAX_PARTS][7];
    // 0 = draw
    // 1 = x
    // 2 = y
    // 3 = dir
    // 4 = speed    
    // 5 = target x
    // 6 = target y
// ---

// Initialize particles
    float parts2[MAX_PARTS2][7];
    // 0 = draw
    // 1 = x
    // 2 = y
    // 3 = dir
    // 4 = speed    
    // 5 = target x
    // 6 = target y
// ---

float text[10][12][3];
int numparts[10], l_points[10];

float deltax, deltay, xtemp, ytemp, counter1 = 0, angle, plx = 10, ply = 10;
int dirflip = 0, trigger1 = 0, trigger2 = 0, temp1 = 0;

// The music! 
Mix_Music *music = NULL;
int nosound;

void inittext()
{
    numparts[0] = 50;
    l_points[0] = 9;
    
    text[0][0][0] = 1; text[0][0][1] = 1;
    text[0][1][0] = 2; text[0][1][1] = 2;
    text[0][2][0] = 3; text[0][2][1] = 3;
    text[0][3][0] = 4; text[0][3][1] = 4;
    text[0][4][0] = 5; text[0][4][1] = 5;
    
    text[0][5][0] = 1; text[0][5][1] = 5;
    text[0][6][0] = 2; text[0][6][1] = 4;
    text[0][7][0] = 4; text[0][7][1] = 2;
    text[0][8][0] = 5; text[0][8][1] = 1;
/*    
    text[0][9][0] = 1.5; text[0][9][1] = 1.5;
    text[0][10][0] = 2.5; text[0][10][1] = 2.5;
    text[0][11][0] = 3.5; text[0][11][1] = 3.5;
    text[0][12][0] = 4.5; text[0][12][1] = 4.5;

    text[0][13][0] = 1.5; text[0][13][1] = 4.5;
    text[0][14][0] = 2.5; text[0][14][1] = 3.5;
    text[0][15][0] = 3.5; text[0][15][1] = 2.5;
    text[0][16][0] = 4.5; text[0][16][1] = 1.5;
*/  
    numparts[1] = 45;
    l_points[1] = 7;
    
    text[1][0][0] = 2.5; text[1][0][1] = 1;
    text[1][1][0] = 3.5; text[1][1][1] = 1;
    text[1][2][0] = 3; text[1][2][1] = 2;
    text[1][3][0] = 3; text[1][3][1] = 3;
    text[1][4][0] = 3; text[1][4][1] = 4;
    text[1][5][0] = 2.5; text[1][5][1] = 5;
    text[1][6][0] = 3.5; text[1][6][1] = 5;
    
    numparts[2] = 130;
    l_points[2] = 15;
    
    text[2][0][0] = 5; 	text[2][0][1]  = 2;
    text[2][1][0] = 4.5; text[2][1][1] = 1;
    text[2][2][0] = 4; 	text[2][2][1]  = 1;
    text[2][3][0] = 3; 	text[2][3][1]  = 1;
    text[2][4][0] = 2.5; text[2][4][1] = 1.5;
    text[2][5][0] = 2; 	text[2][5][1]  = 2;
    text[2][6][0] = 2; 	text[2][6][1]  = 3;    
    text[2][7][0] = 3; 	text[2][7][1]  = 3.5;
    text[2][8][0] = 4; 	text[2][8][1]  = 4;    
    text[2][9][0] = 4.5; text[2][9][1] = 4.5;
    text[2][10][0] = 4; text[2][10][1] = 5;    
    text[2][11][0] = 3; text[2][11][1] = 5;
    text[2][12][0] = 2; text[2][12][1] = 5;    
    text[2][13][0] = 1; text[2][13][1] = 5;    
    
    numparts[3] = 65;
    l_points[3] = 13;
    
    text[3][0][0] = 1; text[3][0][1] = 1;
    text[3][1][0] = 2; text[3][1][1] = 1;
    text[3][2][0] = 3; text[3][2][1] = 1;
    text[3][3][0] = 4; text[3][3][1] = 1;
    text[3][4][0] = 5; text[3][4][1] = 1;
    text[3][5][0] = 3; text[3][5][1] = 2;
    text[3][6][0] = 3; text[3][6][1] = 3;    
    text[3][7][0] = 3; text[3][7][1] = 4;
    text[3][8][0] = 3; text[3][8][1] = 5;    
    text[3][9][0] = 2.5; text[3][9][1] = 5;
    text[3][10][0] = 3.5; text[3][10][1] = 5;    
    text[3][11][0] = 1; text[3][11][1] = 1.2;
    text[3][12][0] = 5; text[3][12][1] = 1.2;    
}

void initparts()
{
    for(int c=0;c<MAX_PARTS;c++)
    {
        parts[c][PART_DRAW] = 0;
        parts[c][PART_X] = 0;
        parts[c][PART_Y] = 0;
        parts[c][PART_DIR] = 0;
        parts[c][PART_SPEED] = 0;        
        parts[c][PART_TX] = 0;
        parts[c][PART_TY] = 0;
    }
}

void initparts2()
{
    for(int c=0;c<MAX_PARTS2;c++)
    {
        parts2[c][PART_DRAW] = 0;
        parts2[c][PART_X] = 0;
        parts2[c][PART_Y] = 0;
        parts2[c][PART_DIR] = 0;
        parts2[c][PART_SPEED] = 0;        
        parts2[c][PART_TX] = 0;
        parts2[c][PART_TY] = 0;
    }
}

int CamShake() {

int ms = SDL_GetTicks()-(MusicStart*2); //ms = ms - 229;

int temp = 0;

 if(shakeit > 0) {
  shakeit = shakeit - 10;
 }
 
  if(shakeit<0)
	  shakeit = 0;
 
 if(ms>910 && ms<1000) {
  shakeit = 10;
  }

 if(ms>3700 && ms<3800)
  shakeit = 10;
  
  
 if(ms>4430 && ms<4530)
  shakeit = 14;


 if(ms>5140 && ms<26320)
  shakeit = 50;

 
 //temp = ;
 if(shakeit!=0)
 	temp = (int)(-(shakeit/2)+rand()%shakeit);
 
 return temp;   
}

void DrawIMG(SDL_Surface *img, int x, int y)
{
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_BlitSurface(img, NULL, screen, &dest);
}

void DrawIMG(SDL_Surface *img, int x, int y, int w, int h, int x2, int y2)
{
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_Rect dest2;
  dest2.x = x2;
  dest2.y = y2;
  dest2.w = w;
  dest2.h = h;
  SDL_BlitSurface(img, &dest2, screen, &dest);
}

void spawnparticle2(float x, float y, float dir, float speed, float tx, float ty)
{
// Spawn a particle
    for(int c=0;c<MAX_PARTS2;c++)
    {
        if(parts2[c][PART_DRAW] != 1) // If slot isn't used...
        {
            // ...use it
            parts2[c][PART_DRAW] = 1;
            parts2[c][PART_X] = x;//rand()%640;
            parts2[c][PART_Y] = y;//rand()%480;
            parts2[c][PART_DIR] = dir;
            parts2[c][PART_SPEED] = speed;
            parts2[c][PART_TX] = tx;
            parts2[c][PART_TY] = ty;
            break; // Stop searching for slots
        }
    }
}


void DrawPixel(SDL_Surface *screen, int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
  if(!(x < 1 || x > 640 || y < 1 || y > 480))
  {
  Uint32 color = SDL_MapRGB(screen->format, R, G, B);
  switch (screen->format->BytesPerPixel)
  {
    case 1: // Assuming 8-bpp
      {
        Uint8 *bufp;
        bufp = (Uint8 *)screen->pixels + y*screen->pitch + x;
        *bufp = color;
      }
      break;
    case 2: // Probably 15-bpp or 16-bpp
      {
        Uint16 *bufp;
        bufp = (Uint16 *)screen->pixels + y*screen->pitch/2 + x;
        *bufp = color;
      }
      break;
    case 3: // Slow 24-bpp mode, usually not used
      {
        Uint8 *bufp;
        bufp = (Uint8 *)screen->pixels + y*screen->pitch + x * 3;
        if(SDL_BYTEORDER == SDL_LIL_ENDIAN)
        {
          bufp[0] = color;
          bufp[1] = color >> 8;
          bufp[2] = color >> 16;
        } else {
          bufp[2] = color;
          bufp[1] = color >> 8;
          bufp[0] = color >> 16;
        }
      }
      break;
    case 4: // Probably 32-bpp
      {
        Uint32 *bufp;
        bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
        *bufp = color;
      }
      break;
  }
  }
}


void spawnparticle(float x, float y, float dir, float speed, float tx, float ty)
{
// Spawn a particle
    for(int c=0;c<MAX_PARTS2;c++)
    {
        if(parts[c][PART_DRAW] != 1) // If slot isn't used...
        {
            // ...use it
            parts[c][PART_DRAW] = 1;
            parts[c][PART_X] = x;//rand()%640;
            parts[c][PART_Y] = y;//rand()%480;
            parts[c][PART_DIR] = dir;
            parts[c][PART_SPEED] = speed;
            parts[c][PART_TX] = tx;
            parts[c][PART_TY] = ty;
            break; // Stop searching for slots
        }
    }
}

/* This function draws to the screen; replace this with your own code! */
static void
DrawScene ()
{	

DrawIMG(back,CamShake()-50,CamShake()-50);
    
    // Compute them
    for(int c=0;c<MAX_PARTS2;c++)
    {
        if(parts2[c][PART_DRAW] == 1)
        {   
            deltax = parts2[c][PART_TX] - parts2[c][PART_X];// + (sin(counter1)*200);
            deltay = parts2[c][PART_TY] - parts2[c][PART_Y];                            
            
            if(deltax < 0) xtemp = -deltax;
            else xtemp = deltax;
            if(deltay < 0) ytemp = -deltay;
            else ytemp = deltay;
            
            parts2[c][PART_SPEED] += (rand()%10)/10;
            parts2[c][PART_DIR] += (rand()%10)/1;
            
            
            parts2[c][PART_X] += -sin((parts2[c][PART_DIR]-90) * M_PI/180) * parts2[c][PART_SPEED];
            parts2[c][PART_Y] += cos((parts2[c][PART_DIR]-90) * M_PI/180) * parts2[c][PART_SPEED];
                                 
        }
    }
    
    // Draw them
    for(int c=0;c<MAX_PARTS2;c++)
    {
        if(parts2[c][PART_DRAW] == 1)
        {
            DrawPixel(screen, (int)parts2[c][PART_X], (int)parts2[c][PART_Y], 230, 230, 230);
            
            DrawPixel(screen, (int)parts2[c][PART_X]+1,(int)parts2[c][PART_Y],   80, 80, 80);
            DrawPixel(screen, (int)parts2[c][PART_X],  (int)parts2[c][PART_Y]+1, 80, 80, 80);
            DrawPixel(screen, (int)parts2[c][PART_X]+1,(int)parts2[c][PART_Y]+1, 80, 80, 80);                                    
        }
    }  

	// Start the second scene
	if(SDL_GetTicks() > 33340 && scene == 1 ) {
	initparts();
	 back = IMG_Load("data/gfx/chernobyl2.png");
	 scene = 2;
	for(int i=0;i<1500;i++) 
	 spawnparticle2(320, 240, rand()%360, 5, 0, 0);
	 
	}
	
	// The bird
	if(SDL_GetTicks() > 26320 && scene == 1 ) {
	 int bx = 320+(int)(150*sin((SDL_GetTicks())/40) * M_PI/180);
	 int by = 240+(int)((110*-cos(SDL_GetTicks())*(M_PI/180)));
	 
	
	DrawIMG(birdie_logo,bx,by);
	}
	
	// Fade the music (and exit) after 90000 mics
		if(SDL_GetTicks() > 90100 && fademusic != 1 ) {
		fademusic = 1;
	}
    
    if(trigger1 == 1)
    {
        for(int letters=0;letters < NUM_LETTERS;letters++)
        {
            if(numparts[letters] != 0)
            {
                for(int c=0;c<numparts[letters];c++)
                {
                    spawnparticle(-100,rand()%480,rand()%360,(rand()%30)/10,640,100+rand()%200);
                }
                numparts[letters] = 0;
                for(int c=0;c<MAX_PARTS;c++)
                {
                    if(parts[c][PART_DRAW] == 1)
                    {
                        if(parts[c][PART_TX] >= 640)
                        {
                            int temp = rand()%l_points[letters];
                            parts[c][PART_TX] = 50+(80*(letters+1))+(text[letters][temp][0]*POINT_LENGTH);
                            parts[c][PART_TY] = 200+(text[letters][temp][1]*POINT_LENGTH);
                        }
                    }
                }
            }
        }    
        
        for(int letters=0;letters < NUM_LETTERS;letters++)
        {
            int temp = rand()%2;
            if(temp == 1)
            {
                temp = rand()%l_points[letters];
                int temp2 = rand()%MAX_PARTS; 
                parts[temp2][PART_TX] = 50+(80*(letters+1))+(text[letters][temp][0]*POINT_LENGTH);
                parts[temp2][PART_TY] = 200+(text[letters][temp][1]*POINT_LENGTH);
            }
        }
    }    
    if(SDL_GetTicks() > 5000)
    {
        trigger1 = 1;                
    }
    
    
    if(scene==1) {
    
    temp1 = rand()%15;
    if(temp1 == 1)
        spawnparticle(-100,-50+rand()%480,rand()%360,(rand()%30)/10,300+rand()%300,500+rand()%200);
    
    if(SDL_GetTicks() > 15000)
    {
        trigger2 = 1;                
    }
    
    if(trigger2 == 1)
    {
        int temp = 0;
        for(int c=0;c<MAX_PARTS;c++)
        {
            if(parts[c][PART_TX]!=840)
            {
                parts[c][PART_TX] = 840;
                parts[c][PART_TY] = rand()%480;
                temp++;
                if(temp == 5)
                    break;
            }
        }
     }
     
     }
        
    counter1 += 0.01;
    
    // Compute them
    for(int c=0;c<MAX_PARTS;c++)
    {
        if(parts[c][PART_DRAW] == 1)
        {   
            deltax = parts[c][PART_TX] - parts[c][PART_X];// + (sin(counter1)*200);
            deltay = parts[c][PART_TY] - parts[c][PART_Y];                            
            
            if(deltax < 0) xtemp = -deltax;
            else xtemp = deltax;
            if(deltay < 0) ytemp = -deltay;
            else ytemp = deltay;
            
            if(ytemp < 60 && xtemp < 60)
            {
                if(parts[c][PART_SPEED] > 1.2)
                    parts[c][PART_SPEED] -= 1.1;               
            }
            else
            {
                if(parts[c][PART_SPEED] < 10)
                    parts[c][PART_SPEED] += 0.2;//+((300+rand()%300)/100);
            }
            
            parts[c][PART_SPEED] += (rand()%10)/10;
            
            parts[c][PART_X] += -sin((parts[c][PART_DIR]-90) * M_PI/180) * parts[c][PART_SPEED];
            parts[c][PART_Y] += cos((parts[c][PART_DIR]-90) * M_PI/180) * parts[c][PART_SPEED];
            
		
            angle = (atan2(deltay,deltax)+M_PI)*(180/M_PI);  
            
            if(deltay > 0 && deltax > 0)
            {
                if(parts[c][PART_DIR] < (angle-180))
                    parts[c][PART_DIR] += PART_RSPEED;
                else
                    parts[c][PART_DIR] -= PART_RSPEED;
            }
            else if(deltay > 0 && deltax < 0)
            {
                if(parts[c][PART_DIR] < (angle-180))
                    parts[c][PART_DIR] += PART_RSPEED;
                else
                    parts[c][PART_DIR] -= PART_RSPEED;
            }
            else if(deltay < 0 && deltax < 0)
            {
                if(parts[c][PART_DIR] > (angle))
                    parts[c][PART_DIR] += PART_RSPEED;
                else
                    parts[c][PART_DIR] -= PART_RSPEED;
            }
            else if(deltay < 0 && deltax > 0)
            {
                if(parts[c][PART_DIR] < (angle-180))
                    parts[c][PART_DIR] += PART_RSPEED;
                else
                    parts[c][PART_DIR] -= PART_RSPEED;
            }
            
       
            if(parts[c][PART_DIR] < -180)
                parts[c][PART_DIR] += 360;
            else if(parts[c][PART_DIR] > 180)
                parts[c][PART_DIR] -= 360;                      
        }
    }

    // Draw them
    for(int c=0;c<MAX_PARTS;c++)
        {
        if(parts[c][PART_DRAW] == 1)
         
         DrawIMG(part,(int)parts[c][PART_X]-5,(int)parts[c][PART_Y]-5);
        }  



if(scene == 2) {

sine_nr++;
DrawIMG(scroller,180,400-sine_nr);

DrawIMG(part,partwave[sine_nr][0],partwave[sine_nr][1]);
}

    DrawIMG(cog,-150,-150);
    DrawIMG(cog,640-150,-150);
    DrawIMG(cog,-150,480-150);
    DrawIMG(cog,640-150,480-150);
            
    // Draw the frame
    DrawIMG(frame,0,0);
                
    /* Make sure everything is displayed on screen */
    SDL_Flip (screen);
     
}

int main (int argc, char *argv[]) {

printf("Projekt Ruhr by xist!\nProgrammed by OrreBorre and ziL\n");


    int audio_rate      = 44100;
    Uint16 audio_format = AUDIO_S16;
    int audio_channels  = 2;
    int audio_buffers   = 4096;
	
    char *msg;
    int done;

    if(argv) {
    	// Do nothing         
	     }
	      
	
    /* Initialize SDL */
    if (SDL_Init (SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0)
    {
        asprintf (&msg, "Couldn't initialize SDL: %s\n", SDL_GetError ());
        free (msg);
        exit (1);
    }
    atexit (SDL_Quit);

	
    // fulhack for the -nosound argument =)
	if(argc<2) {
		 if(Mix_OpenAudio(audio_rate,audio_format,audio_channels,audio_buffers)) {
			 printf("Unable to open audio!");
			 exit(1);
		 }
	} else {
		nosound = 1;
	}
	
    /* Set 640x480 16-bits video mode */
     screen = SDL_SetVideoMode (640, 480, 16, SDL_HWSURFACE|SDL_HWACCEL|SDL_DOUBLEBUF|SDL_NOFRAME|SDL_ANYFORMAT|SDL_FULLSCREEN);
     
    if (screen == NULL)
    {
        asprintf (&msg, "Couldn't set 640x480x16 video mode: %s\n",
          SDL_GetError ());
        free (msg);
        exit (2);
    }
    
    SDL_WM_SetCaption("Projekt Ruhr", "Ruhr by xist");
	
    img_icon = IMG_Load("data/gfx/icon.png");
    SDL_WM_SetIcon(img_icon, NULL);
 
 // Do not show the mousecursor (is this really useful?)
 SDL_ShowCursor(0);
	
    if(nosound!=1) {
	    //Load the music into music.. far out man!
	    //music = Mix_LoadMUS("data/sfx/xist-time_flies.ogg");
	    music = Mix_LoadMUS("data/sfx/xist-ruhrbania.ogg");
	    // Play the music and loop it _forever_
	    MusicStart = SDL_GetTicks();
	    Mix_PlayMusic(music, 1);
     }

    // Init pictures
    back  = IMG_Load("data/gfx/chernobyl1.png");
    frame = IMG_Load("data/gfx/metal_frame.png");
    
    scroller = IMG_Load("data/gfx/scroller.png");
    
    part = IMG_Load("data/gfx/part.png");
    cog = IMG_Load("data/gfx/cogwheel.png"); 
    
    birdie_logo = IMG_Load("data/gfx/birdie_logo.png");
    
    // Initial initialization :) (putting everything to zero)
    initparts();
    initparts2();

    inittext();
    

Uint32 now;
	
  while(done != 1) {
    SDL_Event event;
  
    for(int done = 0; !done;) 
    {	
	DrawScene();
    	SDL_PollEvent(&event);
    	
        if(event.key.keysym.sym == SDLK_ESCAPE)
            fademusic = 1;
	    
	if(fademusic) {    
            // Fade the music in 1.5 seconds
		Mix_FadeOutMusic(1200);
                
		now = SDL_GetTicks();
		
		while(now+1300>SDL_GetTicks()) {
			// Do not pause, just keep on drawing the scene
			DrawScene();
		}
			
	//	SDL_Delay(1500);
	 done = 1;
	}
			     
	    
    }  
    if(nosound!=1) {
	    Mix_FreeMusic(music);
	    Mix_CloseAudio();
    }
	  
    SDL_Quit();
  return 0;
  }
}
