//############################################################################
// Definet ###################################################################
//############################################################################

// Ruutu
#define	SCREEN_W	800
#define	SCREEN_H	600
#define	SCREEN_B	32

// Aika
#define TIMER_FPS	60
#define TIMER_MS	(Uint32)(1000.0f / (float)TIMER_FPS)

//#define FLAG_FULLSCREEN
#define SDL_GFX_FLAGS	(SDL_HWSURFACE | SDL_OPENGL | SDL_HWSURFACE)
#ifdef FLAG_FULLSCREEN
#define SDL_GFX_FLAGS	(SDL_GFX_FLAGS | SDL_FULLSCREEN)
#endif

//############################################################################
// Includet ##################################################################
//############################################################################

// Posix
#include <math.h>

// Windows
#ifdef FLAG_WINDOWS
#include "windows.h"
#endif

// 3rd party
#include "SDL.h"
#include "GL/gl.h"
#include "GL/glu.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846f
#endif

//############################################################################
// Timer #####################################################################
//############################################################################

Uint32 var_timer;

Uint32 timer_func(Uint32 interval)
{
  var_timer++;
  return interval;
}

//############################################################################
// Helper funcs ##############################################################
//############################################################################

int modulo(int val, int base)
{
  if(val < 0)
    val += base;
  else if(val >= base)
    val -= base;
  return val;
}

void interpolate_linear_i16d(double* target, Sint16* from, Sint16* to,
    float pos, int count)
{
  do
  {
    target[count] = ((float)(to[count]) - (float)(from[count])) * pos +
      (float)(from[count]);
  } while(count--);
}

void memclr(void *op, size_t bytes)
{
  Uint32 *dst = (Uint32*)op;
  for(; bytes; bytes -= 4, dst++)
    *dst = 0;
}

//############################################################################
// Interpolation #############################################################
//############################################################################

/*
 * All interpolation functions here.
 */

void interpolate_linear_ff(float* target, float* from, float* to, float pos,
    int count)
{
  do
  {
    target[count] = (to[count] - from[count]) * pos + from[count];
  } while(count--);
}

float interpolate_sine(float base, float var, float currtime, float speed)
{
  return base + var * sin((float)currtime * speed);
}

//############################################################################
// Random ####################################################################
//############################################################################

/*
 * Random number generator: x[n + 1] = a * x[n] mod m
 * Made according to source by Glenn C Rhoads.
 * http://remus.rutgers.edu/~rhoads/Code/code.html
 */

static Uint32 var_rand_seed = 93186752, var_rand_a = 1588635695,
	      var_rand_q = 2, var_rand_r = 1117695901;

// Initialize random number generator
void rand_seed(int op)
{
  var_rand_seed = op;
}

// Random natural number [0, param[
int rand_int(int op)
{
  var_rand_seed = var_rand_a * (var_rand_seed % var_rand_q) -
    var_rand_r * (var_rand_seed / var_rand_q);
  return var_rand_seed % op;
}

// Random real number [0, number]
float rand_float(float op)
{
  return (float)(rand_int(32768)) / 32767.0f * op;
}

// Random real number [-number, number]
float rand_float_neg(float op)
{
  return (float)(rand_int(65534) - 32767) / 32767.0f * op;
}

//############################################################################
// Arrayt ####################################################################
//############################################################################

// Paljonko haluamme tilaa
#define ARRAY_HEAP	50000

// Värit ja verteksit taulukoissa
Uint32 var_index_array[ARRAY_HEAP];
float var_vertex_array[ARRAY_HEAP];
Uint32 var_color_array[ARRAY_HEAP];
unsigned var_index_ins, var_vertex_ins, var_color_ins;

/*
 * Add a vertex and a color to the buffer to be drawn.
 */
void array_add_vertex(float x, float y, float z, Uint32 c)
{
  float *dst = &var_vertex_array[var_vertex_ins * 3];
  // Set
  dst[0] = x;
  dst[1] = y;
  dst[2] = z;
  var_color_array[var_color_ins] = c;
  // Inc
  var_vertex_ins++;
  var_color_ins++;
}

/*
 * Add a vertex that is an interpolation between two other vertices.
 */
void array_interpolate_vertex(int from, int to, float pos, Uint32 col)
{
  // Interpoloi
  interpolate_linear_ff(&var_vertex_array[var_vertex_ins * 3],
      &var_vertex_array[from * 3], &var_vertex_array[to * 3], pos, 3);
  // Insertoi väri
  var_color_array[var_color_ins] = col;
  // Inc
  var_color_ins++;
  var_vertex_ins++;
}

/*
 * Insert an index to the array.
 */
void array_add_index(Uint32 op)
{
  var_index_array[var_index_ins] = op;
  var_index_ins++;
}

//############################################################################
// Kontrolli #################################################################
//############################################################################

// Kontrolli
#define CIRCLES_START	0
#define WINGS_START	4360
#define WINGS_END	6200
#define TIME_END	7000

// Katsomissuunnat
typedef struct
{
  unsigned time;
  Sint16 data[6];
} LookAtUnit;

LookAtUnit data_look_at_buf[50] =
{
  { CIRCLES_START, { 10, 30, 0, 50, 30, 0 } },
  { CIRCLES_START + 300, { 5, 40, 20, -10, 30, -40 } },
  { CIRCLES_START + 550, { -5, 80, 10, -50, 40, 10 } },
  { CIRCLES_START + 800, { 15, 140, 2, 0, 40, 40 } },
  { CIRCLES_START + 1200, { 5, 160, -9, 40, 60, -50 } },
  { CIRCLES_START + 1500, { 5, 180, -9, -30, 10, -10 } },
  { CIRCLES_START + 2000, { 5, 180, -30, -10, 20, -20 } },
  { CIRCLES_START + 2700, { 25, 190, 40, 0, 20, 0 } },
  { CIRCLES_START + 3600, { -5, 190, 30, 15, 20, -10 } },
  { CIRCLES_START + 4300, { 0, 150, 190, 0, 50, 0 } },
  { WINGS_END, { 0, 120, 110, 0, 50, 0 } },
  { TIME_END, { 0, 180, 20, 0, 0, 0 } }
  /*{ CIRCLES_START, { 0, 180, 20, 0, 0, 0 } },
  { TIME_END, { 0, 180, 20, 0, 0, 0 } }*/
};

//############################################################################
// LookAt ####################################################################
//############################################################################

void look_at(void)
{
  LookAtUnit *to = &data_look_at_buf[1], *from = &data_look_at_buf[0];
  double data[6];

  while(!((to->time >= var_timer) && (var_timer >= from->time)))
  {
    /*printf("mf:\n%u, [%i %i %i] [%i %i %i]\n", from->time, from->data[0],
	from->data[1], from->data[2], from->data[3], from->data[4],
	from->data[5]);
    printf("mt:\n%u, [%i %i %i] [%i %i %i]\n", to->time, to->data[0],
	to->data[1], to->data[2], to->data[3], to->data[4], to->data[5]);*/
    to++;
    from++;
  }

  /*printf("0:\n%u, [%i %i %i] [%i %i %i]\n", from->time, from->data[0],
      from->data[1], from->data[2], from->data[3], from->data[4],
      from->data[5]);

  printf("1:\n%u, [%i %i %i] [%i %i %i]\n", to->time, to->data[0],
      to->data[1], to->data[2], to->data[3], to->data[4], to->data[5]);*/

  float mul = (float)(var_timer - from->time) /
    (float)(to->time - from->time);

  // Laske arvot
  interpolate_linear_i16d(data, from->data, to->data, mul, 5);

  // Katso
  gluLookAt(data[0], data[1], data[2], data[3], data[4], data[5],
      0.0, 1.0, 0.0);
}

//############################################################################
// Valopilari ################################################################
//############################################################################

#define LIGHTPILLAR_CNT		5
#define LIGHTPILLAR_WIDTH	5.0f
#define LIGHTPILLAR_HEIGHT	300.0f
#define LIGHTPILLAR_ROT		0.03
#define LIGHTPILLAR_SHARD_COMP	9
#define LIGHTPILLAR_SHARD_ARC	(M_PI / 1.8f)


typedef struct
{
  float height, width, radius;
  int lifetime, delay;
  Uint32 col;
} LightPillarParams;

// Eräänlainen valopilari
LightPillarParams pillar_draw = { 300.0f, 2.0f, 0.5f, 90, 10, 0x99888888 };
LightPillarParams pillar_wings = { 400.0f, 16.0f, 80.0f, 300, 2, 0xFFC05050 };

// Paskat muistista, generoidaan yksi joka framelle!
float var_pillar_shard[TIME_END * TIMER_MS];
float var_pillar_shape[(LIGHTPILLAR_SHARD_COMP + 1) * 3];
Uint32 var_pillar_alpha[(LIGHTPILLAR_SHARD_COMP + 1)];

// Esilaske joka framelle uniikki pilari!
void efu_light_pillar_precalc()
{
  int i = TIME_END * TIMER_MS - 1;
  do
  {
    var_pillar_shard[i] = rand_float(M_PI * 2.0f);
  } while(i--);
  i = LIGHTPILLAR_SHARD_COMP;
  do
  {
    float *ver = &var_pillar_shape[i * 3],
	  ang = (LIGHTPILLAR_SHARD_ARC / 2.0f) - LIGHTPILLAR_SHARD_ARC *
	    ((float)i / (float)LIGHTPILLAR_SHARD_COMP),
	  mul = sin((float)(i + 1) / (float)(LIGHTPILLAR_SHARD_COMP + 2) *
	      M_PI);
    ver[0] = cos(ang) - 1.0f;
    ver[1] = mul;
    ver[2] = sin(ang);
  } while(i--);
}

void efu_light_pillar_shard(float *pos, float mul, float ang,
    LightPillarParams *params)
{
  float ca = cos(ang) * params->width,
	sa = sin(ang) * params->width,
	rad = mul * params->radius,
	dx = cos(ang) * rad,
	dz = sin(ang) * rad;
  int i = LIGHTPILLAR_SHARD_COMP - 1;
  do
  {
    array_add_index(var_vertex_ins + i * 2 + 0);
    array_add_index(var_vertex_ins + i * 2 + 1);
    array_add_index(var_vertex_ins + i * 2 + 3);
    array_add_index(var_vertex_ins + i * 2 + 2);
  } while(i--);
  i = LIGHTPILLAR_SHARD_COMP;
  do
  {
    // Nuo ovat väärinpäin, en tiedä missä on vika...
    float *ver = &var_pillar_shape[i * 3],
	  x = (ver[0] * ca - ver[2] * sa) + dx + pos[0],
	  z = (ver[2] * ca + ver[0] * sa) + dz + pos[2];
    // Tehdään värin kerroin
    float brightness_mul = sin((float)i / (float)LIGHTPILLAR_SHARD_COMP *
	M_PI);
    Uint32 col = 0;
    int j = 24;
    for(; j >= 0; j-= 8) 
    {
      col |= (Uint32)((float)((params->col & (0xFF << j)) >> j) *
	  brightness_mul) << j;
    }
    array_add_vertex(x, 0.0f, z, col);
    array_add_vertex(x, (ver[1] * params->height * (1.0f - mul)), z,
	0x00000000);
  } while(i--);

  /*array_add_index(var_vertex_ins);
  array_add_index(var_vertex_ins + 3);
  array_add_index(var_vertex_ins + 2);
  array_add_index(var_vertex_ins + 2);
  array_add_index(var_vertex_ins + 1);
  array_add_index(var_vertex_ins + 3);
  array_add_index(var_vertex_ins + 2);
  array_add_index(var_vertex_ins + 2);
  array_add_vertex(pos[0] + dx + ca, 0.0f, pos[2] + dz + sa, 0x00000000);
  array_add_vertex(pos[0] + dx - ca, 0.0f, pos[2] + dz - sa, 0x00000000);
  array_add_vertex(pos[0] + dx, 0.0f, pos[2] + dz, params->col);
  array_add_vertex(pos[0] + dx, (1.0f - mul) * params->height, pos[2] + dz,
      0x00000000);*/
}

/*
 * Piirtää yhden valopilarin ennalta annetuilla asetuksilla.
 */
int efu_light_pillar(float *pos, int stime, int etime,
    LightPillarParams *params)
{
  int i = stime;
  Uint32 base = var_vertex_ins;

  // Perutaanko suoraan?
  if(var_timer > etime + params->lifetime)
    return 1;

  /*printf("Vertex: %f, %f, %f, %i\nTime: %i\n", pos[0], pos[1], pos[2],
      var_index_ins, var_timer);*/

  for(i = stime; (i <= var_timer); i += params->delay)
    if((i + params->lifetime >= var_timer) && (i < etime))
    {
      //printf("Drawing pillar: %i\n", i);
      efu_light_pillar_shard(pos,
	  (float)(var_timer - i) / (float)params->lifetime,
	  var_pillar_shard[i], params);
    }
  //printf("After: %f, %f, %f, %i\n", pos[0], pos[1], pos[2], var_index_ins);
  return 0;
}

//############################################################################
// Ympyrät ###################################################################
//############################################################################

#define CIRCLES_RADIALS		13
#define CIRCLES_SECTORS		48
#define CIRCLES_RADIUS		10.0f
#define CIRCLES_HEIGHT_BASE	60.0f
#define CIRCLES_HEIGHT_VAR	40.0f
#define CIRCLES_HEIGHT_SPEED	1.0f
#define CIRCLES_SPEED		20
#define CIRCLES_RUNNER_MAX	5
#define CIRCLES_OFF		0
#define CIRCLES_CCW		1
#define CIRCLES_CW		2
#define CIRCLES_IN		3
#define CIRCLES_OUT		4
#define CIRCLES_CFLOOR		0x995555FF
#define CIRCLES_CCEIL		0xFF00FFFF

char var_circles[CIRCLES_RADIALS * CIRCLES_SECTORS];

typedef struct
{
  int radial, sector, dir, stime, etime;
} CirclesRunner;

CirclesRunner var_runner[CIRCLES_RUNNER_MAX];

void efu_circles_create_runner(unsigned radial, unsigned sector, unsigned dir,
    int elapsed)
{
  int i;

  for(i = 0; i < CIRCLES_RUNNER_MAX; i++)
    if(var_runner[i].dir == 0)
    {
      CirclesRunner *alkio = &var_runner[i];
      alkio->radial = radial;
      alkio->sector = sector;
      alkio->dir = dir;
      alkio->stime = elapsed;
      return;
    }
}

int efu_circles_dir_ok(int idx)
{
  if((idx >= 0) && (idx < CIRCLES_SECTORS * CIRCLES_RADIALS))
    if(var_circles[idx] == 0)
      return 1;
  return 0;
}

void efu_circles_new_direction(CirclesRunner* op, int *dir, int elapsed)
{
  int i = 5;

  do
  {
    int j = rand_int(4);
    if(efu_circles_dir_ok(dir[j]))
    {
      op->dir = j + 1;
      return;
    }
  } while(--i);

  op->dir = -1;
  op->etime = elapsed;
}

int efu_circles_idx(int radial, int sector)
{
  if(radial < 0)
    return -1;
  else if(radial >= CIRCLES_RADIALS)
    return -1;
  return radial * CIRCLES_SECTORS + modulo(sector, CIRCLES_SECTORS);
}

void efu_circles_expire_runner(CirclesRunner *op, int elapsed)
{
  int idx = op->radial * CIRCLES_SECTORS + op->sector;
  if(efu_light_pillar(&var_vertex_array[idx * 2 * 3], op->stime,
	op->etime, &pillar_draw))
    op->dir = 0;
}

void efu_circles_runner(CirclesRunner* op, int left, int elapsed)
{
  // Jos ei mitään niin ei tehdä
  if(op->dir == 0)
    return;
  // Jos enää pelkkä pilari
  else if(op->dir == -1)
  {
    if(left <= CIRCLES_SPEED)
      efu_circles_expire_runner(op, elapsed);
    return;    
  }
  // Muutoin voidaan jatkaa

  int curr = op->radial * CIRCLES_SECTORS + op->sector;
  int dir[4] =
  {
    dir[0] = efu_circles_idx(op->radial, op->sector - 1),
    dir[1] = efu_circles_idx(op->radial, op->sector + 1),
    dir[2] = efu_circles_idx(op->radial - 1, op->sector),
    dir[3] = efu_circles_idx(op->radial + 1, op->sector)
  };

  /*printf("Time left: %i, dir: %i\n", left, op->dir);
  printf("Radial: %i, sector: %i\n", op->radial, op->sector);
  printf("Dirs: %i, %i, %i, %i (curr: %i, of %i)\n", dir[0], dir[1], dir[2],
      dir[3], curr, CIRCLES_RADIALS * CIRCLES_SECTORS);
  printf("Spot: %i\n", var_circles[dir[op->dir - 1]]);*/

  // Jos loppuu puhti, lopeta
  if(efu_circles_dir_ok(dir[op->dir - 1]) == 0)
  {
    //printf("Changing direction!\n");
    efu_circles_new_direction(op, dir, elapsed);
  }
  if(op->dir <= 0)
  {
    efu_circles_expire_runner(op, elapsed);
    return;
  }

  // Valitaan ja tehdään neliö
  int next = dir[op->dir - 1];
  /*printf("Making quad: %i, %i, %i, %i\n", curr * 2, curr * 2 + 1,
      next * 2 + 1, next * 2);*/
  // Insertoi
  array_add_index(curr * 2);
  array_add_index(curr * 2 + 1);
  if(left > CIRCLES_SPEED)
  {
    array_add_index(next * 2 + 1);
    array_add_index(next * 2);
  }
  else
  {
    float len = (float)left / (float)CIRCLES_SPEED;
    //printf("Interpolate: %f\n", len);
    array_add_index(var_vertex_ins + 1);
    array_add_index(var_vertex_ins);
    array_interpolate_vertex(curr * 2, next * 2, len, CIRCLES_CFLOOR);
    array_interpolate_vertex(curr * 2 + 1, next * 2 + 1, len, CIRCLES_CCEIL);
    efu_light_pillar(&var_vertex_array[var_vertex_ins * 3 - 6], op->stime,
	TIME_END, &pillar_draw);
  }

  // Käytetty
  var_circles[next] = 1;

  // Jatkamme matkaa
  switch(op->dir)
  {
    case CIRCLES_CCW:
      op->sector -= 2;
    case CIRCLES_CW:
      op->sector++;
      op->sector = modulo(op->sector, CIRCLES_SECTORS);
      break;
    case CIRCLES_IN:
      op->radial -= 2;
    case CIRCLES_OUT:
      op->radial++;
      //efu_circles_new_direction(op, dir);
      break;
  }

  // Vaihda suuntaa
  if(!rand_int(35) || ((op->dir >= CIRCLES_IN) && rand_int(2))) // 35, 2
    op->dir = rand_int(4) + 1;

  // Jakaudu
  if(!rand_int(30)) // 30
    efu_circles_create_runner(op->radial, op->sector, rand_int(4) + 1,
	elapsed);
}

/*
 * Ympyräefun ylihommeli.
 */
void efu_circles(void)
{
  int i, j, k;

  //rand_seed(0xF56927269);
  rand_seed(1452438121);

  //glColor3f(1.0f, 1.0f, 1.0f);

  var_index_ins = var_color_ins = var_vertex_ins = 0;
  // Generate the vertices
  for(i = 0; i < CIRCLES_RADIALS; i++)
    for(j = 0; j < CIRCLES_SECTORS; j++)
    {
      int idx = i * CIRCLES_SECTORS + j;
      float ang = (float)j / (float)CIRCLES_SECTORS * M_PI * 2;
      float rad = (i + 1) * CIRCLES_RADIUS;
      // Korkeus on monimutk.
      float height = interpolate_sine(CIRCLES_HEIGHT_BASE / 2.0f,
	CIRCLES_HEIGHT_VAR / 2.0f, (float)j + (float)var_timer / 100.0f,
	CIRCLES_HEIGHT_SPEED) + interpolate_sine(CIRCLES_HEIGHT_BASE / 2.0f,
	  CIRCLES_HEIGHT_VAR / 2.0f,
	  (float)j * 1.5f + (float)var_timer / 15.0f, -CIRCLES_HEIGHT_SPEED);
      array_add_vertex(cos(ang) * rad, 0.0f, sin(ang) * rad, CIRCLES_CFLOOR);
      array_add_vertex(cos(ang) * rad, height, sin(ang) * rad, CIRCLES_CCEIL);
    }

  // Piirretään
  memclr(var_circles, CIRCLES_RADIALS * CIRCLES_SECTORS);
  var_circles[0] = 1;
  memclr(var_runner, CIRCLES_RUNNER_MAX * sizeof(CirclesRunner));
  efu_circles_create_runner(CIRCLES_RADIALS - 1, 0, CIRCLES_CCW, CIRCLES_START);
  for(i = var_timer, j = CIRCLES_START; i > 0;
      i -= CIRCLES_SPEED, j += CIRCLES_SPEED)
    for(k = 0; k < CIRCLES_RUNNER_MAX; k++)
      efu_circles_runner(&var_runner[k], i, j);

  if(var_timer > WINGS_START)
  {
    float pos[3] = { 0, 0, 0 };
    efu_light_pillar(&pos[0], WINGS_START, WINGS_END, &pillar_wings);
  }
  
  /*float pos[3] = { 0, 0, 0 };
  LightPillarParams prm = { 400.0f, 40.0f, 25.0f, 1000, 100, 0x22C05050 };
  efu_light_pillar(pos, 0, 200, &prm);*/

  glDrawElements(GL_QUADS, var_index_ins, GL_UNSIGNED_INT, var_index_array);
}

//############################################################################
// Main ######################################################################
//############################################################################

int main(void)
{
  // Lokaalit muuttujat
  int loop = 1;
  SDL_Event event;
  SDL_Surface *screen;

  // Kaikki precalc tähän
  efu_light_pillar_precalc();

  // SDL init
  SDL_Init(SDL_INIT_TIMER | SDL_INIT_VIDEO | SDL_INIT_AUDIO);
  screen = SDL_SetVideoMode(SCREEN_W, SCREEN_H, SCREEN_B, SDL_GFX_FLAGS);
  SDL_SetTimer(TIMER_MS, timer_func);

  // GL init
  glViewport(0, 0, SCREEN_W, SCREEN_H);
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glClearDepth(1.0);
  //glDepthFunc(GL_LEQUAL);
  glDisable(GL_DEPTH_TEST);
  glShadeModel(GL_SMOOTH);

  // Ajastin nollaan
  var_timer = 0;

  // Vertex array päälle
  glEnableClientState(GL_COLOR_ARRAY);
  glEnableClientState(GL_VERTEX_ARRAY);
  glColorPointer(4, GL_UNSIGNED_BYTE, 0, var_color_array);
  glVertexPointer(3, GL_FLOAT, 0, var_vertex_array);

  // Blend päälle
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE_MINUS_SRC_ALPHA, GL_ONE);

  // Skip
  var_timer = 4000;

  // Loop
  while(loop)
  {
    // Tyhjennys
    glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
    // Projektiomatriisi joka frame koska joo
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(90.0 * (float)SCREEN_H / (float)SCREEN_W,
	(float)SCREEN_W / (float)SCREEN_H, 1.0, 1000.0);
    // Matrixmode takaisin
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    // Katsellaan
    look_at();
    // Efu
    efu_circles();
    // Ruudulle
    SDL_GL_SwapBuffers();
    // Pois jos nappia painettu
    if(((SDL_PollEvent(&event)) && (event.key.keysym.sym == SDLK_ESCAPE)) ||
	(var_timer >= TIME_END))
      loop = 0;
  }

  // Pois
  SDL_Quit();
  return 0;
}

//############################################################################
// Loppu #####################################################################
//############################################################################
