--
-- The startup screen
--

-- Called every frame (hiscore)
function update_startup( time_step )
	-- Camera position
	local cam_pos = SceneGetSpecialPos( start_scene, "CameraPos" )
	CamSet( cam_pos - Vec2( 400, 300 ) )

	-- Skip?
	if had_launch and not keys.launch then startup_left = 0 end
	had_launch = keys.launch

	-- Done?
	startup_left = startup_left - time_step

	if startup_left <= 0 then
		SceneRemove( start_scene )

		HudSetVisible( true )
		setup_menu()
		return
	end
end

-- Sets the up the hiscore mode
function setup_startup()
	print( "Startup screen" )

	startup_left = 7

	-- Spawn the world
	start_scene = SceneSpawn( "Splash_Screen" )
	HudSetVisible( false )

	-- Set the callbacks
	reset_callbacks()
	update = update_startup
end

