--
-- The game "menu"
--

-- Called every frame (menu)
function update_menu( time_step )
	world_update( time_step, false, false )

	-- Scroll the text
	if HudIsClear() then
		menu_texts[ menu_show_idx ]()
		menu_show_idx = menu_show_idx + 1
		if menu_show_idx > table.getn( menu_texts ) then menu_show_idx = 1 end
	end

	-- New camera position
	menu_cam_angle = menu_cam_angle + time_step * 0.3

	local cam_center = SceneGetSpecialPos( main_scene, "MenuCamera" )
	cam_center = cam_center + Vec2( math.cos( menu_cam_angle * 0.6143823 ) * 100, math.sin( menu_cam_angle ) * 500 )
	CamSet( cam_center - Vec2( 400, 300 ) )

	-- Starting a game?
	if had_s1 and (not keys.start1) then setup_game( 1 ) end
	if had_s2 and (not keys.start2) then setup_game( 2 ) end
	if had_s3 and (not keys.start3) then setup_game( 3 ) end
	if had_s4 and (not keys.start4) then setup_game( 4 ) end
	had_s1 = keys.start1
	had_s2 = keys.start2
	had_s3 = keys.start3
	had_s4 = keys.start4
end

-- Sets up the game to the menu mode
function setup_menu()
	print( "Menu screen" )
	MusicPlay( "menu.ogg" )

	-- Fresh world
	spawn_world()
	CamSet( Vec2( 600, 200 ) )

	-- Fresh HUD
	HudClear()
	HudSetPlayers( 0 )

	menu_cam_angle = 0

	-- Pick the texts to show
	local scores = get_hiscores()

	local show_intro_fun1 = function() HudScrollText( INTRO_TEXT1, 55 ) end
	local show_intro_fun2 = function() HudScrollText( INTRO_TEXT2, 55 ) end
	menu_texts = { show_intro_fun1 }
	for key,value in scores do
		local v = value
		menu_texts[ table.getn(menu_texts) + 1 ] = function() HudShowText( v, 2.5 ) end
	end
	menu_texts[ table.getn(menu_texts) + 1 ] = show_intro_fun2

	menu_show_idx = 1

	-- Set the callbacks
	reset_callbacks()
	update = update_menu
end


-- Intro text
INTRO_TEXT1 = "### Factory Pinball ###"

INTRO_TEXT2 =
[[Press F1 to F4 to start the game (1 to 4 players).
 Esc quits the game at any time.
 Hit enter to launch the ball.
 Use the left and right shift keys to control the paddles.
 Space pushes the board but be careful.
         2005 XZM productions
         Code: XMunkki (Jere Sanisalo), Gfx: Random (Lauri Maki), Audio: JopePyssy (Jukka Nikkonen)     ]]
