--
-- Hiscore functionality
--

-- Called every frame (hiscore)
function update_hiscore( time_step )
	world_update( time_step, false, false )

	-- Text over?
	if hiscore_gameover_text and not HudIsClear() then return end
	hiscore_gameover_text = false

	-- Find the current hiscore input index
	local hi_amt = table.getn( hiscores )
	while hiscore_idx <= hi_amt do
		if hiscores[ hiscore_idx ][ 3 ] ~= nil then break end
		hiscore_idx = hiscore_idx + 1
	end

	-- Done with the input?
	if hiscore_idx > hi_amt then
		HudClear()
		setup_game_end()
		return
	end

	-- Get the name
	local letters = string.len( hiscore_letters )
	if hiscore_letter < 1 then hiscore_letter = letters end
	if hiscore_letter > letters then hiscore_letter = 1 end

	local letter = string.sub( hiscore_letters, hiscore_letter, hiscore_letter )

	local plr = hiscores[ hiscore_idx ][ 3 ]
	local msg = "Plr " .. plr .. " name: " .. hiscore_name .. letter
	HudShowText( msg, 99999 )

	-- Get the controls
	if not had_lpad and keys.lpad then
		hiscore_letter = hiscore_letter - 1
		lpad_countdown = 0.2
	end
	if not had_rpad and keys.rpad then
		hiscore_letter = hiscore_letter + 1
		rpad_countdown = 0.2
	end
	if not had_launch and keys.launch then
		hiscore_name = hiscore_name .. letter

		-- Done with this name?
		if string.len( hiscore_name ) >= 3 then
			-- Set
			hiscores[ hiscore_idx ][ 1 ] = hiscore_name
			hiscores[ hiscore_idx ][ 3 ] = nil

			-- Save
			hiscore_save()

			-- Next
			hiscore_idx = hiscore_idx + 1
			hiscore_name = ""
			hiscore_letter = 1
		end
	end

	had_lpad = keys.lpad
	had_rpad = keys.rpad
	had_launch = keys.launch

	-- The key repeat countdowns
	if not had_lpad then lpad_countdown = 0 end
	if not had_rpad then rpad_countdown = 0 end

	if lpad_countdown > 0 then
		lpad_countdown = lpad_countdown - time_step
		if lpad_countdown <= 0 then had_lpad = false end
	end
	if rpad_countdown > 0 then
		rpad_countdown = rpad_countdown - time_step
		if rpad_countdown <= 0 then had_rpad = false end
	end
end


-- Loads the hiscore list
function hiscore_load()
	local get_score =
		function( idx, defname, defval )
		local name = PropertyGet( "score" .. idx .. "name" )
		local val = PropertyGet( "score" .. idx .. "value" )
		if name == nil or val == nil then return {defname, defval} else return {name, tonumber( val )} end
		end

	hiscores =
	{
		get_score( 1, "XMU", 3000000 ),
		get_score( 2, "RND", 2000000 ),
		get_score( 3, "JOP", 1000000 )
	}
end

-- Saves the hiscore list
function hiscore_save()
	for key,value in hiscores do
		PropertySet( "score" .. key .. "name", value[ 1 ] )
		PropertySet( "score" .. key .. "value", value[ 2 ] )
	end
end

-- Returns the hiscore strings
function get_hiscores()
	local ret = {}
	for key,value in hiscores do
		ret[ key ] = key .. ". " .. value[1] .. "  " .. value[2]
	end
	return ret
end

-- Checks the hiscores (if one of the players has a new hiscore)
function check_hiscores( scores )
	local hi_amt = table.getn( hiscores )

	local make_space =
		function( idx )
		for i = hi_amt+1,idx+1,-1 do hiscores[ i ] = hiscores[ i-1 ] end
		hiscores[ hi_amt + 1 ] = nil
		end

	local find_pos =
		function( score )
		for i = 1, hi_amt do if score >= hiscores[ i ][ 2 ] then return i end end
		return -1
		end

	-- Add each player
	for plr,score in scores do
		local pos = find_pos( score )
		if pos > 0 then
			make_space( pos )
			hiscores[ pos ] = { "AAA", score, plr }
		end
	end

	-- Prepare the UI
	hiscore_idx = 1
	hiscore_letter = 1
	hiscore_name = ""
end

-- Sets the up the hiscore mode
function setup_hiscore( scores )
	print( "Hiscore checks" )

	SceneRemove( player_scene )
	HudScrollText( "GAME OVER", 100 )

	hiscore_gameover_text = true

	-- Check the hiscores
	check_hiscores( scores )

	-- Set the callbacks
	reset_callbacks()
	update = update_hiscore
end

-----------------------

hiscore_letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 "

hiscore_load()
