--
-- Game end mode
--

-- Called every frame (end game)
function update_game_end( time_step )
	world_update( time_step, false, false )

	-- Starting a new game? (exit to menu and let it handle it)
	if keys.start1 or keys.start2 or keys.start3 or keys.start4 then
		setup_menu()
	end

	-- End of mode and move on to the menu?
	game_end_pause = game_end_pause - time_step
	if game_end_pause < 0 then setup_menu() end
end

-- Sets the up the game end mode
function setup_game_end()
	print( "Game ended" )

	SceneRemove( player_scene )
	HudClear()

	game_end_pause = 5

	-- Set the callbacks
	reset_callbacks()
	update = update_game_end
end
