!!ARBfp1.0  
PARAM lightpos0     = state.light[0].position;  
PARAM lightdiff0    = state.lightprod[0].diffuse ;
PARAM lightspec0    = state.light[0].specular ;
PARAM lighthalf0    = state.light[0].half ;
PARAM matemission   = state.material.emission ;
PARAM matshininess  = state.material.shininess ;
PARAM eyepos		= program.local[2] ;
PARAM eta			= program.local[3] ;
ATTRIB pixelpos		= fragment.texcoord[4] ;
ATTRIB pixelnorm	= fragment.texcoord[5] ;
ATTRIB lightglobal  = fragment.texcoord[6] ;
PARAM  c[1]			= {{1,0}} ;
TEMP   temp,temp1,temp2,L,norm,refmap,decal,Rf,spec ;	
TEMP   diffuse_color0,specular_color0 ;
#Vector orientet to light direction
SUB		temp,lightpos0,pixelpos ;
DP3     L.w,temp,temp ;
RSQ		L.w,L.w ;
MUL     L.xyz,L.w,temp ;
#Normalize normal-vector
DP3     norm.w,pixelnorm,pixelnorm;
RSQ		norm.w,norm.w ;
MUL     norm.xyz,norm.w,pixelnorm ;
#Refraction vector
SUB		temp,pixelpos,eyepos;
MOV		temp1.xyz, norm;
DP3		temp1.x, -temp, temp1;
MAD		temp1.z, -temp1.x, temp1.x, c[0].x;
MUL		temp1.y, eta.x, eta;
MAD		temp1.w, -temp1.y, temp1.z, c[0].x;
ABS		temp1.y, temp1.w;
RSQ		temp1.y, temp1.y;
RCP		temp1.y, temp1.y;
MAD		temp2.x, eta, temp1, -temp1.y;
MOV		temp1.xyz, temp;
MUL		temp2.xyz, temp2.x, norm;
MAD		temp1.xyz, eta.x, temp1, temp2;
SLT		temp1.w, c[0].y, temp1;
MUL		Rf.xyz, temp1, temp1.w;
#Diffuse light element
DP3		temp,norm,L ;
MAX		temp,temp,0 ;		
MUL		temp,lightglobal.w,temp;				   
MUL     diffuse_color0,temp,lightdiff0 ;
#Specular light element
DP3		temp,norm,lighthalf0 ;
MAX		temp1,temp,0 ;
POW		temp,temp1.x,matshininess.x ;
TEX		spec,fragment.texcoord[3],texture[3],2D;
MUL		temp1,temp,spec.xxxx ;
MUL		temp1,lightglobal.w,temp1;
MUL		temp1,lightspec0,temp1 ;
SGE		temp,diffuse_color0,0 ;
MAD		specular_color0,temp,temp1,diffuse_color0; 
#All together
ADD		temp.xyz,lightglobal,specular_color0 ;
TEX		decal,fragment.texcoord[0],texture[0],2D;
TEX		refmap, Rf,texture[1],CUBE;
MUL		decal,lightglobal.w,decal;
LRP		decal,spec.yyyy,refmap,decal ;
MAD_SAT	result.color,temp,decal,matemission ;
MOV		result.color.w,spec.z;
END  
