#include "general.h"
#include "objekth.h"
#include <fstream.h>
#include<iostream>
#include <windows.h>
#include <gl/glut.h>
#include "timer.h"
#include <math.h>
#include "camera.h"
#include "texture.h"
#include "shader.h"

#define KEYDOWN(vk_code) ((GetAsyncKeyState(vk_code)) &0x8000 ? 1:0)

#ifndef M_PI
#define M_PI 3.141592654
#endif

GLfloat mat_diffGreen[]={0.0,1.0,0.0};
GLfloat mat_diffBlack[]={0.0,1.0,1.0};

//STA_MESH_FILE::STA_MESH_FILE()
//{

	//set the current matrix to be identity matrix...
void STA_MESH_FILE::LoadPolygonDta(char *spaFile)
{
	unsigned int ID;
	//this loads in crucial info from a binary file on the harddisc.
	ifstream myfile(spaFile,ios::binary);
	myfile.read((char*)&ID,sizeof(unsigned int));
	if(ID!=0x57A71C)
	{
		std::cout<<"not an sat file"<<std::endl;
		return;
	}
	
	myfile.read((char*)&nrVert,sizeof(unsigned int));
	//allocate the need space..
	
	vertices = new VERTEX[nrVert];
	myfile.read((char*)vertices,sizeof(float)*nrVert*3);
	myfile.read((char*)&nrFace,sizeof(nrFace));
	faces = new unsigned int[nrFace*3];
	myfile.read((char*)faces,sizeof(faces)*nrFace*3);
	myfile.read((char*)&nrMat,sizeof(nrMat));
	if(nrMat)
	{
	matArray = new unsigned int[nrFace];
	myfile.read((char*)matArray,sizeof(matArray)*nrFace);
	}
	myfile.read((char*)&nrNormface,sizeof(nrNormface));
	facenorm = new VERTEX[nrNormface];
	myfile.read((char*)facenorm,sizeof(float)*nrNormface*3);
	myfile.read((char*)&nrNormvert,sizeof(nrNormvert));
	vertnorm = new VERTEX[nrNormvert];
	myfile.read((char*)vertnorm,sizeof(float)*nrNormvert*3);
	myfile.close();
	

}

void STA_MESH_FILE::DrawPolygonDta()
{
	//here I just draw the god damn polygon data.. BIATCH!

	
	glBegin(GL_TRIANGLES);
	for(int i =0; i <nrFace;i++)
	{
		//WELL HERE SOME MATARIAL THINGS GOES SOMETIMES, BUT MUST COLLECT STRUCTRE AND
		//MAKE IT USABLE.. DO NOT STORE HERE:: OBJECT WITHOUT MATERIAL MUST ALSO BE LOADED
		
		/*if(matArray[i]==2)
			glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_diffBlack);
		else
			glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_diffGreen);*/
		for (int j=0; j < 3; j++)
		{
			glTexCoord3d(	vertices[(faces[i*3+j])].x, 
							vertices[(faces[i*3+j])].y,
							vertices[(faces[i*3+j])].z);

			glNormal3f(	vertnorm[(faces[i*3+j])].x,
							vertnorm[(faces[i*3+j])].y,
							vertnorm[(faces[i*3+j])].z);

			

			glVertex3f(	vertices[(faces[i*3+j])].x, 
							vertices[(faces[i*3+j])].y,
							vertices[(faces[i*3+j])].z);
		}
	}
glEnd();
}

void STA_MESH_FILE::setPosVector(float x,float y,float z)
{
	mPosVector.x +=x;
	mPosVector.y+=y;
	mPosVector.z+=z;
}

void STA_MESH_FILE::handleInput()
{
	//PUSH IT!!
	//glPushMatrix();
	//here the keychecking will be done..
	if(KEYDOWN(VK_UP))
	{
		moveMesh(0,0,-0.5);
	}
		
	if(KEYDOWN(VK_DOWN))
	{
		moveMesh(0,0,0.5);
		//do action for objekt down.. key down
	}

		if(KEYDOWN(VK_LEFT))
		{
			rotateMesh(M_PI/2,0,1,0);
			//do action for objekt left
		}
		
	if(KEYDOWN(VK_RIGHT))
	{
		//do action for objekt right
		rotateMesh(M_PI/2,0,1,0);
	}

	if(KEYDOWN(VK_SPACE))
	rotateMesh(90,1,0,0);

	//if(KEYDOWN(VK_SPACE))
	//rotateMesh(4,0,0,1);
	
		


	
	
	
}

		
void STA_MESH_FILE::rotateMesh(double angle,int x,int y,int z)
{

while(angle<0)
angle+=360;	

	static MATRIX4X4 rotX;
	static MATRIX4X4 rotZ;
	 static MATRIX4X4 rotY;
	if(x)
	{
	
		
			rotX.MATRIX[0]=1.0;
			rotX.MATRIX[1]=0.0;
			rotX.MATRIX[2]=0.0;
			rotX.MATRIX[3]=0.0;
			rotX.MATRIX[4]=0.0;
			rotX.MATRIX[5]=cos(angle);
			rotX.MATRIX[6]=-sin(angle);
			rotX.MATRIX[7]=0.0;
			rotX.MATRIX[8]=0.0;
			rotX.MATRIX[9]=sin(angle);
			rotX.MATRIX[10]=cos(angle);
			rotX.MATRIX[11]=0.0;
			rotX.MATRIX[12]=0.0;
			rotX.MATRIX[13]=0.0;
			rotX.MATRIX[14]=0.0;
			rotX.MATRIX[15]=1.0;
			
		translateMesh(-mPosVector.x,-mPosVector.y,-mPosVector.z);			
		currentMatrix = currentMatrix*rotX;	
		translateMesh(mPosVector.x,mPosVector.y,mPosVector.z);
		//now do the things you need to do!
		
		
		
	}

	if(y)
	{
		
		
			rotY.MATRIX[0]=cos(angle);
			rotY.MATRIX[1]=0.0;
			rotY.MATRIX[2]=sin(angle);
			rotY.MATRIX[3]=0.0;
			rotY.MATRIX[4]=0.0;
			rotY.MATRIX[5]=1.0;
			rotY.MATRIX[6]=0.0;
			rotY.MATRIX[7]=0.0;
			rotY.MATRIX[8]=-sin(angle);
			rotY.MATRIX[9]=0.0;
			rotY.MATRIX[10]=cos(angle);
			rotY.MATRIX[11]=0.0;
			rotY.MATRIX[12]=0.0;
			rotY.MATRIX[13]=0.0;
			rotY.MATRIX[14]=0.0;
			rotY.MATRIX[15]=1.0;
translateMesh(-mPosVector.x,-mPosVector.y,-mPosVector.z);			
		currentMatrix = currentMatrix*rotY;	
		translateMesh(mPosVector.x,mPosVector.y,mPosVector.z);
			
			//move to the origo :)

		
			
			
			

	}
	
	if(z)
	{
	
		
	/*	rotZ.MATRIX[0]=COSTABLE[angle];
		rotZ.MATRIX[1]=-SINTABLE[angle];
		rotZ.MATRIX[2]=0;
		rotZ.MATRIX[3]=0;
		rotZ.MATRIX[4]=SINTABLE[angle];
		rotZ.MATRIX[5]=COSTABLE[angle];
		rotZ.MATRIX[6]=0;
		rotZ.MATRIX[7]=0;
		rotZ.MATRIX[8]=0;
		rotZ.MATRIX[9]=0;
		rotZ.MATRIX[10]=1;
		rotZ.MATRIX[11]=0;
		rotZ.MATRIX[12]=0;
		rotZ.MATRIX[13]=0;
		rotZ.MATRIX[14]=0;
		rotZ.MATRIX[15]=1;*/

		
		
		
	}
	

		translateMesh(-mPosVector.x,-mPosVector.y,-mPosVector.z);
		//rotY=rotY*rotZ;
		//rotY=rotY*rotX;
		
	
	//currentMatrix = currentMatrix*rotZ;
	
			
				//currentMatrix = currentMatrix*rotY;

				
				//currentMatrix = currentMatrix*rotX;
		//	translateMesh(mPosVector.x,mPosVector.y,mPosVector.z);


		/*		translateMesh(-mPosVector.x,-mPosVector.y,-mPosVector.z);
		
			translateMesh(mPosVector.x,mPosVector.y,mPosVector.z);

			
			translateMesh(-mPosVector.x,-mPosVector.y,-mPosVector.z);
			
			translateMesh(mPosVector.x,mPosVector.y,mPosVector.z);*/

	

}

void STA_MESH_FILE::translateMesh(float x,float y,float z)
{
	
	MATRIX4X4 transMat;

	
	//init our strange little matrix :)
	transMat.MATRIX[0] =1;
	transMat.MATRIX[1] =0;
	transMat.MATRIX[2] =0;
	transMat.MATRIX[3] =0;
	//next line
	transMat.MATRIX[4]=0;
	transMat.MATRIX[5]=1;
	transMat.MATRIX[6]=0;
	transMat.MATRIX[7]=0;
	//next line..
	transMat.MATRIX[8]=0;
	transMat.MATRIX[9]=0;
	transMat.MATRIX[10]=1;
	transMat.MATRIX[11]=0;
	//the important line
	

//OK, WE NEED TO TAKE CARE OF SOMETHING FUN :)
//THE TRANSLATION SHOULD RELATE TO THE VIEWVECTOR! AND WE MAKE SOMETHING COOL HERE :)

	

	transMat.MATRIX[12]=x;
	transMat.MATRIX[13]=y;
	transMat.MATRIX[14]=z;
	transMat.MATRIX[15]=1;
	
	currentMatrix = currentMatrix*transMat;
	

	
	

}

void STA_MESH_FILE::moveMesh(float x, float y,float z)
{
	
	//set up a translation matrix :)
	MATRIX4X4 transMat;

	
	//init our strange little matrix :)
	transMat.MATRIX[0] =1;
	transMat.MATRIX[1] =0;
	transMat.MATRIX[2] =0;
	transMat.MATRIX[3] =0;
	//next line
	transMat.MATRIX[4]=0;
	transMat.MATRIX[5]=1;
	transMat.MATRIX[6]=0;
	transMat.MATRIX[7]=0;
//next line..
	transMat.MATRIX[8]=0;
	transMat.MATRIX[9]=0;
	transMat.MATRIX[10]=1;
	transMat.MATRIX[11]=0;
	//the important line
	//we move x=2,y=5,z=-5

//OK, WE NEED TO TAKE CARE OF SOMETHING FUN :)
//THE TRANSLATION SHOULD RELATE TO THE VIEWVECTOR! AND WE MAKE SOMETHING COOL HERE :)

	

	transMat.MATRIX[12]=-currentMatrix.MATRIX[2]*z;
	transMat.MATRIX[13]=currentMatrix.MATRIX[6]*z;
	transMat.MATRIX[14]=currentMatrix.MATRIX[10]*z;
	transMat.MATRIX[15]=1;
	
	currentMatrix = currentMatrix*transMat;

	//currentPos=currentPos*currentMatrix;
	mPosVector.x-=currentMatrix.MATRIX[2]*z;
	mPosVector.y+=currentMatrix.MATRIX[6]*z;
	mPosVector.z+=currentMatrix.MATRIX[10]*z;
	

	
}

void MESH::drawIt()
{
	glDisable(GL_LIGHTING);
	//glPushMatrix();
	
	//glPopMatrix();

	//draw, push pop and do the lot..
	//glLoadIdentity();
	glPushMatrix();
	glMultMatrixf(currentMatrix.MATRIX);
	//save the coords..
	
	glLineWidth(4.0);
	glBegin(GL_LINES);
	glColor3f(1.0,0.0,0.0);
	glVertex3f(0,0,0);
	glVertex3f(0,0,-12);
	glColor3f(0.0,1.0,0.0);
	glVertex3f(0.0,0.0,0.0);
	glVertex3f(0,12,0);
    glColor3f(0.0,0.0,1.0);
	glVertex3f(0.0,0.0,0.0);
	glVertex3f(-12,0.0,0);


	glEnd();

	
	
	
	
	

	


	//draw the thing..

//DrawPolygonDta();
	
	glPopMatrix();
	
	glLoadIdentity();
	
}

void MESH::drawIt2()
{
	//draw, push pop and do the lot..

	glMultMatrixf(currentMatrix.MATRIX);
	//save the coords..

	glBegin(GL_LINES);
	glColor3f(1.0,0.0,0.0);
	glVertex3f(currentMatrix.MATRIX[1],currentMatrix.MATRIX[5],currentMatrix.MATRIX[9]);
	glVertex3f(-currentMatrix.MATRIX[1]*6,-currentMatrix.MATRIX[5]*6,-currentMatrix.MATRIX[9]*6);
	glEnd();

	glBegin(GL_LINES);
	glColor3f(1.0,0.0,0.0);
	glVertex3f(currentMatrix.MATRIX[2],currentMatrix.MATRIX[6],currentMatrix.MATRIX[10]);
	glVertex3f(-currentMatrix.MATRIX[2]*6,-currentMatrix.MATRIX[6]*6,-currentMatrix.MATRIX[10]*6);
	glEnd();

	glBegin(GL_LINES);
	glColor3f(1.0,0.0,0.0);
	glVertex3f(currentMatrix.MATRIX[0],currentMatrix.MATRIX[4],currentMatrix.MATRIX[8]);
	glVertex3f(-currentMatrix.MATRIX[0]*6,-currentMatrix.MATRIX[4]*6,-currentMatrix.MATRIX[8]*6);
	glEnd();
	//draw the thing..


	

	
	//glLoadIdentity();
}

void MultMat1x4_4x4(float* m1x4,float *m4x4,float* ansm1x4)
{
	//this function multiplies a 1x4 matrix againts a 4x4 matrix
	//m1x4*m4x4 and stores the result in ansm1x4
	for(int index=0; index<4;index++)
	{
		//compute dot product from row of ma
		//and column of mb
		float sum = 0; //used to hold result--
		for(int col =0; col <4;col++)
		{
			sum+=(m1x4[col]*m4x4[col*4+index]);
		}//end of index.

		//insert resulting col element..
		ansm1x4[index] =sum;
	}//end of col.
}


			
void MESH::setShader(SHADER *shader)
{
	//ok.. we check, do we have a initialized shader?
	if(shader)//yes, then delete
		delete this->shader;
	//and make a new shader.
	this->shader =shader; //this should work.. and now everything is sweet and sound :)
	this->shader->initShader();
}



MESH::MESH()
{
	texCoords=false;
	shader=NULL;
}

void MESH::DrawPolygonDta()
{
}

 void MESH::draw()
{
	this->shader->draw(this);
}