#include "mp3Song.h"
//#include "globals.h"
#include <fmod/fmod.h>
#include <fmod/wincompat.h>
#include <fmod/fmod_errors.h>
#include <windows.h>
#include <iostream>
#include <process.h>


static SFadeData sFData;
bool globalInst=false;
Cmp3Song::Cmp3Song()
{
	channel = 66;
	mp3=0;
	if(globalInst==false)
	{
	FSOUND_Init(44100, 32, FSOUND_INIT_GLOBALFOCUS);
	globalInst=true;
	}
	
}

Cmp3Song::Cmp3Song(char *mp3File,int volume)
{
	channel = 66;
	if(globalInst==false)
	{
	FSOUND_Init(44100, 32, FSOUND_INIT_GLOBALFOCUS);
	globalInst=true;
	}
	mp3 =FSOUND_Stream_OpenFile(mp3File,FSOUND_16BITS|FSOUND_STEREO|FSOUND_LOOP_NORMAL,0);
	this->volume=volume;
	//now that file is loaded and could be played by Cmp3Song::playMp3(); :)
}

void Cmp3Song::playMp3()
{
	if(channel!=66)
	{
		FSOUND_SetPaused(channel,false);
		isPlaying=true;
	}
	else
	{
	isPlaying=true;
	channel= FSOUND_Stream_Play(FSOUND_FREE,mp3);
	FSOUND_SetVolume(channel,volume);
	}
}

void Cmp3Song::pauseMp3()
{
	FSOUND_SetPaused(channel,true);
	isPlaying=false;
}

void Cmp3Song::setSong(char *mp3File)
{
	//check if we have a song loaded...
	if(mp3)
	{
		//fadeOut(500);
		FSOUND_Stream_Close(mp3);
	}
mp3 =FSOUND_Stream_OpenFile(mp3File,FSOUND_16BITS|FSOUND_STEREO|FSOUND_LOOP_NORMAL,0);
channel=66;
}

void Cmp3Song::setVolumeMp3(int volume)
{
	this->volume=volume;
	if(channel!=66) //then our song has a valid channel, we can apply volume ;)
		FSOUND_SetVolume(channel,volume);
}

void Cmp3Song::stopMp3()
{
	FSOUND_Stream_Stop(mp3);
	isPlaying=false;
}

Cmp3Song::Cmp3Song(Cmp3Song *data)
{
	this->volume=data->volume;
	this->channel=data->channel;
	this->isPlaying=data->isPlaying;
	this->mp3=data->mp3;
}

void  Cmp3Song::fadeMp3( int seconds,int volume)
{
	
	sFData.seconds=seconds;
	sFData.volume=volume;
	sFData.mp3= new Cmp3Song(this);
	//dirtyFade(&sFData);
	_beginthread(dirtyFade,0,&sFData);
	
	/*static unsigned int lastTime = 0;
		static float factor= (float)(((float)volume-(float)this->volume)/((float)seconds));


		
	if(playing()==true) //this will maybe sound crap.. :(
	{
		
		if(this->volume>=volume)
			return; //no point in fading in.. 
	
		
			if(GetTickCount() - lastTime >= 1000)
			{
				lastTime = GetTickCount();
				setVolumeMp3(retVolume()+factor);
				
			}
			if(this->volume==volume)
				return;
		
	}

	else
	{
		
		setVolumeMp3(0);
		playMp3();
			if(GetTickCount() - lastTime >= 1000)
			{
				lastTime = GetTickCount();
				setVolumeMp3(retVolume()+factor);
				
			}
			if(this->volume==volume)
				return;
	}

	std::cout<<this->volume;*/
}

void dirtyFade(void *data)
{
	SFadeData *data2;
	data2 = (SFadeData*)data;
	int volume=data2->volume;
	int seconds=data2->seconds;
	data2->mp3->retVolume();
static unsigned int lastTime = 0;
 const float factor= (float)(((float)volume-(float)data2->mp3->retVolume())/((float)seconds));

for(;;)
{
	//std::cout<<data2->mp3->retVolume();
	if(data2->mp3->playing()==true) //this will maybe sound crap.. :(
	{
		
		if(data2->mp3->retVolume()>=volume&&factor>=0)
		{
			_endthread();
			return; //no point in fading in.. 
		}
		if(data2->mp3->retVolume()<=volume&&factor<=0)
		{
			_endthread();
			return; //no point in fading in.. 
		}
	
		
			if(GetTickCount() - lastTime >= 1000)
			{
				lastTime = GetTickCount();
				data2->mp3->setVolumeMp3(data2->mp3->retVolume()+factor);
				
				
			}
			if(data2->mp3->retVolume()>=volume&&factor>=0)
			{
				_endthread();
				return;
			}
			if(data2->mp3->retVolume()<=volume&&factor<=0)
		{
			_endthread();
			return; //no point in fading in.. 
		}
	
		
	}

	else
	{
		
		data2->mp3->setVolumeMp3(0);
		data2->mp3->playMp3();
			if(GetTickCount() - lastTime >= 1000)
			{
				lastTime = GetTickCount();
				data2->mp3->setVolumeMp3(data2->mp3->retVolume()+factor);
				

				
			}
			if(data2->mp3->retVolume()>=volume&&factor>=0)
		{
			_endthread();
			return; //no point in fading in.. 
		}
			
			if(data2->mp3->retVolume()<=volume&&factor<=0)
		{
			_endthread();
			return; //no point in fading in.. 
		}
		
	}
}
}

/*class Cmp3Ruler
{
public:
	int kill (char *mp3); //this stops the sound process and frees up resources 
	void fadeOut(char *mp3); //this fades the sound process and kills it.
private:
*/


