#include "CmodBoard_normal_graph.h"
#include "texture.h"
#include "playbrick.h"
#include "CTileFile.h"
#include "CText.h"
#include "globals.h"
#include "defines.h"
#include "general.h"
#include "hud_base.h"
#include "CHudTetris.h"

#include <math.h>
#include <iostream>
#include <gl/glut.h>
SPYTEXTURE texture;
SPYTEXTURE ba;
SPYTEXTURE da;
SHudTetrisData gameData;



CmodBoard_normal_graph::CmodBoard_normal_graph()
{
	texture.setFormat(JPG);
	texture.initTexture("redBlock.jpg");
	da.setFormat(JPG);
	da.initTexture("chrome.jpg");
	
	
}

CmodBoard_normal_graph::CmodBoard_normal_graph(char **texture,int numOfTexture)
{
	textureArray = new SPYTEXTURE[numOfTexture];
    for(int i =0; i <numOfTexture;i++)
	{
		textureArray[i].setFormat(JPG);
		textureArray[i].initTexture(texture[i]);
	}
}

void CmodBoard_normal_graph::drawBoard(unsigned int *board,int width, int height,int points,int nextLick)
{
	
	static int lastTime=0;
	static float z=0.0;
	static int hoa=0;
	static int i=1;
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glDepthMask(GL_TRUE);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	glDisable(GL_BLEND);
	gameData.score=points;
	gameData.nextLick=nextLick;
	



	//drawBox(0,0,0,2,2,2,ba);
	glPushMatrix();
	
	glPopMatrix();
	//glDisable(GL_LIGHTING);
	GLfloat mat_trans[]={1.0,1.0,1.0,0.9};
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.2)+0.09,2.0-0.05,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
if(KEYDOWN(VK_RETURN))
{
	if(GetTickCount() - lastTime >= 133)
    {
		lastTime=GetTickCount();
		hoa+=1;
		if(hoa==4)
			hoa=0;
	}
}

    for(int i = height-1; i >= 0; i--)
	{
		for(int g=0; g<width;g++)
		{

			if(board[g+i*width]!=0)
			{
				switch(hoa)
				{
					case 0:
		glPushMatrix();
		texture.activate();
		
		glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,0.0,1.0,0.0);
		
	 //glutSolidTorus(0.1,0.05,16,16);
	
			glutSolidCube(0.2);
	 glPopMatrix();
	 break;
	 		case 1:
		glPushMatrix();
		texture.activate();
		glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,1.0,1.0,1.0);
		
	 //glutSolidTorus(0.1,0.05,16,16);
	
			glutSolidCube(0.2);
	 glPopMatrix();
	 break;

	 		case 2:
		glPushMatrix();
		da.activate();	
		glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,1.0,1.0,1.0);
		
	 //glutSolidTorus(0.1,0.05,16,16);
	
			glutSolidCube(0.2);
	 glPopMatrix();
	 break;
	 
	 		case 3:
		glPushMatrix();
		da.activate();
		glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,0.0,1.0,0.0);
		
	 //glutSolidTorus(0.1,0.05,16,16);
	
			glutSolidCube(0.2);
	 glPopMatrix();
	 break;
	 	
	 case 4:
		glPushMatrix();
	glTranslatef(0.0,0.0,0.0);
		//glScalef(1,sin(z/300)/2,sin(z/100));
       if(board[g+i*width]==7)	
	   {
		   glPushMatrix();
		   glTranslatef(0.0,0.0,0.0);
		glRotatef(z/5,0.0,1.0,0.0);
				glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,0.0,1.0,1.0);
		glutSolidCube(0.2);
		glPopMatrix();
		
		glPushMatrix();
		glTranslatef(0.2*(width-1),0.0,0.0);
		glRotatef((z/5)*-1 + 180,0.0,1.0,0.0);
				glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,0.0,1.0,1.0);
		glutSolidCube(0.2);
		glPopMatrix();
	   }
		glTranslatef(g*0.2,i*0.2*-1,0.0); 
		glRotatef(z,0.0,1.0,1.0);
		
	 //glutSolidTorus(0.1,0.05,16,16);
	
			glutSolidCube(0.2);
	 glPopMatrix();
	 break;
			}
			
		}
		}
	}
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	tetrisHud->drawHud(&gameData);
	
	glutSwapBuffers();
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
	z+=0.1;
	
	if((z/10)>=360*i)
		i++;
	
	
}
		

void CmodBoard_normal_graph::drawNumber(int number)
{
		//glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glDepthMask(GL_TRUE);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	glDisable(GL_BLEND);
	
}

