#include <GL/glut.h>
#include <stdlib.h>
#include <png.h>
#include "main.h"

int load_tex(char *filename, int num)
{
  textures[num].texid = 666;
  textures[num].image = NULL;
  textures[num].width = 0;
  textures[num].height = 0;

  loadPngTex(textures+num, filename, num);

  if(!glIsTexture(textures[num].texid)) {
    glGenTextures(1, &textures[num].texid);
    glBindTexture(GL_TEXTURE_2D, textures[num].texid);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexImage2D(GL_TEXTURE_2D, 0, textures[num].type, textures[num].width, textures[num].height,
		 0, textures[num].type, GL_UNSIGNED_BYTE, textures[num].image);
  }
	
  return 0;
}

int loadPngTex(texture *tex, char *filename, int num)
{
  double screen_gamma, image_gamma;
  png_uint_32 row;
  png_structp png_ptr = NULL;
  png_infop info_ptr = NULL;
  png_uint_32 width, height;
  int bit_depth, color_type, interlace_type;
  png_bytep *row_pointers = NULL;
  png_bytep trans = NULL;
  int num_trans = -1;
  png_color_16 *trans_values = NULL;
  const int ReadFile = 1;
  FILE *fp;

  textures[num].texid = 666;
  textures[num].image = NULL;
  textures[num].width = 0;
  textures[num].height = 0;
	
  if ((fp = fopen(filename, "rb")) == NULL) {
    if (fp)fclose(fp);
    if (png_ptr){
      if (ReadFile)
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      else
	png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
    }
    return 1;
  }

  png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, (void*)NULL, NULL, NULL);
  if (png_ptr == NULL) {
    if (fp)fclose(fp);
    if (png_ptr) {
      if (ReadFile)
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      else
	png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
    }
    return 1;
  }

  info_ptr = png_create_info_struct(png_ptr);
  if (info_ptr == NULL) {
    if (fp)fclose(fp);
    if (png_ptr) {
      if (ReadFile)
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      else
	png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
    }
    return 1;
  }

  if(setjmp(png_ptr->jmpbuf)) {
    if(fp)fclose(fp);
    if(png_ptr){
      if(ReadFile)
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      else
	png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
    }
    return 1;
  }

  png_init_io(png_ptr, fp);
  png_read_info(png_ptr, info_ptr);

  png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
	       &interlace_type, NULL, NULL);
  png_get_tRNS(png_ptr, info_ptr, &trans, &num_trans, &trans_values);

  if(color_type == PNG_COLOR_TYPE_PALETTE||bit_depth<8)
    png_set_expand(png_ptr);

  if(png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS))
    png_set_expand(png_ptr);

  screen_gamma = 1.0;

  if(png_get_gAMA(png_ptr, info_ptr, &image_gamma))
    png_set_gamma(png_ptr, screen_gamma, image_gamma);
  else
    png_set_gamma(png_ptr, screen_gamma, 1.0);


  png_read_update_info(png_ptr, info_ptr);
  color_type = png_get_color_type(png_ptr, info_ptr);

  row_pointers = calloc(height, sizeof(png_bytep));
  switch(color_type){
  case PNG_COLOR_TYPE_GRAY:
    tex->type = GL_LUMINANCE;
    break;
  case PNG_COLOR_TYPE_GRAY_ALPHA:
    tex->type = GL_LUMINANCE_ALPHA;
    break;
  case PNG_COLOR_TYPE_PALETTE:
  case PNG_COLOR_TYPE_RGB:
    tex->type = GL_RGB;
    break;
  case PNG_COLOR_TYPE_RGB_ALPHA:
    tex->type = GL_RGBA;
    break;
  }

  tex->height = height;
  tex->width = width;
  tex->image = (png_byte*)calloc(height, png_get_rowbytes(png_ptr, info_ptr));
  for(row = 0; row < height; row++)
    row_pointers[row] = tex->image+row*png_get_rowbytes(png_ptr, info_ptr);

  png_read_image(png_ptr, row_pointers);
  png_read_end(png_ptr, info_ptr);
  png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);

  if(row_pointers){
    if(!ReadFile){
      int i;

      for(i = 0; i < height; i++)
	free(row_pointers[i]);
    }
    if(row_pointers)free(row_pointers);
  }

  fclose(fp);

  return 0;
}
