#include <GL/gl.h>
#include "main.h"

typedef struct
{
  unsigned char r, g, b, a;
} texdata_t;

static GLuint dist_tex;

void make_distortion (int, int, float *, float *, float, int);

/* du kan egentlig drite i denne funksjonen */
void
make_texture (void)
{
  int i, j, d;
  texdata_t imgdata[64][64];

  for (i = 0; i < 64; i++)
    {
      for (j = 0; j < 64; j++)
	{
	  d = ((i&0x8)^(j&0x8))*255;
	  imgdata[i][j].r = d;
	  imgdata[i][j].g = d;
	  imgdata[i][j].b = d;
	  imgdata[i][j].a = 255;
	}
    }

  glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
  glGenTextures (1, &dist_tex);
  glBindTexture (GL_TEXTURE_2D, dist_tex);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

  glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, imgdata);
}

void
draw_distortion (int res, float var, int type, int n, int num)
{
  float u, v;
  int i, j;
  float res2 = (float)res / 2;

  glBindTexture (GL_TEXTURE_2D, textures[num].texid);
  glEnable (GL_TEXTURE_2D);

  glBegin (GL_QUADS);
  for (i = 0; i < res; i += n)
    {
      for (j = 0; j < res; j += n)
	{
	  make_distortion (i, j, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f (i-res2, j-res2, 0);
	  
	  make_distortion (i, j+n, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f (i-res2, (j+n)-res2, 0);
	  
	  make_distortion (i+n, j+n, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f ((i+n)-res2, (j+n)-res2, 0);
	  
	  make_distortion (i+n, j, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f ((i+n)-res2, j-res2, 0);
	}
    }
  glEnd ();
}

void
make_distortion (int u, int v, float *newu, float *newv, float var, int type)
{
  float x, y, xnew, ynew;
  float a, b;

  x = (float)u / 32;
  y = (float)v / 32;

  /* feel free til  prve  finne p noen re funksjoner til  distorte ting */
  switch (type)
    {
    case NONE:
      xnew = x;
      ynew = y;
      break;
    case EXP_SINE: /* bruk p teksturer */
      xnew = exp(x) * sin(y+var);
      ynew = exp(y) * sin(x-var);
      break;
    case SINE: /* denne er ogs vill */
      xnew = sin(x) * cos(y+var) - sin(y-var) * cos(x-var);
      ynew = cos(x) * sin(y+var) + sin(x+var) * cos(y+var);
      break;
    case WEIRD:
      xnew = x + sin(x)*cos(x)*sin(y-var);
      ynew = y + sin(y)*cos(y)*sin(x+var);
      break;
    case WAVY: /* faen i helvete */
      xnew = x + sin(x)*cos(x)*sin(y+var)*cos(y+var);
      ynew = y + sin(y)*cos(y)*sin(x-var)*cos(x-var);
      break;
    case TING:
      xnew = x;
      ynew = sin(x+var/10);
      break;
    case NOISE:
      xnew = sin(x+var) + cos(x)+var;
      ynew = cos(y) - cos(x-var)-var;
      break;
    }

  *newu = xnew / 2;
  *newv = ynew / 2;
}

void
draw_fractal (int dude)
{
  int i, j, d;
  texdata_t imgdata[64][64];

  for (i = 0; i < 64; i++)
    {
      for (j = 0; j < 64; j++)
	{
	  d = ((i*dude)^(j));
	  imgdata[i][j].r = d;
	  imgdata[i][j].g = d;
	  imgdata[i][j].b = d;
	  imgdata[i][j].a = 255;
	}
    }

  glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
  glGenTextures (1, &dist_tex);
  glBindTexture (GL_TEXTURE_2D, dist_tex);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

  glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, imgdata);

  glBindTexture (GL_TEXTURE_2D, dist_tex);
  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f (-1, 1, 1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1, 1);
  glTexCoord2f (1, 0); glVertex3f ( 1,-1, 1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1,-1);
  glTexCoord2f (0, 1); glVertex3f (-1, 1,-1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f ( 1,-1,-1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f (-1,-1,-1);
  glTexCoord2f (1, 1); glVertex3f (-1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f (-1, 1, 1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f ( 1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f ( 1,-1,-1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f ( 1, 1, 1);
  glEnd ();


  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1, 1, 1);
  glTexCoord2f (0, 1); glVertex3f ( 1, 1, 1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f (-1, 1,-1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f ( 1,-1, 1);
  glTexCoord2f (1, 1); glVertex3f ( 1,-1,-1);
  glTexCoord2f (1, 0); glVertex3f (-1,-1,-1);
  glEnd ();
}

void
draw_cube (void)
{
  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f (-1, 1, 1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1, 1);
  glTexCoord2f (1, 0); glVertex3f ( 1,-1, 1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1,-1);
  glTexCoord2f (0, 1); glVertex3f (-1, 1,-1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f ( 1,-1,-1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f (-1,-1,-1);
  glTexCoord2f (1, 1); glVertex3f (-1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f (-1, 1, 1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f ( 1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f ( 1,-1,-1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f ( 1, 1, 1);
  glEnd ();


  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1, 1, 1);
  glTexCoord2f (0, 1); glVertex3f ( 1, 1, 1);
  glTexCoord2f (1, 1); glVertex3f ( 1, 1,-1);
  glTexCoord2f (1, 0); glVertex3f (-1, 1,-1);
  glEnd ();

  glBegin (GL_QUADS);
  glTexCoord2f (0, 0); glVertex3f (-1,-1, 1);
  glTexCoord2f (0, 1); glVertex3f ( 1,-1, 1);
  glTexCoord2f (1, 1); glVertex3f ( 1,-1,-1);
  glTexCoord2f (1, 0); glVertex3f (-1,-1,-1);
  glEnd ();
}
