 //#include "_shared.fx"

// texture
texture tBase;

struct VS_INPUT {
	float4	pos		: POSITION;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float2	uv		: TEXCOORD0;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT	o;

	o.pos = i.pos * 640;
	//o.pos.y = -o.pos.y * 1.28;
	//o.pos.y = o.pos.y * 1.275;
	o.pos.w = 320;
	o.uv = i.uv;

	return o;
}

// Single pass
technique tec0
{
	pass P0
	{
		VertexShader = compile vs_1_1 vsMain();

		CullMode = None;

		//Clipping = False;

		ZWriteEnable = False;
		ZEnable = False;

		Lighting = False;

		Texture[0] = <tBase>;

		//AlphaBlendEnable = False;	
		AlphaBlendEnable = True;	
		SrcBlend = SrcAlpha;
		DestBlend = One;

		MinFilter[0] = Linear;
        MagFilter[0] = Linear;

		/*//TextureFactor = 0xcccccccc;
		TextureFactor = 0xffffffff;

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;

		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;*/

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;

		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;
		
		ColorOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		ZEnable = True;
		ZWriteEnable = True;

		CullMode = CW;

		//Clipping = True;

		AlphaBlendEnable = False;	
	}
}
