//#include "_shared.fx"

// texture
texture tBase;

struct VS_INPUT {
	float4	pos		: POSITION;
	float4	diffuse	: COLOR0;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float4	diffuse	: COLOR0;
	float2	uv		: TEXCOORD0;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT	o;

	o.pos = i.pos;
	//o.pos.y = -o.pos.y * 1.28;
	o.pos.y = -o.pos.y * 1.275;
	o.pos.w = 320;
	o.diffuse = i.diffuse;
	o.uv = i.uv;

	return o;
}

// Single pass
technique tec0
{
	pass P0
	{
		FVF = Xyz | Diffuse | tex1;
		
		VertexShader = compile vs_1_1 vsMain();

		CullMode = None;

		//Clipping = False;

		ZWriteEnable = False;
		ZEnable = False;

		Lighting = False;

		MinFilter[0] = Linear;
        MagFilter[0] = Linear;

		Texture[0] = <tBase>;

		AlphaBlendEnable = True;	
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = Diffuse;
		ColorArg2[0] = Texture;

		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = Diffuse;
		AlphaArg2[0] = Texture;
		
		ColorOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		ZEnable = True;
		ZWriteEnable = True;

		CullMode = CW;

		//Clipping = True;

		AlphaBlendEnable = False;	
	}
}
