#ifndef __SHARED_FX
#define __SHARED_FX

// various global (not per-object) parameters are here


// camera params
shared float4x4	mView;
shared float4x4 mProjection;
shared float4x4 mViewProj;
shared float3	vEye;

// light/shadow params
shared float3	vLightPos;
shared float3	vLightDir = normalize( float3(0.4,-1,0.2) );
shared float3	vLightAmbient = 0.4;
shared float3	vLightDiffuse = 0.9;
shared float4x4 mShadowMapProj;

// cull params: CW=2 (should be default), CCW=3 (for reflected, etc.)
shared int		iCull = 2;

shared float4x4 mReflMapProj;

// others
shared float4x4 mSphereMap = float4x4(
	0.5,0,  0, 0,
	0,  0.5,0, 0,
	0.5,0.5,1, 0,
	0,  0,  0, 1 );


#endif
