 #include "_shared.fx"

// world transform
matrix mWorld;

float4 vLight;

float4 vDiffuse;

struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float4	diffuse	: COLOR0;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT o;

	float4 normal = mul( i.normal, mWorld );
	normal.w = 0;
	
	o.pos = mul( i.pos, mWorld );
	
	if( dot( normal, o.pos - vLight ) > 0 ) {
		float4 delta;
		delta = float4( o.pos - vLight );

		delta = normalize( delta );			
		
		o.pos = vLight + delta * 250;
		
		o.pos.w = 1;
		
		o.diffuse = float4( 0, 0, 0, 0 );		
	} else {
		o.pos = o.pos + normal * 2;
		//o.diffuse = float4( 0.05, 0.05, 0.05, 1 );
		o.diffuse = vDiffuse;
	}

	o.pos = mul( o.pos, mViewProj );
	
	return o;
}

// Single pass
technique tec0
{
	pass P0
	{
		CullMode = None;

		VertexShader = compile vs_1_1 vsMain();

		Lighting = False;

		ZWriteEnable = False;

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = One;

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Diffuse;
		
		ColorOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		ZWriteEnable = True;

		CullMode = CW;

		AlphaBlendEnable = False;	
	}
}
