#include "_shared.fx"

// world transform
matrix mWorld;

float4 vDiffuse;

float3 vDelta;

struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT	o;

	o.pos = mul( i.pos, mWorld );

	o.pos.y = o.pos.z;
	o.pos.z = 0;
		
	o.pos.y = -o.pos.y * 1.275;

	o.pos.x += vDelta.x;
	o.pos.y += vDelta.y;
	
	o.pos.w = vDelta.z;	

	return o;
}

technique tec0
{
	pass P0
	{
		CullMode = None;
		
		VertexShader = compile vs_1_1 vsMain();

		Clipping = False;

		ZEnable = False;
		ZWriteEnable = False;

		AlphaBlendEnable = True;	
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		Lighting = False;

		TextureFactor = <vDiffuse>;
		//TextureFactor = 0xffffffff;

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = TFactor;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		CullMode = CW;

		ZWriteEnable = True;
		ZEnable = True;

		//Clipping = True;

		AlphaBlendEnable = False;	
	}
}
