 #include "_shared.fx"

// texture
texture tBase;

// texture
texture tEnv;

// world transform
matrix mWorld;

float fDeltaU;

float4 vDiffuse;

struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float2	uv		: TEXCOORD0;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT	o;

	o.pos = mul( i.pos, mWorld );
	o.pos.x *= 7;
	o.pos.z *= 7;
	o.uv.x = fDeltaU * 10;
	o.uv.y = o.pos.y / 10;
	o.pos.y = ( o.pos.y - mWorld._42 ) * 100;
	//o.pos = o.pos + float4( 0, f, 0, 0 );	
	o.pos = mul( o.pos, mViewProj );
	//o.uv = i.uv;
	
	

	return o;
}

// Single pass
technique tec0
{
	pass P0
	{
		CullMode = CW;

		VertexShader = compile vs_1_1 vsMain();

		ZWriteEnable = False;

		Lighting = False;

		AlphaBlendEnable = True;	
		SrcBlend = SrcAlpha;
		DestBlend = One;

		MinFilter[0] = Point;
        MagFilter[0] = Point;
        
		Texture[0] = <tEnv>;

		//TextureFactor = 0xff020208;
		//TextureFactor = 0xff111144;
		TextureFactor = <vDiffuse>;

		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;
		
		/*ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;*/

		ColorOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		ZWriteEnable = True;

		CullMode = CW;

		AlphaBlendEnable = False;	

		FillMode = Solid;
	}
}
