;--------------------------------------------
; Add on MyselF : Modified version of skal's
; skeleton for the fast code compo at
; SOTA 2004
;
; Thanks to GOOGLE and http://geometryalgorithms.com/Archive/algorithm_0109/algorithm_0109.htm
; for giving advice on how convex hulls
; could work... My researches took me to
; some interesting things : some O(n log(n))
; algorithms exist but of course, I prefered
; the brute force that is O(n4) ;o))) it
; surely releases some bytes !
;
; Sea nfo for more informations 'bout the
; work I did today on these fast code compo
;--------------------------------------------
; Original header by Skal :
;
; Very basic skeleton for SOTA'04 fast code compo.
; The 'convex hull' part is of course missing ;)
;
; Assemble with: nasm -f bin hull.asm -o hull.com
;
;  Skal04.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;--------------------------------------------
; Add on MyselF : usable registers
;--------------------------------------------
; ax bx cx dx
; di si bp

[org 100h]
[segment .text]

%define nb_pts 100
%define pts    0x1000
%define inhull 0x2000

  ; ax=0 at start of a .com

Start:
Load_File:
  mov dx, file
  mov ah, 0x3d
  int 21h
;  jc Exit

  mov bx, ax
  mov ax, 0x3f00
  mov ecx, nb_pts*2
  mov dx, pts
  int 21h
;  jc Exit

;--------------------------------------------
; Add on MyselF : initializes the inhull array
; so each point is considered to be in the
; convex hull
; inhull[i] = 2 if in hull
;             1 if not
;--------------------------------------------
Init_In_Hull:
  mov cx, nb_pts
  push cs
  pop es
  mov ax, 2
  mov di, inhull
  rep stosw

;--------------------------------------------
; Add on MyselF : removes unwanted points
; from the convex hull - brute force
; (complexity O(n4) - but may be the
; shortest way to do isn't it ?
;--------------------------------------------
; ax - i
; bx - j
; cx - k
; dx - l

Remove_Unwanted_Points_In_Hull:

  ; we'll perform 4 loops on the array
  xor ax, ax
Loop_i:
  cmp ax,nb_pts*2
  jge Loop_i_End
  xor bx, bx
Loop_j:
  cmp bx,nb_pts*2
  jge Loop_j_End
  mov cx, bx
  add cx, 2
Loop_k:
  cmp cx,nb_pts*2
  jge Loop_k_End
  mov dx, cx
  add dx, 2
Loop_l:
  cmp dx,nb_pts*2
  jge Loop_l_End

  ;--------------------------------------------
  ; sorry, nasm told me the loop
  ; was too long, I didn't want to
  ; do that, anyway !
  ;--------------------------------------------
  jmp Inside_The_Loop
  Inside_The_Loop_Return:


  ; finish loops
  add dx,2
  jmp Loop_l
Loop_l_End:
  add cx,2
  jmp Loop_k
Loop_k_End:
  add bx,2
  jmp Loop_j
Loop_j_End:
  add ax,2
  jmp Loop_i
Loop_i_End:

;--------------------------------------------
; back to Skal's code :o)
;--------------------------------------------
Gfx_On:
  mov al,13h
  int 10h

Palette:
  mov dx, 03c8h
  xor al,al

  out dx, al
  inc dx
  out dx, al
  out dx, al
  out dx, al

  mov al, 0xff
  out dx, al
  out dx, al
  out dx, al

  out dx, al
  xor al, al
  out dx, al
  out dx, al

  mov cx, 320*200/2
  push word 0xa000
  pop es
  mov di, ax
  rep stosw

Plot:
  mov si, 0

Plot_Loop:
  push es
  push cs
  pop es
  ; modified here to get the correct
  ; color from the inhull array
  mov   al, byte [inhull+si]
  movzx di, byte [pts+si+1]
  imul  di, 320
  movzx bx, byte [pts+si+0]
  add   di, bx

  pop es
  stosb
  add si,2
  cmp si,nb_pts*2
  jl Plot_Loop

Wait_Esc:
  in al, 60h
  cbw
  dec ax
  jnz Wait_Esc

Exit:
  mov al, 03h
  int 10h
  ret

;--------------------------------------------
; Add on MyselF : this function is to test
; on which side is placed a point regarding
; a line - simply a cross product !
;--------------------------------------------
; in :  ax must contain index 2
;       bx must contain index 1
;       cx must contain index 0
; out : ax contains +/- result depending on the side
;--------------------------------------------
; C equivalent :
;    return ( point[index1+0] - point[index0+0] ) * ( point[index2+1] - point[index0+1] )
;         - ( point[index1+1] - point[index0+1] ) * ( point[index2+0] - point[index0+0] );
;--------------------------------------------
Side_Function:
  mov di, cx
  mov si, bx
  mov bp, ax

  ; get the first substraction member
  xor ax, ax
  xor bx, bx
  xor cx, cx
  movzx ax, byte [pts+si+0] ; ax = point[index1+0]
  movzx bx, byte [pts+di+0] ; bx = point[index0+0]
  sub ax, bx                ; ax = ( point[index1+0] - point[index0+0] )
  movzx bx, byte [pts+bp+1] ; bx = point[index2+1]
  movzx cx, byte [pts+di+1] ; cx = point[index0+1]
  sub bx, cx                ; bx = ( point[index2+1] - point[index0+1] )
  imul ax, bx               ; ax = ( point[index1+0] - point[index0+0] ) * ( point[index2+1] - point[index0+1] )

  ; get the second substraction member
  xor bx, bx
  xor cx, cx
  xor dx, dx
  movzx bx, byte [pts+si+1] ; bx = point[index1+1]
  movzx cx, byte [pts+di+1] ; cx = point[index0+1]
  sub bx, cx                ; bx = ( point[index1+1] - point[index0+1] )
  movzx cx, byte [pts+bp+0] ; cx = point[index2+0]
  movzx dx, byte [pts+di+0] ; dx = point[index0+0]
  sub cx, dx                ; cx = ( point[index2+0] - point[index0+0] )
  imul bx, cx               ; bx = ( point[index1+1] - point[index0+1] ) * ( point[index2+0] - point[index0+0] )

  ; do the substraction on both members
  sub ax, bx

  ret

;--------------------------------------------
; Variables
;--------------------------------------------
file: db 'a', 0

;--------------------------------------------
; Add on MyselF : my variables
;--------------------------------------------
res1: dw 0
res2: dw 0
res3: dw 0

;--------------------------------------------
; Add on MyselF : this function should
; be placed in the 4 loops but nasm told
; me it was too long... Since I do not
; want nasm to be angry, I moved it here.
; Anyway, remember I didn't want to !!
; nasm is the only responsible for that...
; (at least, tasm, masm and others would
; certainly agree with nasm on that point ;o)
;--------------------------------------------
Inside_The_Loop:
  ; -- preserver the index of the current element --
  mov si, ax

; in :  ax must contain index 2
;       bx must contain index 1
;       cx must contain index 0

  ; -- search the first triangle side --
  pushad
  ; mov ax, ax
  ; mov bx, bx
  ; mov cx, cx
  call Side_Function
  mov word [res1], ax
  popad

  ; -- search the second triangle side --
  pushad
  ; mov ax, ax
  ; mov bx, cx
  ; mov cx, dx
  mov bx, cx
  mov cx, dx
  call Side_Function
  mov word [res2], ax
  popad

  ; -- search the third triangle side --
  pushad
  ; mov ax, ax
  ; mov bx, dx
  ; mov cx, bx
  mov cx, bx
  mov bx, dx
  call Side_Function
  mov word [res3], ax
  popad

  ; -- test all the three signs to see if the current point is in the triangle or not --
  pushad

  movsx eax, word [res1]
  movsx ebx, word [res2]
  movsx ecx, word [res3]

  imul eax, ebx
  test eax, eax
  jle out_of_triangle

  imul ebx, ecx
  test ebx, ebx
  jle out_of_triangle

  ; -- point is not in the hull --
  mov byte [inhull+si], 1
out_of_triangle:
  popad

  jmp Inside_The_Loop_Return
