#include "show_glwindow.h"
#include "common.h"

bool gl_window::open (const char *title, const gl_window_info *info)
{
    /* register window class */
    wc.style = (info->fullscreen) ? (CS_HREDRAW | CS_VREDRAW | CS_OWNDC) : CS_OWNDC;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = NULL;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) GetStockObject (BLACK_BRUSH);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = DEMOTITLE;
    RegisterClass (&wc);
    fullscreen=info->fullscreen;
    /* create main window */
    if (info->fullscreen) {
        hWnd = CreateWindow (DEMOTITLE, title, 
            WS_POPUP | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE,
            0, 0, info->width, info->height,
            NULL, NULL, NULL, NULL);
        DEVMODE dmScreenSettings; // Developer Mode
        memset(&dmScreenSettings, 0, sizeof(DEVMODE)); // Clear Room To Store Setting
	    dmScreenSettings.dmSize	= sizeof(DEVMODE);		// Size Of The Devmode Structure
	    dmScreenSettings.dmPelsWidth	= info->width;			// Screen Width
	    dmScreenSettings.dmPelsHeight = info->height;			// Screen Height
	    dmScreenSettings.dmFields= DM_PELSWIDTH | DM_PELSHEIGHT;	// Pixel Mode
	    ChangeDisplaySettings(&dmScreenSettings, CDS_FULLSCREEN);	// Switch To Full Screen
    }
    else
        hWnd = CreateWindow (DEMOTITLE, title, 
            WS_POPUPWINDOW | WS_CAPTION,
            0, 0, info->width, info->height,
            NULL, NULL, NULL, NULL);

    hDC = GetDC (hWnd);

    /* set the pixel format for the DC */
    ZeroMemory (&pfd, sizeof (pfd));
    pfd.nSize = sizeof (pfd);
    pfd.nVersion = 1;
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
    pfd.iPixelType = PFD_TYPE_RGBA;
    pfd.cColorBits = info->colorDepth;  //24;
    pfd.cDepthBits = info->zbufferDepth;    //16;
    pfd.iLayerType = PFD_MAIN_PLANE;
    iFormat = ChoosePixelFormat (hDC, &pfd);
    SetPixelFormat (hDC, iFormat, &pfd);
    /* create and enable the render context (RC) */
    hRC = wglCreateContext( hDC );
	if (info->fullscreen) {
		ShowWindow(hWnd, SW_SHOW);
	} else {
		//center, show and alwaysontopify the window.
		SetWindowPos(hWnd,HWND_TOPMOST,(GetSystemMetrics(SM_CXSCREEN)-info->width)/2,(GetSystemMetrics(SM_CYSCREEN)-info->height)/2,0,0,SWP_NOSIZE|SWP_SHOWWINDOW); //always on top.
	}
    UpdateWindow(hWnd);
    SetFocus(hWnd);    
    wglMakeCurrent( hDC, hRC );
	if (info->fullscreen) ShowCursor(false);
    return true;
}

bool gl_window::updateSystem ()
{
    MSG msg;
    if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
        /* handle or dispatch messages */
        if (msg.message == WM_QUIT) return FALSE;
        else
        {
            TranslateMessage (&msg);
            DispatchMessage (&msg);
        }
    }
    return TRUE;
}

void gl_window::flipBuffers()
{
    SwapBuffers (hDC);
}

void gl_window::close ()
{
    if (fullscreen)  {
        ChangeDisplaySettings(NULL, 0);    
        ShowCursor(true);
    }
    wglMakeCurrent (NULL, NULL);
    wglDeleteContext (hRC);
    ReleaseDC (hWnd, hDC);
    /* destroy the window explicitly */
    DestroyWindow (hWnd);
}

LRESULT CALLBACK 
gl_window::WndProc (HWND hWnd, UINT message,
         WPARAM wParam, LPARAM lParam)
{

    switch (message)
    {
    case WM_CREATE:
        return 0;
    case WM_CLOSE:
        PostQuitMessage (0);
        return 0;

    case WM_DESTROY:
        return 0;

    case WM_KEYDOWN:
        switch (wParam) {
        case VK_ESCAPE:
            PostQuitMessage(0);
            return 0;
        }
        return 0;

    default:
		return WndProc2 (hWnd, message, wParam, lParam); 
    }
}


