/*  Pixmap font reader
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef GFX_FONT
#define GFX_FONT

#include "../base/xio.h"

namespace gfx
{	
	class Font {
	public:
		void init(xio::Manager *i, xio::surface *font);
		void draw(xio::surface *target, const char *text, int dx, int dy, int width, int height, float alpha, bool centralize);
		xio::surface *preDraw(const char *text);
	private:
		xio::Manager *xio;
		xio::surface *f;
		xio::surface *tempchar; // For the temporary character
		xio::rgb pixel; // Temporary pixel, used while copying character
		int charwidth;
	};	
}
 
#endif
