/*  xs - Support 
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "xs.h"
#include <iostream>
#include <map>

using namespace std;
	
namespace xs
{	
	MessageManager warning("Warning: ");
	ShutdownManager shutdown;
	ErrorManager error;
	
	// Shutdown ________________________________________________________________
	void ShutdownManager::add(void (*func)(void))
	{
		shutdown_list[++qlist] = func;
	}
	
	void ShutdownManager::run(int excode)
	{
#ifdef DEBUG
		cout << "DEBUG | ShutdownManager::run(" << excode << ")"<< endl;
#endif

		for(int i = qlist; i > -1; i--)	{
			shutdown_list[i]();
		}
		exit(excode);
	}
	
	// Messages ________________________________________________________________
	void MessageManager::add(const char *msg)
	{		
		if(use_console)
			cout << ptext << msg << endl;
	
		message_list[++mc] = msg;
	}
	
	const char* MessageManager::get()
	{
		if(mc != -1)
		{
			return message_list[mc--].c_str();
		}
		return "";	
	}	
	
	// Errors __________________________________________________________________
	void ErrorManager::add(const char *msg)
	{		
		cout << "Error: " << msg <<  endl;
		shutdown.run(1);
	}
}

