/*  xdm - Demo manager 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2003
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "xdm.h"
#include "xs.h"
#include <sstream>
#include <iostream>

using namespace std;

namespace xdm
{		
	Manager::Manager(xio::Manager *i)
	{
		xio = i;
		move = 1.0;
#ifdef DEBUG
		skipscene = false;
		fpscount = 0;
		total_fps = 0;
#endif
	}
	
	void Manager::add(Scenebase *sc)
	{
		scene[scene.size()] = sc;
	}
	
	void Manager::runall()
	{
		int current_scene = 0;
		int rcode;
		frames = 0;
		fpsupdate = frametime = scenestart = demotime = xio->timer->getTime();
#ifdef DEBUG
		cout << "DEBUG | Scene 0 running: ";
		cout.flush();
#endif
		for(;;)
		{
			// Draw scene
			// If the current scene returns 1, switch to the next scene or quit
			xio->video->lock();
			rcode = scene[current_scene]->draw((xio->timer->getTime() - scenestart), move);
			xio->video->unlock();
			update();
			
#ifdef DEBUG
			if(skipscene) {
				rcode = 1;
				skipscene = false;
			}
#endif
			
			// The current scene has ended
			if(rcode)
			{
				
#ifdef DEBUG
				cout << "Average fps: " << (float)(((float)(total_fps))/((float)(fpscount))) << endl;
				total_fps = 0;
				fpscount = 0;
#endif
				if((unsigned)++current_scene+1 > scene.size()) {
				#ifdef DEBUG
					cout << "DEBUG | Oh no! we ran out of scenes to play :(" << endl;
					cout << "DEBUG | Total demo running time: " << (int)((xio->timer->getTime()-demotime)/1000) << " seconds." << endl;
				#endif
					xs::shutdown.run(0);
				}
				else {
					scenestart = xio->timer->getTime();
#ifdef DEBUG
					cout << "DEBUG | Scene " << current_scene << " running: ";
					cout.flush();
#endif
				}
			}
		}
	}
	
	/*void Manager::run(int sc)
	{
		fpsupdate = frametime = scenestart = xio->timer->getTime();
		frames = 0;
		int rcode;
		for(;;)
		{			
			// Draw scene
			// If scene returns 1, exit this function.
			xio->video->lock();
			rcode = scene[sc]->draw((xio->timer->getTime() - scenestart), move);
			xio->video->unlock();
			if(rcode) break;

			update();
		}
	}*/
	
	void Manager::update()
	{
#ifdef DEBUG
		if((xio->timer->getTime() - fpsupdate) >= 1000) {
			total_fps += frames;
			++fpscount;
			cout << frames << " ";
			cout.flush();
			frames = 0;
			fpsupdate = xio->timer->getTime();
		}
		frames++;
#endif
		// Update video, check for input, ...
		xio->video->update();
		xio->event->update();
#ifdef DEBUG	
		SDLKey key = xio->event->keyboard();
		if(key == SDLK_SPACE) {
			cout << "DEBUG | Current scene time: " << xio->timer->getTime() - scenestart << endl;
		}
#ifdef DEBUG
		else if(key == SDLK_TAB)
			skipscene = true;
#endif
#endif
			
		// Calcuate move based upon being 1.0 when it's 25 fps
		move = (float)(xio->timer->getTime() - frametime)/(1000/25);
		frametime = xio->timer->getTime();
	}
}
