/*  xdl - Demo launcher  
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifdef USE_GUI

#include "xdl.h"
#include "xs.h"

#include <gtk/gtk.h>

xdl::config *c; // Gtk fix...

namespace xdl
{
	Gui::Gui(int argc, char **argv, xdl::config *cfg)
	{	
		c = cfg;
		gtk_init(&argc, &argv);
	}
	
	gboolean deleteEventExit(GtkWidget *widget, GdkEvent *event, gpointer data)
	{
		gtk_main_quit();
		xs::shutdown.run(0);
		return 0;
	}
	
	gboolean deleteEvent(GtkWidget *widget, GdkEvent *event, gpointer data)
	{
		gtk_main_quit();
		return FALSE;
	}
	
	void Gui::setSoundstatus()
	{
		if(c->sound) c->sound = false;
		else if(!c->sound) c->sound = true;
	}
	
	void Gui::setWindowstatus()
	{
		if(c->fullscreen) c->fullscreen = false;
		else if(!c->fullscreen) c->fullscreen = true;
	}
	
	void Gui::setFreq22()
	{
		c->freq = 22050;
	}

	void Gui::setFreq32()
	{
		c->freq = 32000;
	}	
	
	void Gui::setFreq44()
	{
		c->freq = 44100;
	}	
	
	static GtkWidget *makeMenuItem(gchar *name, GCallback callback, gpointer data)
	{
		GtkWidget *item;
	  
		item = gtk_menu_item_new_with_label (name);
		g_signal_connect(G_OBJECT (item), "activate", callback, (gpointer) data);
		gtk_widget_show (item);
	
		return item;
	}
	
	void Gui::show(const char *sidetext)
	{
		// Window
		GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(window),
				c->window_title);
	
		gtk_container_set_border_width(GTK_CONTAINER(window), 10);
		
		g_signal_connect(G_OBJECT(window), "delete_event",
			G_CALLBACK(deleteEventExit), NULL);
		g_signal_connect(G_OBJECT(window), "delete_event",
			G_CALLBACK(gtk_widget_destroy), NULL);
			
		// Box
		GtkWidget *box = gtk_hbox_new(FALSE, 0);
		gtk_container_add(GTK_CONTAINER(window), box);
		gtk_widget_show(box);
		
		// Two boxes in the main box
		GtkWidget *boxleft = gtk_vbox_new(FALSE, 10);
		GtkWidget *boxright = gtk_vbox_new(FALSE, 10);
		gtk_box_pack_start(GTK_BOX(box), boxleft, TRUE, TRUE, 10);
		gtk_box_pack_start(GTK_BOX(box), boxright, TRUE, TRUE, 0);
		gtk_widget_show(boxleft);
		gtk_widget_show(boxright);
			
		// Three horizontal boxes in the right box
		GtkWidget *box0 = gtk_hbox_new(FALSE, 10);
		GtkWidget *box1 = gtk_hbox_new(FALSE, 10);
		GtkWidget *box2 = gtk_hbox_new(FALSE, 10);
		gtk_box_pack_start(GTK_BOX(boxright), box0, FALSE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(boxright), box1, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(boxright), box2, FALSE, TRUE, 0);
		gtk_widget_show(box0);
		gtk_widget_show(box1);
		gtk_widget_show(box2);
	
		// Text boxes
		GtkWidget *lres = gtk_label_new ("Samplerate:");
		GtkWidget *lleft =
			gtk_label_new(sidetext);
		
		// Check boxes
		GtkWidget *c0 = gtk_check_button_new_with_label("Windowed");
		GtkWidget *c1 = gtk_check_button_new_with_label("Sound");
		if(!c->fullscreen)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c0), TRUE);
		if(c->sound)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c1), TRUE);
	
		g_signal_connect(G_OBJECT(c0), "clicked", G_CALLBACK(cbWindow), NULL);
		g_signal_connect(G_OBJECT(c1), "clicked", G_CALLBACK(cbSound), NULL);
		
		// Frequency select
		GtkWidget *opt = gtk_option_menu_new();
		GtkWidget *menu = gtk_menu_new();
		GtkWidget *item;
		item = makeMenuItem("22050", G_CALLBACK(cbFreq22), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (menu), item);
		gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu); 
		item = makeMenuItem("32000", G_CALLBACK(cbFreq32), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (menu), item);
		gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu); 
		item = makeMenuItem("44100", G_CALLBACK(cbFreq44), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (menu), item);
		gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu); 
	
		// Exit button
		GtkWidget *bexit = gtk_button_new_with_label("Exit");
		
		g_signal_connect(G_OBJECT(bexit), "clicked",
			G_CALLBACK(deleteEventExit), NULL);
		g_signal_connect_swapped(G_OBJECT(bexit), "clicked",
			G_CALLBACK(gtk_widget_destroy), G_OBJECT(window));
		
		// Run button
		GtkWidget *brun = gtk_button_new_with_label("Run");
		
		g_signal_connect(G_OBJECT(brun), "clicked",
			G_CALLBACK(deleteEvent), NULL);
		g_signal_connect_swapped(G_OBJECT(brun), "clicked",
			G_CALLBACK(gtk_widget_destroy), G_OBJECT(window));
			
		// Pack stuff into boxes
		gtk_box_pack_start(GTK_BOX(box0), c0, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(box0), c1, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(box1), lres, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(box1), opt, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(boxleft), lleft, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(box2), bexit, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(box2), brun, TRUE, TRUE, 0);
	
		// Show widgets
		gtk_widget_show(bexit);
		gtk_widget_show(brun);
		gtk_widget_show(c0);
		gtk_widget_show(c1);
		gtk_widget_show(lres);
		gtk_widget_show(opt);
		gtk_widget_show(lleft);
		gtk_widget_show(window);
		
		// Wait for events
		gtk_main();
	}
}

#endif
