// NORMAL MAP VERTEX SHADER

float4x4	worldViewProj;
float4x4	invWorld;
float4x4	world;
float4		lightPosition;
float4		diffuseColor;
float		radius;

struct VS_INPUT{
	float4 position: POSITION;
	float3 normal: NORMAL;
	float2 tex: TEXCOORD0;
	float3 tangent: TANGENT0;
	float3 binormal: BINORMAL0;
};

struct VS_OUTPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
	float3 attenuation: TEXCOORD1;
	float4 diffuse: COLOR1;
	float4 color: COLOR0;
};

VS_OUTPUT main(VS_INPUT input){
	VS_OUTPUT Out = (VS_OUTPUT)0;
	
	Out.position = mul(input.position, worldViewProj);
	Out.tex = input.tex;

	//calcular light dir em tangent space
	float3 objectLightPosition = mul(lightPosition, invWorld);
	float3 objectLightDir = objectLightPosition - input.position;
	float3 lightDir;
	lightDir.x = dot(objectLightDir, input.tangent);
	lightDir.y = dot(objectLightDir, input.binormal);
	lightDir.z = dot(objectLightDir,-input.normal);
	Out.color = float4(normalize(lightDir)*0.5+0.5, 1);

	//diffuse color
	Out.diffuse = diffuseColor;

	//calcular coordenadas 3D da cube map de attenuao
	Out.attenuation = objectLightDir*radius*2;

	return Out;
}