// Effect Shader Coded by KIOKU
float4x4 mWVP;
texture MatTexture;
float4 EyeVec;
float t;

sampler Samp = sampler_state
{
	Texture = <MatTexture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float2 Tex		:	TEXCOORD
){
	VS_OUTPUT Out = (VS_OUTPUT) 0;
	Out.Pos = Pos;
	Out.Tex0 = Tex;
	return Out;
}

float4 PS_sirokuro( VS_OUTPUT In) : COLOR
{
	float4 Out = (float4) 0;
	const float3 RGB2Y = {0.2990f, 0.58700f, 0.11400f};
	float3 Color = tex2D(Samp, In.Tex0).rgb;
	Out.rgb = lerp(Color ,dot(Color, RGB2Y), t);
	Out.a = 1;
	return Out;
}

technique TSirokuro
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS_sirokuro();
	}
}

float4 PS_hanten( VS_OUTPUT In) : COLOR
{
	float4 Out = (float4) 0;
	float3 Color = tex2D(Samp, In.Tex0).rgb;
	Out.rgb = lerp(Color, (1.0f - Color), t);
	Out.a = 1;
	return Out;
}

technique THanten
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS_hanten();
	}
}

float4 PS_sepia( VS_OUTPUT In) : COLOR
{
	float4 Out = (float4) 0;
	const float3 RGB2Y =  {0.29900f,  0.58700f,  0.11400f};
	const float3 Cb2RGB = {0.00000f, -0.34414f,  1.77200f};
	const float3 Cr2RGB = {1.40200f, -0.71414f,  0.00000f};
	float3 Color = tex2D(Samp, In.Tex0).rgb;
	float3 YCbCr = dot(Color, RGB2Y);
	YCbCr.y = -0.2f;//Cb
	YCbCr.z =  0.1f;//Cr
	float3 sColor = YCbCr.x + mul(Cb2RGB, YCbCr.y) + mul(Cr2RGB, YCbCr.z);
	Out.rgb = lerp(Color, sColor, t);
	Out.a = 1;
	return Out;
}

technique TSepia
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS_sepia();
	}
}