#ifndef __FG_HPP__
#define __FG_HPP__

/****************************************************************************/

#include "_types.hpp"

/****************************************************************************/

class LandscapeTexture
{
public:
  LandscapeTexture();
  ~LandscapeTexture();

  void Render();

  sVector Camera;
  sF32 Angle;
  sInt Tex;

private:
  static const sInt xRes = 512;
  static const sInt yRes = 512;
  static const sInt gridStep = 16;
  static const sInt gridX = xRes / gridStep;
  static const sInt gridY = yRes / gridStep;

  sInt Trace(const sVector &pos,const sVector &dir);
  void CalcGrid();
  void TraceBlock(sU32 *dest,sInt xg,sInt yg,sInt t);
  void DrawGrid(sInt t);

  void CalcHeightmap();

  sF32 sa,ca;
  sInt frame;
  sInt *gridColor;
  sU8 *heightMap;
  sU32 *buffer;
};

/****************************************************************************/

#endif