/* main.c for Oj! 
 *
 * By the introx team.
 *
 * */
#include "main.h"

SDL_Surface *realscreen;
SDL_Surface *screen;
SDL_Surface *buffer;
SDL_Color palette[256];
SDL_Color savedpalette[256];
bmp graphics;
short transparent;
int pixelate_delay;

short init(void);
void intro(void);
void sineworld(void);
short deinit(void);
void plot(SDL_Surface * surface, int x, int y, Uint32 pixel);

int gtimer_add(int t)
{
    timers[timer_num].time = t;
    timers[timer_num].start = SDL_GetTicks();
    timers[timer_num].stop = timers[timer_num].time;
    timer_num++;
    return timer_num - 1;
}

int gtimer(int selectedtimer)
{
    timers[selectedtimer].current =
	(SDL_GetTicks() - timers[selectedtimer].start);
    if (timers[selectedtimer].current >= timers[selectedtimer].stop) {
	timers[selectedtimer].start = SDL_GetTicks();
	timers[selectedtimer].stop = timers[selectedtimer].time;
	return 1;
    } else {
	return 0;
    }
}

void initpal(void)
{
    short i;

    for (i = 0; i < 256; i++) {
	palette[i].r = graphics.palette[i].r;
	palette[i].g = graphics.palette[i].g;
	palette[i].b = graphics.palette[i].b;
	savedpalette[i].r = graphics.palette[i].r;
	savedpalette[i].g = graphics.palette[i].g;
	savedpalette[i].b = graphics.palette[i].b;
    }

    SDL_SetPalette(realscreen, SDL_LOGPAL | SDL_PHYSPAL, palette, 0,
		   graphics.usedcolors);
    SDL_SetPalette(screen, SDL_LOGPAL | SDL_PHYSPAL, palette, 0,
		   graphics.usedcolors);

    transparent = SDL_MapRGB(screen->format, 255, 0, 255);
    printf("0xff00ff mapped to %d.\n", transparent);

}


void readdata(SDL_Surface * img, int x0, int y0, int x1, int y1)
{
    int x, y, offset;
#ifndef FULLSCREEN
    printf("Read %dx%d.\n", x1 - x0, y1 - y0);
#endif
    offset = 0;
    for (y = y0; y < y1; y++) {
	for (x = x0; x < x1; x++) {
	    offset = x + (y * graphics.width);
	    plot(img, x - x0, y - y0, graphics.image[offset]);
	}
    }
}

void scale(SDL_Surface * in, SDL_Surface * out, short x0, short y0,
	   short x1, short y1)
{

    float xstep;
    float ystep;

    float xratio;
    float yratio;

    short xdiff;
    short ydiff;

    short xcount;
    short ycount;

    int color;

    ydiff = y1 - y0;
    xdiff = x1 - x0;

    xratio = (float) in->w / xdiff;
    yratio = (float) in->h / ydiff;

    for (ystep = 0, ycount = y0; ycount < (ydiff + y0);
	 ystep += yratio, ycount++) {
	for (xstep = 0, xcount = x0; xcount < (xdiff + x0);
	     xstep += xratio, xcount++) {
	    color = getp(in, (short) xstep, (short) ystep);
	    if (color != transparent)
		transplot(out, xcount, ycount, color);
	}
    }

}

Uint8 getp(SDL_Surface * surface, int x, int y)
{
    SDL_LockSurface(surface);
    Uint8 *p = (Uint8 *) surface->pixels + x + (y * surface->pitch);
    SDL_UnlockSurface(surface);
    return *p;
}

void plot(SDL_Surface * surface, int x, int y, Uint32 pixel)
{
    Uint8 *p = (Uint8 *) surface->pixels + y * surface->pitch + x;
    *p = pixel;
}

void transplot(SDL_Surface * surface, int x, int y, Uint32 pixel)
{
    if (pixel != transparent) {
	Uint8 *p = (Uint8 *) surface->pixels + y * surface->pitch + x;
	*p = pixel;
    }
}

short checkkey(void)
{
    SDL_Event event;
    while (SDL_PollEvent(&event)) {
	if (event.type == SDL_KEYDOWN) {
	    if (event.key.keysym.sym == SDLK_ESCAPE)
		return 1;
	    if (event.key.keysym.sym == SDLK_SPACE)
		return 2;
	}
    }
    return 0;
}


void fadeout(void)
{
    int fade, pal;

    memcpy(buffer->pixels, screen->pixels, 76800);

    for (fade = 0; fade < 128; fade++) {
	for (pal = 0; pal < 256; pal++) {
	    if (palette[pal].r > 1)
		palette[pal].r -= 2;
	    if (palette[pal].g > 1)
		palette[pal].g -= 2;
	    if (palette[pal].b > 1)
		palette[pal].b -= 2;

	}
	SDL_SetPalette(realscreen, SDL_LOGPAL | SDL_PHYSPAL, palette, 0,
		       256);
	SDL_SetPalette(screen, SDL_LOGPAL | SDL_PHYSPAL, palette, 0, 256);
	updatescreen(buffer);
    }

}


/* Don't exceed 6 passes (64*64 pixels) */
void pixelate(short passes)
{
    int x, y, pass, sum;
    int xp, yp;
    int blocksize;

    memcpy(buffer->pixels, screen->pixels, 76800);

    blocksize = 2;		/* 2 * 1 = 2 = first pass! */


    for (pass = 0; pass < passes; pass++) {

	for (x = 0; x < 320; x += blocksize) {
	    for (y = 0; y < 240; y += blocksize) {
		sum = 0;
		for (xp = 0; xp < blocksize; xp++) {
		    for (yp = 0; yp < blocksize; yp++) {
			if (y + yp < 240)
			    sum += getp(buffer, x + xp, y + yp);
		    }
		}
		sum = sum / (blocksize * blocksize);
		if (sum < 0)
		    sum = 0;
		for (xp = 0; xp < blocksize; xp++) {
		    for (yp = 0; yp < blocksize; yp++) {
			if (y + yp < 240)
			    plot(buffer, x + xp, y + yp, sum);
		    }
		}
	    }
	}

	blocksize += blocksize;	/* Next pass is twice the size of the last pass */
	memcpy(screen->pixels, buffer->pixels, 76800);
	updatescreen(screen);
	while (gtimer(pixelate_delay) != 1);

    }

}

void interlude()
{
    pixelate(6);
    fadeout();
}

/* Big thanks to will` */
void doubleblit(SDL_Surface * small, SDL_Surface * big)
{
    int x, y, so, bo;
    Uint8 *smallp, *bigp;

    for (y = 0; y < 479; y++) {
	bo = y * 640;
	so = (y >> 1) * 320;
	for (x = 0; x < 639; x++) {
	    bigp = (Uint8 *) big->pixels + (bo + x);
	    smallp = (Uint8 *) small->pixels + so + (x >> 1);
	    *bigp = *smallp;
	}
    }

}


void updatescreen(SDL_Surface * bob)
{
    doubleblit(bob, realscreen);
    SDL_Flip(realscreen);
}



int main(void)
{

    if (init() < 0) {
	printf("Cannot continue. Exit.\n");
	deinit();		/* Just in case */
	exit(1);
    }
    buffer = SDL_CreateRGBSurface(SDL_SWSURFACE, 320, 240, 8, 0, 0, 0, 0);
    screen = SDL_CreateRGBSurface(SDL_HWSURFACE, 320, 240, 8, 0, 0, 0, 0);
    pixelate_delay = gtimer_add(50);

    initpal();

    intro();
    interlude();
    sineworld();
    interlude();
    watersc();
    interlude();
    cubesc();
    interlude();
    endsc();
    interlude();
    deinit();

    return 0;
}
