#include "project.h"

char* wm_title  = "fly";
long  wm_width  = 640;
long  wm_height = 480;
char  wm_bpp    = 32;

float wm_fov    = 45.0f;
float wm_zNear  = 1.0f;
float wm_zFar   = 100.0f;

bool wm_done = false;
unsigned long wm_StartTime;
unsigned long sync;

int load_NumAll = 10;
int load_NumLoaded = 0;
bool loading = true;

int r2ttex1,r2ttex2;

#define r2tsize 256

void load_DrawLoader(float percent)
{
	//(percent==1)?(percent=0.9f):(percent+=0.0f);
	if (percent!=1) percent+=0.01f;
	int magassag = 8;
	int szelesseg = magassag*10;
	int balszel = (wm_width-szelesseg)/2;
	int felszel = (wm_height-magassag)/2;

	//glColor3f(0.7f,0.7f,0.7f);
	glColor3f(0.2f,0.2f,0.2f);
	glBegin(GL_LINE_LOOP);
		glVertex2i(balszel-2, felszel);
		glVertex2i(balszel-2, felszel+magassag+1);
		glVertex2i(balszel+szelesseg, felszel+magassag+1);
		glVertex2i(balszel+szelesseg, felszel);
	glEnd();

	for (int i=1; i<=(int)(percent*10); i++)
	{
		//float szin = 0.36f + i*0.04f;
		float szin = 0.2f + i*0.04f;
		glColor3f(szin,szin,szin);
		glBegin(GL_QUADS);
			glVertex2i(balszel + (i-1)*magassag, felszel + 1);
			glVertex2i(balszel + (i-1)*magassag, felszel + magassag - 1);
			glVertex2i(balszel + i*magassag - 1, felszel + magassag - 1);
			glVertex2i(balszel + i*magassag - 1, felszel + 1);
		glEnd();
	}
	glColor3f(1,1,1);


	r2ttex1=tx_CreateR2T(r2tsize);
	r2ttex2=tx_CreateR2T(r2tsize);
}

void wm_DisplayTitle(const char *fmt, ...)
{
	char titletext[256];
	va_list list;
	if (fmt==NULL) return;
	va_start(list,fmt);
	vsprintf(titletext,fmt,list);
	va_end(list);
	SetWindowText(wm_hWnd,titletext);
}

inline void Init() 
{
#ifndef MUSIC_OFF
	Music_Init("funk.mp3");
#endif

}

inline void DeInit() 
{
#ifndef MUSIC_OFF
	Music_Close();
#endif

}


inline void MainLoop()
{
	if (loading) // init 
	{
		set2d(0,0,wm_width,wm_height);
		// load one item, or rather one whole scene //
		load_DrawLoader(((load_NumLoaded++)%load_NumAll)/(float)load_NumAll);
		if (load_NumLoaded==load_NumAll) 
		{
			loading=false;
			#ifdef MUSIC_OFF
				wm_StartTime=timeGetTime();
			#else
				wm_StartTime=0;
				Music_Play();
			#endif
			set3d(wm_fov,(float)wm_width/(float)wm_height,wm_zNear,wm_zFar);
		}
	} else { // demo
		//set2d(0,0,wm_width,wm_height);
		//load_DrawLoader(1.0f);
		sync = GetSync;

		// EZT FOGJUK ZOOMOLNI
		tx_BeginR2T(r2tsize);
			//glBindTexture(GL_TEXTURE_2D,tex);
				set3d(wm_fov,wm_width/(float)wm_height,wm_zFar,wm_zNear);
				glTranslatef(0,0,-5);
				glDisable(GL_TEXTURE_2D);
				glBegin(GL_QUADS);
					glVertex2i(-1, 1);
					glVertex2i(-1,-1);
					glVertex2i( 1,-1);
					glVertex2i( 1, 1);
				glEnd();
				glEnable(GL_TEXTURE_2D);
			tx_R2T(r2ttex1,r2tsize);
		tx_EndR2T(wm_width,wm_height);

		set2d(0,0,wm_width,wm_height);
		
		glEnable(GL_TEXTURE_2D);

			glColor4f(1,1,1,0.5f);

			// 1. PASS - 2 LAYERS
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			tx_BeginR2T(r2tsize);
				glDepthMask(false);
				glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex1);
				glBegin(GL_QUADS);
					glTexCoord2f(0,1); glVertex2i(0,0);
					glTexCoord2f(0,0); glVertex2i(0,wm_height);
					glTexCoord2f(1,0); glVertex2i(wm_width,wm_height);
					glTexCoord2f(1,1); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);

				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex1);
				glBegin(GL_QUADS);
					glTexCoord2f(0.25f,0.25f); glVertex2i(0,0);
					glTexCoord2f(0.25f,0.75f); glVertex2i(0,wm_height);
					glTexCoord2f(0.75f,0.75f); glVertex2i(wm_width,wm_height);
					glTexCoord2f(0.75f,0.25f); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);
			tx_R2T(r2ttex2,r2tsize);
			tx_EndR2T(wm_width,wm_height);

			// 2. PASS - 4 LAYERS
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			tx_BeginR2T(r2tsize);
				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex2);
				glBegin(GL_QUADS);
					glTexCoord2f(0,1); glVertex2i(0,0);
					glTexCoord2f(0,0); glVertex2i(0,wm_height);
					glTexCoord2f(1,0); glVertex2i(wm_width,wm_height);
					glTexCoord2f(1,1); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);

				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex2);
				glBegin(GL_QUADS);
					glTexCoord2f(0.125f,0.125f); glVertex2i(0,0);
					glTexCoord2f(0.125f,0.875f); glVertex2i(0,wm_height);
					glTexCoord2f(0.875f,0.875f); glVertex2i(wm_width,wm_height);
					glTexCoord2f(0.875f,0.125f); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);
			tx_R2T(r2ttex1,r2tsize);
			tx_EndR2T(wm_width,wm_height);

			// 3. PASS - 8 LAYERS
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			tx_BeginR2T(r2tsize);
				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex1);
				glBegin(GL_QUADS);
					glTexCoord2f(0,1); glVertex2i(0,0);
					glTexCoord2f(0,0); glVertex2i(0,wm_height);
					glTexCoord2f(1,0); glVertex2i(wm_width,wm_height);
					glTexCoord2f(1,1); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);

				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex1);
				glBegin(GL_QUADS);
					glTexCoord2f(0.0625f,0.0625f); glVertex2i(0,0);
					glTexCoord2f(0.0625f,0.9375f); glVertex2i(0,wm_height);
					glTexCoord2f(0.9375f,0.9375f); glVertex2i(wm_width,wm_height);
					glTexCoord2f(0.9375f,0.0625f); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);
			tx_R2T(r2ttex2,r2tsize);
			tx_EndR2T(wm_width,wm_height);

			// 4. PASS - 16 LAYERS
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			tx_BeginR2T(r2tsize);
				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex2);
				glBegin(GL_QUADS);
					glTexCoord2f(0,1); glVertex2i(0,0);
					glTexCoord2f(0,0); glVertex2i(0,wm_height);
					glTexCoord2f(1,0); glVertex2i(wm_width,wm_height);
					glTexCoord2f(1,1); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);

				//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex2);
				glBegin(GL_QUADS);
					glTexCoord2f(0.03125f,0.03125f); glVertex2i(0,0);
					glTexCoord2f(0.03125f,0.96875f); glVertex2i(0,wm_height);
					glTexCoord2f(0.96875f,0.96875f); glVertex2i(wm_width,wm_height);
					glTexCoord2f(0.96875f,0.03125f); glVertex2i(wm_width,0);
				glEnd();
				//glDisable(GL_BLEND);
				//glDepthMask(true);
			tx_R2T(r2ttex1,r2tsize);
			tx_EndR2T(wm_width,wm_height);


			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glColor4f(1,1,1,1);
			//glDepthMask(false);
				//glEnable(GL_BLEND);
				//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glBindTexture(GL_TEXTURE_2D,r2ttex1);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0); glVertex2i(0,0);
					glTexCoord2f(0,1); glVertex2i(0,wm_height);
					glTexCoord2f(1,1); glVertex2i(wm_width,wm_height);
					glTexCoord2f(1,0); glVertex2i(wm_width,0);
				glEnd();
				glDisable(GL_BLEND);
			glDepthMask(true);




		glDisable(GL_TEXTURE_2D);

		
		//metro_play(sync);
		//kalapacs_play(sync);

		wm_DisplayTitle("%s | %d",wm_title,sync);
		//if (GetSync>=3000) wm_done=true;
	}
}

//------------------------------------------------------------------
//- THE WINMAIN FUNCTION -------------------------------------------
//------------------------------------------------------------------

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	/*switch (MessageBox(NULL,"Fullscreen?","Screen mode",MB_YESNOCANCEL))
	{
		case IDYES: wm_fullscreen=true; break;
		case IDNO: wm_fullscreen=false; break;
		case IDCANCEL: exit(0); break;
	}*/
	if (!wm_Init(wm_width,wm_height,wm_bpp,false,wm_title,wm_fov,wm_zNear,wm_zFar)) return 0;

	Init();

	MSG	msg;
	while(!wm_done)
	{
 		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if (msg.message==WM_QUIT)
			{
				wm_done=true;
			}
			else
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
		{
			if (wm_esc)
			{
				wm_done=true;
			}
			else
			{
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
				glLoadIdentity();

				MainLoop();

				SwapBuffers(wm_hDC);
			}
		}
	}
	DeInit();
	wm_Kill();
	return (msg.wParam);
}