
#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
#endregion

/** boozembly 04 invitation
 * ported in from original java midlet to xna, to complement multiplatform offering
 * uses sprites, rendertarget and a pixelshader! :)
 * 
 * march 2007
 * 
 * @author jmagic@komplex.org
 */
namespace booze04
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        ContentManager content;


        Effect fx;
        Texture2D bg;
        Texture2D text;
        Texture2D damage;

        int[] textH ={ 0, 128, 236, 348, 452, 541, 620, 680, 730, 830, 830 };
        const int textCount = 13;
        int[] ordnung ={ 9, 0, 1, 2, 4, 5, 6, 2, 7, 8, 9, 3, 9 };
        float xrnd = 0, yrnd = 0;
        float xrnd2, yrnd2;

        Random rnd = new Random();

        const int WIDTH = 228;
        const int HEIGHT = 128;

        int frames;

        protected void render(int t) // t is seconds/100
        {
            frames++;
            spriteBatch.Begin();

            int offset = 0;

            int wb = (bg.Width - WIDTH);
            if (wb > 0)
            {
                offset = t / 5;
                int cnt = offset / wb;
                offset = offset % wb;
                if ((cnt & 1) != 0) offset = wb - offset;
            }

            //g.drawImage(bg, -offset, y, null);
            spriteBatch.Draw(bg, new Vector2(-offset, 0), Color.White);

            int idx = (t / 400) % textCount;

            idx = ordnung[idx];

            //idx=1;

            int xt = WIDTH / 2 - 64;
            int ht = textH[idx + 1] - textH[idx];

            int yoff = (128 - ht) / 2;

            if ((t & 15) < 8)
            {
                xrnd = (7 * xrnd + ((frames * frames & 15) - 8)) / 8.0f;
                yrnd = (3 * yrnd + ((frames * frames * frames & 15) - 8)) / 4.0f;
            }

            float y1 = yrnd + yoff;
            float y2 = y1 + ht;
            if (y1 < 0) y1 = 0;
            if (y2 > 128) y2 = 128;

            //if((t&0x16)==0x10)
            {
                xrnd2 = (xrnd2 * 15 + (((frames + 5) * frames & 63))) / 16.0f;
                yrnd2 = (yrnd2 * 15 + ((frames * frames * frames * (frames + 3) & 127))) / 16.0f;
            }

            //g.drawImage(damage, -xrnd2, -yrnd2, null);
            spriteBatch.Draw(damage, new Vector2(-xrnd2, -yrnd2), Color.White);
            spriteBatch.Draw(damage, new Vector2(-xrnd2 + damage.Width, -yrnd2), Color.White);


            // g.setClip(0, y + y1, w, y2 - y1);
            // g.drawImage(text, xt + xrnd, y + yrnd + yoff - textH[idx], null);

            spriteBatch.Draw(text, new Vector2(xt + xrnd, yrnd + yoff - 0),
                new Rectangle(0, textH[idx], 128, (int)(y2 - y1)),
                Color.White);
            spriteBatch.End();

        }






        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            content = new ContentManager(Services);
            graphics.PreferredBackBufferWidth = WIDTH * 3;
            graphics.PreferredBackBufferHeight = HEIGHT * 3;
        }

        AudioEngine audioEngine;
        WaveBank waveBank;
        SoundBank soundBank;
        Cue cue;

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();

            audioEngine = new AudioEngine("booze04.xgs");
            waveBank = new WaveBank(audioEngine, "Wave Bank.xwb");
            soundBank = new SoundBank(audioEngine, "Sound Bank.xsb");
            cue = soundBank.GetCue("loop");
            cue.Play();
        }

        SpriteBatch spriteBatch;


        /// <summary>
        /// Load your graphics content.  If loadAllContent is true, you should
        /// load content from both ResourceManagementMode pools.  Otherwise, just
        /// load ResourceManagementMode.Manual content.
        /// </summary>
        /// <param name="loadAllContent">Which type of content to load.</param>
        protected override void LoadGraphicsContent(bool loadAllContent)
        {
            if (loadAllContent)
            {
                // TODO: Load any ResourceManagementMode.Automatic content
            }

            back = new RenderTarget2D(graphics.GraphicsDevice, WIDTH, HEIGHT, 1, graphics.GraphicsDevice.DisplayMode.Format);

            spriteBatch = new SpriteBatch(graphics.GraphicsDevice);
            bg = content.Load<Texture2D>("bg");
            damage = content.Load<Texture2D>("damage");
            text = content.Load<Texture2D>("boozetext2");

            fx = content.Load<Effect>("hoax");
            // TODO: Load any ResourceManagementMode.Manual content
        }

        RenderTarget2D back;

        /// <summary>
        /// Unload your graphics content.  If unloadAllContent is true, you should
        /// unload content from both ResourceManagementMode pools.  Otherwise, just
        /// unload ResourceManagementMode.Manual content.  Manual content will get
        /// Disposed by the GraphicsDevice during a Reset.
        /// </summary>
        /// <param name="unloadAllContent">Which type of content to unload.</param>
        protected override void UnloadGraphicsContent(bool unloadAllContent)
        {
            if (unloadAllContent == true)
            {
                content.Unload();
            }
        }


        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the default game to exit on Xbox 360 and Windows
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            base.Update(gameTime);
        }


        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice device = graphics.GraphicsDevice;

            device.SetRenderTarget(0, back);
            render((int)(gameTime.TotalGameTime.TotalSeconds * 100));

            device.ResolveRenderTarget(0);
            device.SetRenderTarget(0, null);

            spriteBatch.Begin(SpriteBlendMode.None, SpriteSortMode.Immediate, SaveStateMode.None);

            fx.Parameters["screenWidth"].SetValue(device.Viewport.Width);
            fx.Begin();

            foreach (EffectPass pass in fx.CurrentTechnique.Passes)
            {
                pass.Begin();
                //device.Viewport
                spriteBatch.Draw(back.GetTexture(), new Rectangle(0, 0, device.Viewport.Width, device.Viewport.Height), Color.White);
                pass.End();
            }

            fx.End();

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}