#ifndef PLAY_H
#define PLAY_H

#define NUM_CHANNELS 6
#define TRACK_LENGTH 32
#define MAX_SONG_LENGTH 32
#define MAX_PATTERNS 16
#define MAX_TRACKS 16
#define MAX_INSTRUMENTS 8

typedef struct Track_STRUCT
{
	Uint8 note[TRACK_LENGTH];
	Uint8 vol[TRACK_LENGTH];
	//int fx[TRACK_LENGTH];
} Track;

typedef struct Pattern_STRUCT
{
	int tracks[NUM_CHANNELS];
	int transpose[NUM_CHANNELS];
} Pattern;

typedef struct Song_STRUCT
{
	int ptn_list[MAX_SONG_LENGTH];
	int speed;	// Rows-per-beat
	float tempo;	// BPM
	Pattern ptns[MAX_PATTERNS];
	Track tracks[MAX_TRACKS];
	Instr insts[MAX_INSTRUMENTS];
} Song;


#endif
