#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWVP;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

SPosTex vsMain( SPosTex i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv;
	return o;
}

half4 psMain( SPosTex i ) : COLOR {
	half4 clmap = tex2D( smpBase, i.uv );
	return clmap;
}


technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_1 psMain();
	}
	pass PLast {
	}
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = NULL;

		Sampler[0] = (smpBase);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
	}
}
