#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};
texture		tShadow1;
sampler2D	smpShadow1 = sampler_state {
	Texture = <tShadow1>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};
texture		tShadow2;
sampler2D	smpShadow2 = sampler_state {
	Texture = <tShadow2>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};
texture		tRefl;
sampler2D	smpRefl = sampler_state {
	Texture = <tRefl>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};


struct SOutput {
	float4 pos : POSITION;
	float4 uv[3] : TEXCOORD0; // 2 shadowmaps, 1 reflection
};

SOutput vsMain11( SPos i ) {
	SOutput o;
	o.pos = mul( i.pos, mWVP );
	float4 vpos = mul( i.pos, mWorldView );
	o.uv[0] = mul( vpos, mShadowProj1 );
	o.uv[1] = mul( vpos, mShadowProj2 );
	o.uv[2] = mul( vpos, mViewTexProj );
	return o;
}

half4 psMain( SOutput i ) : COLOR {
	half4 csh1 = tex2D( smpShadow1, i.uv[0] );
	half4 csh2 = tex2D( smpShadow2, i.uv[1] );
	half4 cref = tex2D( smpRefl, i.uv[2] );
	return lerp( cref, csh1*csh2, 0.5 );
}


SPosTexp2 vsMainFFa( SPos i ) {
	SPosTexp2 o;
	o.pos = mul( i.pos, mWVP );
	float4 vpos = mul( i.pos, mWorldView );
	o.uvp[0] = mul( vpos, mShadowProj1 );
	o.uvp[1] = mul( vpos, mShadowProj2 );
	return o;
}
SPosTexp vsMainFFb( SPos i ) {
	SPosTexp o;
	o.pos = mul( i.pos, mWVP );
	float4 vpos = mul( i.pos, mWorldView );
	o.uvp = mul( vpos, mViewTexProj );
	return o;
}

technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain();

		TextureTransformFlags[0] = Projected;
		TextureTransformFlags[1] = Projected;
		TextureTransformFlags[2] = Projected;
	}
	pass PLast {
		TextureTransformFlags[0] = Disable;
		TextureTransformFlags[1] = Disable;
		TextureTransformFlags[2] = Disable;
		Texture[0] = NULL;
		Texture[1] = NULL;
		Texture[2] = NULL;
	}
}

technique tecFFP {
	// two shadowmaps
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFFa();
		PixelShader = NULL;

		TextureTransformFlags[0] = Projected;
		TextureTransformFlags[1] = Projected;

		Sampler[0] = (smpShadow1);
		Sampler[1] = (smpShadow2);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;

		ColorOp[1]	 = Modulate;
		ColorArg1[1] = Texture;
		ColorArg2[1] = Current;
		AlphaOp[1]	 = SelectArg1;
		AlphaArg1[1] = Texture;

		ColorOp[2]	 = Disable;
		AlphaOp[2]	 = Disable;
	}
	// blend with reflection
	pass P1 {
		VertexShader = compile vs_1_1 vsMainFFb();
		PixelShader = NULL;

		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		Sampler[0] = (smpRefl);
		TextureFactor = (float4(1,1,1,0.5));

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = TFactor;

		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
		AlphaBlendEnable = False;
		ZWriteEnable = True;
		TextureTransformFlags[0] = Disable;
		TextureTransformFlags[1] = Disable;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}
