#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};
texture		tShadow1;
sampler2D	smpShadow1 = sampler_state {
	Texture = <tShadow1>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

struct SOutput {
	float4 pos  : POSITION;
	float2 uv	: TEXCOORD0;
	float4 uvs  : TEXCOORD1;
};

SOutput vsMain( SPosTex i ) {
	SOutput o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv;
	float4 vpos = mul( i.pos, mWorldView );
	o.uvs = mul( vpos, mShadowProj1 );
	return o;
}

half4 psMain( SOutput i ) : COLOR {
	half4 clmap = tex2D( smpBase, i.uv );
	half4 csh1 = tex2D( smpShadow1, i.uvs );
	return clmap * csh1;
}


technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_1 psMain();
		TextureTransformFlags[1] = Projected;
	}
	pass PLast {
		TextureTransformFlags[1] = Disable;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = NULL;
		
		TextureTransformFlags[1] = Projected;

		Sampler[0] = (smpBase);
		Sampler[1] = (smpShadow1);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;

		ColorOp[1]	 = Modulate;
		ColorArg1[1] = Texture;
		ColorArg2[1] = Current;
		AlphaOp[1]	 = SelectArg1;
		AlphaArg1[1] = Texture;

		ColorOp[2]	 = Disable;
		AlphaOp[2]	 = Disable;
	}
	pass PLast {
		TextureTransformFlags[1] = Disable;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}
