#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

texture		tBase;
sampler2D	smpBase = sampler_state {
	Texture = <tBase>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};
texture		tShadow1;
sampler2D	smpShadow1 = sampler_state {
	Texture = <tShadow1>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};
texture		tShadow2;
sampler2D	smpShadow2 = sampler_state {
	Texture = <tShadow2>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

struct SOutput11 {
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
	float4 uvs[2] : TEXCOORD1;
};

SOutput11 vsMain11( SPosTex2 i ) {
	SOutput11 o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv[1];
	float4 vpos = mul( i.pos, mWorldView );
	o.uvs[0] = mul( vpos, mShadowProj1 );
	o.uvs[1] = mul( vpos, mShadowProj2 );
	return o;
}

half4 psMain( SOutput11 i ) : COLOR {
	half4 clmap = tex2D( smpBase, i.uv );
	half4 csh1 = tex2D( smpShadow1, i.uvs[0] );
	half4 csh2 = tex2D( smpShadow2, i.uvs[1] );
	return clmap * csh1 * csh2;
}


SPosTex vsMainFFa( SPosTex2 i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv[1];
	return o;
}
SPosTexp2 vsMainFFb( SPosTex2 i ) {
	SPosTexp2 o;
	o.pos = mul( i.pos, mWVP );
	float4 vpos = mul( i.pos, mWorldView );
	o.uvp[0] = mul( vpos, mShadowProj1 );
	o.uvp[1] = mul( vpos, mShadowProj2 );
	return o;
}


technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain();
		TextureTransformFlags[1] = Projected;
		TextureTransformFlags[2] = Projected;
	}
	pass PLast {
		TextureTransformFlags[1] = Disable;
		TextureTransformFlags[2] = Disable;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

technique tecFFP {
	// base tex
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFFa();
		PixelShader = NULL;

		Sampler[0] = (smpBase);
		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	// modulate two shadow maps
	pass P1 {
		VertexShader = compile vs_1_1 vsMainFFb();
		PixelShader = NULL;

		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;

		ZWriteEnable = False;

		TextureTransformFlags[0] = Projected;
		TextureTransformFlags[1] = Projected;

		Sampler[0] = (smpShadow1);
		Sampler[1] = (smpShadow2);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;

		ColorOp[1]	 = Modulate;
		ColorArg1[1] = Texture;
		ColorArg2[1] = Current;
		AlphaOp[1]	 = SelectArg1;
		AlphaArg1[1] = Texture;

		ColorOp[2]	 = Disable;
		AlphaOp[2]	 = Disable;
	}
	pass PLast {
		TextureTransformFlags[0] = Disable;
		TextureTransformFlags[1] = Disable;

		AlphaBlendEnable = False;
		ZWriteEnable = True;

		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}
