
#include "lib/structs.fx"
#include "lib/shared.fx"

float4x4 mWorld;
float4x4 mWorldView;
float4x4	mWVP;

texture tEnv;
sampler2D	smpEnv = sampler_state {
	Texture = <tEnv>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};


SPosTex vsMain11( SPosN i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	
	float3 wpos = mul( i.pos, mWorld );
	float3 wn = mul( i.normal, mWorld );
	float3 wrefl = reflect( normalize(vEye-wpos), wn );
	wrefl = mul( wrefl, mView );
	o.uv = wrefl * 0.5 + 0.5;
	
	return o;
}


float4 psMain11( SPosTex i ) : COLOR
{
	return tex2D( smpEnv, i.uv );
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
	}
	pass PLast {
	}
}

technique tecFF {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = NULL;
		
		Sampler[0] = (smpEnv);
		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PLast {
	}
}
