//
// Screen aligned textured/colored billboards.
//
// ps1.1, FFP
// 

#include "lib/shared.fx"
#include "lib/structs.fx"

texture		tBase;
sampler2D smpBase = sampler_state {
	Texture = (tBase);
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};


SPosColTex vsMain11( SPosColTex i )
{
	i.pos.y = -i.pos.y;
	return i;
}


half4 psMain11( SPosColTex i ) : COLOR
{
	return tex2D( smpBase, i.uv ) * i.color;
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
		ZWriteEnable = False;
		ZEnable = False;
		CullMode = None;
		AlphaTestEnable = True;
		AlphaFunc = Greater;
		AlphaRef = 5;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
	pass PLast {
		ZWriteEnable = True;
		ZEnable = True;
		CullMode = (iCull);
		AlphaTestEnable = False;
		AlphaBlendEnable = False;
	}
}


technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = NULL;
		ZWriteEnable = False;
		ZEnable = False;
		CullMode = None;
		AlphaTestEnable = True;
		AlphaFunc = Greater;
		AlphaRef = 5;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		Sampler[0] = (smpBase);
		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = Diffuse;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = Diffuse;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PLast {
		ZWriteEnable = True;
		ZEnable = True;
		CullMode = (iCull);
		AlphaTestEnable = False;
		AlphaBlendEnable = False;
	}
}
