var canvas;
var startTime;
var loadingBanner;
var refreshRate = document.location.search.substring(1);

/* titles */
var pageGap = 7000;
var pageEndTime = 6000;
var switchTime1 = 3500;
var switchTime2 = 6500;
var letterGap = 100;
var spriteGap = 100;
var letters;
var letterImages = {};
var spriplets = [];
var spripletCount = 38;
var cosPath = [];
var fudgeFactor = [32, 48, 56];
var textData;
var blocks;
var titleContainer;

/* bump */
var bumpContainer;
var initedBump = false;

/* copper */
var barCount = 180;
var copperBar = [];
var copperSine = [];
var scrollyText = [
	' ',' ',' ',' ',' ',' ',' ',
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	'1','9','9','2',' ','c','a','l','l','e','d','.','.','.',' ',
	't','h','e','y',' ','w','a','n','t',' ','t','h','e','i','r',' ',
	'e','f','f','e','c','t','s',' ','b','a','c','k',
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
];
var scrollyLetter = [];
var copperContainer;
var msPerLetter = 200;
var pixPerLetter = 864 / 16;
var initedCopper = false;

/* wormhole */
var ringImages = [];
var ringSprites = [];
var ringSpacing = 0.4;
var wormholeContainer;
var initedWormhole = false;
var wormholeSinLen = 1;

/* vectorballs */
var vectorBallsContainer;
var initedVectorBalls = false;
var ballCount = 56;
var ball;
var ballImg;

/* mandelbrot */
var zoomRate = 2.593;	/* ratio of magnification at time t:t+1 seconds */
var logZoomRate = Math.log(zoomRate);
var log2 = Math.log(2);
var tileChangePeriod = log2 / logZoomRate;
var lastFrameNumber = -1;
var mandelFrames = [];
var frameScale = 1;
var initedMandelbrot = false;

/* wolf */
var initedWolf = false;
var wolfContainer;
var camX = 1.5;
var camY = 1.5;
var degreeBearing = 0;
var angleOfVision = Math.PI / 6;
var stripCount = 80;
var dt = 2 * angleOfVision / stripCount;
var strips = [];
var wolfImages = [];
var maze;
var bezierMatrix = [
	[-1/6, 1/2, -1/2, 1/6],
	[1/2, -1, 0, 2/3],
	[-1/2, 1/2, 1/2, 1/6],
	[1/6, 0, 0, 0]
];
var splinetrixCache = [];
var wolfPath;

/* gouraud */
var gouraudContainer;
var asciiCanvas;
var pseudocodeCanvas;
var bmp = [];
var shades = ['  ', '..', '::', ';;', '//', '00', '@@', '##', '##', '##', '##', '##'];
var yBuffer = [];
var zBuffer = [];
var pseudocode;
var vertex;
var initedGouraud = false;

/* landscape */
var screenHeight = 267;
var aspect = 1.5;
var voxels = [];
var voxelContainer;
var credits = [];
var heightmap;
var zCount = 24;
var xCount = 24;
var landColor = [
	'#000077','#000077','#000077','#000088','#00bb00','#00aa00','#009900','#008800',
	'#007700','#006600','#005500','#004400','#003300','#002200','#001100','#000000'
];
var initedLandscape = false;

function go() {
	canvas = document.createElement('div');
	canvas.className = 'canvas';
	document.getElementById('container').appendChild(canvas);
	loadingBanner = document.createElement('div');
	loadingBanner.className = 'loading_banner';
	loadingBanner.appendChild(document.createTextNode('loading...'));
	canvas.appendChild(loadingBanner);
	setTimeout(globalSetup, 100);
}

function globalSetup() {
	/* titles */
	letters = {a: 22, c: 18, d: 19, e: 21, f: 12, h: 19, i: 7, j: 6, l: 7, m: 31, n: 19, o: 21, p: 21, r: 13, s: 18, t: 11, u: 19, v: 20, w: 29, y: 20, 0: 8, 1: 11};
	textData = [
[{x: 224, y: 150, letter: 'o'},{x: 127, y: 150, letter: 'l'},{x: 151, y: 150, letter: 't'},{x: 173, y: 150, letter: 'y'}]
,[{x: 258, y: 150, letter: 'n'},{x: 147, y: 150, letter: 'i'},{x: 175, y: 150, letter: 'h'},{x: 206, y: 150, letter: 'e'}]
,[{x: 317, y: 150, letter: 'a'},{x: 167, y: 150, letter: 'v'},{x: 207, y: 150, letter: 'e'},{x: 240, y: 150, letter: 's'}]
,[{x: 379, y: 150, letter: 'd'},{x: 200, y: 150, letter: 'e'},{x: 241, y: 150, letter: 'y'},{x: 271, y: 150, letter: '0'}]
,[{x: 411, y: 150, letter: 'i'},{x: 234, y: 150, letter: 's'},{x: 301, y: 150, letter: 'w'},{x: 319, y: 150, letter: 'j'}]
,[{x: 431, y: 150, letter: 's'},{x: 292, y: 150, letter: 'a'},{x: 343, y: 150, letter: 'r'},{x: 338, y: 150, letter: 'a'}]
,[{x: 462, y: 150, letter: 't'},{x: 354, y: 150, letter: 'c'},{x: 369, y: 150, letter: 'i'},{x: 373, y: 150, letter: 'v'}]
,[{x: 486, y: 150, letter: 'a'},{x: 385, y: 150, letter: 'i'},{x: 389, y: 150, letter: 't'},{x: 406, y: 150, letter: 'a'}]
,[{x: 521, y: 150, letter: 'n'},{x: 405, y: 150, letter: 'v'},{x: 413, y: 150, letter: 'e'},{x: 441, y: 150, letter: 's'}]
,[{x: 553, y: 150, letter: 't'},{x: 438, y: 150, letter: 'i'},{x: 474, y: 150, letter: 'd'},{x: 472, y: 150, letter: 'c'}]
,[{x: 183, y: 300, letter: 'l'},{x: 458, y: 150, letter: 'l'},{x: 506, y: 150, letter: 'e'},{x: 503, y: 150, letter: 'r'}]
,[{x: 203, y: 300, letter: 'u'},{x: 478, y: 150, letter: 'i'},{x: 540, y: 150, letter: 'm'},{x: 529, y: 150, letter: 'i'}]
,[{x: 235, y: 300, letter: 'n'},{x: 498, y: 150, letter: 's'},{x: 584, y: 150, letter: 'o'},{x: 549, y: 150, letter: 'p'}]
,[{x: 267, y: 300, letter: 'a'},{x: 529, y: 150, letter: 'a'},{x: 618, y: 150, letter: 's'},{x: 583, y: 150, letter: 't'}]
,[{x: 302, y: 300, letter: 'r'},{x: 564, y: 150, letter: 't'},{x: 92, y: 300, letter: 'e'},{x: 607, y: 150, letter: '0'}]
,[{x: 355, y: 300, letter: 'h'},{x: 588, y: 150, letter: 'i'},{x: 126, y: 300, letter: 'n'},{x: 270, y: 300, letter: '1'}]
,[{x: 387, y: 300, letter: 'i'},{x: 608, y: 150, letter: 'o'},{x: 158, y: 300, letter: 't'},{x: 270, y: 300, letter: '1'}]
,[{x: 407, y: 300, letter: 'd'},{x: 642, y: 150, letter: 'n'},{x: 182, y: 300, letter: 'i'},{x: 270, y: 300, letter: '1'}]
,[{x: 439, y: 300, letter: 'e'},{x: 18, y: 300, letter: 'f'},{x: 202, y: 300, letter: 'r'},{x: 270, y: 300, letter: '1'}]
,[{x: 473, y: 300, letter: 'a'},{x: 43, y: 300, letter: 'a'},{x: 228, y: 300, letter: 'e'},{x: 270, y: 300, letter: '1'}]
,[{x: 508, y: 300, letter: 'w'},{x: 78, y: 300, letter: 'r'},{x: 262, y: 300, letter: 'l'},{x: 270, y: 300, letter: '1'}]
,[{x: 550, y: 300, letter: 'a'},{x: 131, y: 300, letter: 'i'},{x: 282, y: 300, letter: 'y'},{x: 270, y: 300, letter: '1'}]
,[{x: 585, y: 300, letter: 'y'},{x: 151, y: 300, letter: 'n'},{x: 342, y: 300, letter: 'i'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 210, y: 300, letter: 'a'},{x: 362, y: 300, letter: 'n'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 245, y: 300, letter: 'd'},{x: 421, y: 300, letter: 'j'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 277, y: 300, letter: 'v'},{x: 440, y: 300, letter: 'a'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 310, y: 300, letter: 'a'},{x: 475, y: 300, letter: 'v'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 345, y: 300, letter: 'n'},{x: 508, y: 300, letter: 'a'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 377, y: 300, letter: 'c'},{x: 543, y: 300, letter: 's'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 408, y: 300, letter: 'e'},{x: 574, y: 300, letter: 'c'},{x: 270, y: 300, letter: '1'}]
,[{x: 0, y: 0, letter: '1'},{x: 469, y: 300, letter: 'o'},{x: 605, y: 300, letter: 'r'},{x: 270, y: 300, letter: 'n'}]
,[{x: 0, y: 0, letter: '1'},{x: 503, y: 300, letter: 'f'},{x: 631, y: 300, letter: 'i'},{x: 302, y: 300, letter: 'o'}]
,[{x: 0, y: 0, letter: '1'},{x: 555, y: 300, letter: 'o'},{x: 651, y: 300, letter: 'p'},{x: 336, y: 300, letter: 't'}]
,[{x: 0, y: 0, letter: '1'},{x: 589, y: 300, letter: 'u'},{x: 685, y: 300, letter: 't'},{x: 387, y: 300, letter: 'j'}]
,[{x: 0, y: 0, letter: '1'},{x: 621, y: 300, letter: 'r'},{x: 0, y: 0, letter: '1'},{x: 406, y: 300, letter: 'a'}]
,[{x: 0, y: 0, letter: '1'},{x: 674, y: 300, letter: 'o'},{x: 0, y: 0, letter: '1'},{x: 441, y: 300, letter: 'v'}]
,[{x: 0, y: 0, letter: '1'},{x: 708, y: 300, letter: 'w'},{x: 0, y: 0, letter: '1'},{x: 474, y: 300, letter: 'a'}]
,[{x: 0, y: 0, letter: '1'},{x: 750, y: 300, letter: 'n'},{x: 0, y: 0, letter: '1'},{x: 509, y: 300, letter: '0'}]
];
	for (l in letters) {
		letterImages[l] = [];
		for (var j = 0; j < 16; j++) {
			letterImages[l][j] = new Image;
			letterImages[l][j].src = "titles/letter_" + l + '_' + j + ".png";
		}
	}
	titleContainer = document.createElement('div');
	titleContainer.className = 'part_container';
	canvas.appendChild(titleContainer);
	for (var i = 0; i < spripletCount; i++) {
		spriplets[i] = [];
		for (var j = 0; j < 3; j++) {
			spriplets[i][j] = document.createElement('img');
			spriplets[i][j].height = 40;
			spriplets[i][j].width = 20;
			spriplets[i][j].className = 'sprite';
			titleContainer.appendChild(spriplets[i][j]);
		}
	}
	for (var i = 0; i < 512; i++) {
		cosPath[i] = 255 * Math.cos(i * Math.PI / 512);
	}

	/* bump */
	blocks = {
		top: [
			{x1: 1, y1: 7, x2: 13, y2: 8},
			{x1: 13, y1: 8, x2: 14, y2: 9},
			
			{x1: 17, y1: 7, x2: 24, y2: 8},
			{x1: 16, y1: 8, x2: 17, y2: 9},
			{x1: 24, y1: 8, x2: 25, y2: 9},
			{x1: 19, y1: 15, x2: 22, y2: 16},

			{x1: 28, y1: 7, x2: 35, y2: 8},
			{x1: 27, y1: 8, x2: 28, y2: 9},
			{x1: 35, y1: 8, x2: 36, y2: 9},
			{x1: 30, y1: 15, x2: 33, y2: 16},

			{x1: 38, y1: 7, x2: 46, y2: 8},
			{x1: 46, y1: 8, x2: 47, y2: 9},

			{x1: 50, y1: 7, x2: 58, y2: 8},
			{x1: 49, y1: 8, x2: 50, y2: 9},
			{x1: 52, y1: 15, x2: 58, y2: 16},

			{x1: 60, y1: 1, x2: 63, y2: 2},
			{x1: 63, y1: 7, x2: 68, y2: 8},
			{x1: 68, y1: 8, x2: 69, y2: 9},

			{x1: 72, y1: 7, x2: 79, y2: 8},
			{x1: 71, y1: 8, x2: 72, y2: 9},
			{x1: 79, y1: 8, x2: 80, y2: 9},
			{x1: 74, y1: 11, x2: 77, y2: 12},
			{x1: 74, y1: 15, x2: 80, y2: 16},

			{x1: 83, y1: 7, x2: 90, y2: 8},
			{x1: 82, y1: 8, x2: 83, y2: 9},
			{x1: 90, y1: 8, x2: 91, y2: 9},
			{x1: 85, y1: 11, x2: 88, y2: 12},
			{x1: 85, y1: 15, x2: 91, y2: 16},

			{x1: 94, y1: 7, x2: 102, y2: 8},
			{x1: 93, y1: 8, x2: 94, y2: 9},
			{x1: 96, y1: 11, x2: 101, y2: 12},
			{x1: 101, y1: 12, x2: 102, y2: 13},
			{x1: 93, y1: 15, x2: 99, y2: 16},

			{x1: 105, y1: 7, x2: 112, y2: 8},
			{x1: 104, y1: 8, x2: 105, y2: 9},
			{x1: 112, y1: 8, x2: 113, y2: 9},
			{x1: 107, y1: 11, x2: 110, y2: 12},
			{x1: 107, y1: 15, x2: 113, y2: 16}
		],
		left: [
			{x1: 1, y1: 8, x2: 2, y2: 19},
			{x1: 6, y1: 11, x2: 7, y2: 18},
			{x1: 11, y1: 11, x2: 12, y2: 19},

			{x1: 17, y1: 8, x2: 18, y2: 9},
			{x1: 16, y1: 9, x2: 17, y2: 18},
			{x1: 17, y1: 18, x2: 18, y2: 19},
			{x1: 22, y1: 11, x2: 23, y2: 16},

			{x1: 28, y1: 8, x2: 29, y2: 9},
			{x1: 27, y1: 9, x2: 28, y2: 18},
			{x1: 28, y1: 18, x2: 29, y2: 19},
			{x1: 33, y1: 11, x2: 34, y2: 16},

			{x1: 38, y1: 8, x2: 39, y2: 19},
			{x1: 44, y1: 11, x2: 45, y2: 19},

			{x1: 50, y1: 8, x2: 51, y2: 9},
			{x1: 49, y1: 9, x2: 50, y2: 18},
			{x1: 50, y1: 18, x2: 51, y2: 19},

			{x1: 60, y1: 2, x2: 61, y2: 19},
			{x1: 66, y1: 11, x2: 67, y2: 19},

			{x1: 72, y1: 8, x2: 73, y2: 9},
			{x1: 71, y1: 9, x2: 72, y2: 18},
			{x1: 72, y1: 18, x2: 73, y2: 19},
			{x1: 77, y1: 11, x2: 78, y2: 12},

			{x1: 83, y1: 8, x2: 84, y2: 9},
			{x1: 82, y1: 9, x2: 83, y2: 18},
			{x1: 83, y1: 18, x2: 84, y2: 19},
			{x1: 88, y1: 11, x2: 89, y2: 12},

			{x1: 94, y1: 8, x2: 95, y2: 9},
			{x1: 93, y1: 9, x2: 94, y2: 14},
			{x1: 94, y1: 14, x2: 95, y2: 15},
			{x1: 99, y1: 15, x2: 100, y2: 16},
			{x1: 93, y1: 16, x2: 94, y2: 19},

			{x1: 105, y1: 8, x2: 106, y2: 9},
			{x1: 104, y1: 9, x2: 105, y2: 18},
			{x1: 105, y1: 18, x2: 106, y2: 19},
			{x1: 110, y1: 11, x2: 111, y2: 12}
		],
		bottom: [
			{x1: 2, y1: 18, x2: 5, y2: 19},
			{x1: 5, y1: 10, x2: 7, y2: 11},
			{x1: 7, y1: 17, x2: 10, y2: 18},
			{x1: 10, y1: 10, x2: 12, y2: 11},
			{x1: 12, y1: 18, x2: 15, y2: 19},

			{x1: 20, y1: 10, x2: 23, y2: 11},
			{x1: 17, y1: 17, x2: 18, y2: 18},
			{x1: 18, y1: 18, x2: 25, y2: 19},
			{x1: 25, y1: 17, x2: 26, y2: 18},

			{x1: 31, y1: 10, x2: 34, y2: 11},
			{x1: 28, y1: 17, x2: 29, y2: 18},
			{x1: 29, y1: 18, x2: 36, y2: 19},
			{x1: 36, y1: 17, x2: 37, y2: 18},

			{x1: 39, y1: 18, x2: 42, y2: 19},
			{x1: 42, y1: 10, x2: 45, y2: 11},
			{x1: 45, y1: 18, x2: 48, y2: 19},

			{x1: 50, y1: 17, x2: 51, y2: 18},
			{x1: 51, y1: 18, x2: 59, y2: 19},
			{x1: 53, y1: 10, x2: 59, y2: 11},

			{x1: 61, y1: 18, x2: 64, y2: 19},
			{x1: 64, y1: 10, x2: 67, y2: 11},
			{x1: 67, y1: 18, x2: 70, y2: 19},

			{x1: 75, y1: 10, x2: 78, y2: 11},
			{x1: 75, y1: 14, x2: 81, y2: 15},
			{x1: 72, y1: 17, x2: 73, y2: 18},
			{x1: 73, y1: 18, x2: 81, y2: 19},

			{x1: 86, y1: 10, x2: 89, y2: 11},
			{x1: 86, y1: 14, x2: 92, y2: 15},
			{x1: 83, y1: 17, x2: 84, y2: 18},
			{x1: 84, y1: 18, x2: 92, y2: 19},

			{x1: 97, y1: 10, x2: 103, y2: 11},
			{x1: 94, y1: 13, x2: 95, y2: 14},
			{x1: 95, y1: 14, x2: 100, y2: 15},
			{x1: 102, y1: 17, x2: 103, y2: 18},
			{x1: 94, y1: 18, x2: 102, y2: 19},

			{x1: 108, y1: 10, x2: 111, y2: 11},
			{x1: 108, y1: 14, x2: 114, y2: 15},
			{x1: 105, y1: 17, x2: 106, y2: 18},
			{x1: 106, y1: 18, x2: 114, y2: 19}
		],
		right: [
			{x1: 4, y1: 10, x2: 5, y2: 18},
			{x1: 9, y1: 10, x2: 10, y2: 17},
			{x1: 13, y1: 7, x2: 14, y2: 8},
			{x1: 14, y1: 8, x2: 15, y2: 18},

			{x1: 19, y1: 10, x2: 20, y2: 15},
			{x1: 24, y1: 7, x2: 25, y2: 8},
			{x1: 25, y1: 8, x2: 26, y2: 17},
			{x1: 24, y1: 17, x2: 25, y2: 18},

			{x1: 30, y1: 10, x2: 31, y2: 15},
			{x1: 35, y1: 7, x2: 36, y2: 8},
			{x1: 36, y1: 8, x2: 37, y2: 17},
			{x1: 35, y1: 17, x2: 36, y2: 18},

			{x1: 41, y1: 10, x2: 42, y2: 18},
			{x1: 46, y1: 7, x2: 47, y2: 8},
			{x1: 47, y1: 8, x2: 48, y2: 18},

			{x1: 58, y1: 7, x2: 59, y2: 10},
			{x1: 52, y1: 10, x2: 53, y2: 15},
			{x1: 58, y1: 15, x2: 59, y2: 18},

			{x1: 63, y1: 1, x2: 64, y2: 7},
			{x1: 63, y1: 10, x2: 64, y2: 18},
			{x1: 68, y1: 7, x2: 69, y2: 8},
			{x1: 69, y1: 8, x2: 70, y2: 18},

			{x1: 74, y1: 10, x2: 75, y2: 11},
			{x1: 74, y1: 14, x2: 75, y2: 15},
			{x1: 79, y1: 7, x2: 80, y2: 8},
			{x1: 80, y1: 8, x2: 81, y2: 14},
			{x1: 80, y1: 15, x2: 81, y2: 18},

			{x1: 85, y1: 10, x2: 86, y2: 11},
			{x1: 85, y1: 14, x2: 86, y2: 15},
			{x1: 90, y1: 7, x2: 91, y2: 8},
			{x1: 91, y1: 8, x2: 92, y2: 14},
			{x1: 91, y1: 15, x2: 92, y2: 18},

			{x1: 102, y1: 7, x2: 103, y2: 10},
			{x1: 96, y1: 10, x2: 97, y2: 11},
			{x1: 101, y1: 11, x2: 102, y2: 12},
			{x1: 102, y1: 12, x2: 103, y2: 17},
			{x1: 101, y1: 17, x2: 102, y2: 18},

			{x1: 107, y1: 10, x2: 108, y2: 11},
			{x1: 107, y1: 14, x2: 108, y2: 15},
			{x1: 112, y1: 7, x2: 113, y2: 8},
			{x1: 113, y1: 8, x2: 114, y2: 14},
			{x1: 113, y1: 15, x2: 114, y2: 18}
		],
		face: [
			{x1: 2, y1: 8, x2: 13, y2: 10},
			{x1: 2, y1: 10, x2: 4, y2: 18},
			{x1: 7, y1: 10, x2: 9, y2: 17},
			{x1: 12, y1: 9, x2: 14, y2: 18},

			{x1: 18, y1: 8, x2: 24, y2: 10},
			{x1: 18, y1: 16, x2: 24, y2: 18},
			{x1: 17, y1: 9, x2: 19, y2: 17},
			{x1: 23, y1: 9, x2: 25, y2: 17},

			{x1: 29, y1: 8, x2: 35, y2: 10},
			{x1: 29, y1: 16, x2: 35, y2: 18},
			{x1: 28, y1: 9, x2: 30, y2: 17},
			{x1: 34, y1: 9, x2: 36, y2: 17},

			{x1: 39, y1: 8, x2: 46, y2: 10},
			{x1: 39, y1: 10, x2: 41, y2: 18},
			{x1: 45, y1: 9, x2: 47, y2: 18},

			{x1: 51, y1: 8, x2: 58, y2: 10},
			{x1: 50, y1: 9, x2: 52, y2: 17},
			{x1: 51, y1: 16, x2: 58, y2: 18},

			{x1: 61, y1: 2, x2: 63, y2: 18},
			{x1: 63, y1: 8, x2: 68, y2: 10},
			{x1: 67, y1: 9, x2: 69, y2: 18},

			{x1: 73, y1: 8, x2: 79, y2: 10},
			{x1: 74, y1: 12, x2: 78, y2: 14},
			{x1: 73, y1: 16, x2: 80, y2: 18},
			{x1: 72, y1: 9, x2: 74, y2: 17},
			{x1: 78, y1: 9, x2: 80, y2: 14},

			{x1: 84, y1: 8, x2: 90, y2: 10},
			{x1: 85, y1: 12, x2: 89, y2: 14},
			{x1: 84, y1: 16, x2: 91, y2: 18},
			{x1: 83, y1: 9, x2: 85, y2: 17},
			{x1: 89, y1: 9, x2: 91, y2: 14},

			{x1: 95, y1: 8, x2: 102, y2: 10},
			{x1: 94, y1: 9, x2: 96, y2: 13},
			{x1: 95, y1: 12, x2: 101, y2: 14},
			{x1: 100, y1: 13, x2: 102, y2: 17},
			{x1: 94, y1: 16, x2: 101, y2: 18},

			{x1: 106, y1: 8, x2: 112, y2: 10},
			{x1: 107, y1: 12, x2: 111, y2: 14},
			{x1: 106, y1: 16, x2: 113, y2: 18},
			{x1: 105, y1: 9, x2: 107, y2: 17},
			{x1: 111, y1: 9, x2: 113, y2: 14}
		]
	};
	bumpContainer = document.createElement('div');
	bumpContainer.className = 'part_container';
	bumpContainer.style.display = 'none';
	canvas.appendChild(bumpContainer);
	for (var blockType in blocks) {
		for (var i = 0; i < blocks[blockType].length; i++) {
			var block = blocks[blockType][i];
			block.element = document.createElement('div');
			block.element.className = 'bump_block';
			block.element.style.left = block.x1 * 6 + 48;
			block.element.style.top = block.y1 * 6 + 180;
			block.element.style.width = (block.x2 - block.x1) * 6;
			block.element.style.height = (block.y2 - block.y1) * 6;
			bumpContainer.appendChild(block.element);
		}
	}

	/* copper */
	copperContainer = document.createElement('div');
	copperContainer.className = 'copper_container';
	copperContainer.style.display = 'none';
	canvas.appendChild(copperContainer);
	for (var i = 0; i < 720; i++) {
		copperSine[i] = 150 * Math.sin(i * Math.PI / 180);
	}
	for (var i = 0; i < barCount; i++) {
		var img = document.createElement('img');
		img.src = 'copper/bar_' + i + '.png';
		img.className = 'copper_bar';
		img.style.top = i * 2 + 'px';
		copperBar[i] = img;
		copperContainer.appendChild(img);
	}
	for (var i = 0; i < 16; i++) {
		scrollyLetter[i] = {
			element: document.createElement('div'),
			currentLetter: ' '
		};
		scrollyLetter[i].element.className = 'scrolly_letter';
		scrollyLetter[i].element.appendChild(document.createTextNode(' '));
		copperContainer.appendChild(scrollyLetter[i].element);
	}
	
	/* wormhole */
	wormholeContainer = document.createElement('div');
	wormholeContainer.className = 'part_container';
	wormholeContainer.style.display = 'none';
	canvas.appendChild(wormholeContainer);
	var tunnelCaption1 = document.createElement('div');
	tunnelCaption1.className = 'tunnel_caption_1';
	tunnelCaption1.appendChild(document.createTextNode("...let's dig a "));
	var tunnelBold1 = document.createElement('strong');
	tunnelBold1.appendChild(document.createTextNode("tunnel"));
	tunnelCaption1.appendChild(tunnelBold1);
	wormholeContainer.appendChild(tunnelCaption1);
	
	var tunnelCaption2 = document.createElement('div');
	tunnelCaption2.className = 'tunnel_caption_2';
	tunnelCaption2.appendChild(document.createTextNode('to the '));
	var tunnelBold2 = document.createElement('strong');
	tunnelBold2.appendChild(document.createTextNode('centre'));
	tunnelCaption2.appendChild(tunnelBold2);
	tunnelCaption2.appendChild(document.createTextNode(' of the '));
	var tunnelBold3 = document.createElement('strong');
	tunnelBold3.appendChild(document.createTextNode('moon'));
	tunnelCaption2.appendChild(tunnelBold3);
	wormholeContainer.appendChild(tunnelCaption2);
	
	for (var i = 0; i < 16; i++) {
		ringImages[i] = new Image;
		ringImages[i].src = "wormhole/ring_" + i + ".png";
	}
	for (var i = 0; i < 8; i++) {
		ringSprites[i] = document.createElement('img');
		ringSprites[i].className = 'sprite';
		ringSprites[i].src = ringImages[0].src;
		wormholeContainer.appendChild(ringSprites[i]);
	}

	/* vectorballs */
	ball = [
		{coords: [
			[0.259808, 0.410450, 1.900000],
			[-2  , -2  , -2  ],
			[ 0.000, -2, +1.500],
			[0.018884, 1.738014, 0.075722 ]
		]},
		{coords: [
			[-0.259808, 0.410450, 1.900000],
			[-2/3, -2  , -2  ],
			[+0.882, -2, +1.214],
			[0.255884, 1.471014, 0.075364 ]
		]},
		{coords: [
			[-0.20, 0.410450, 2.203528],
			[+2/3, -2  , -2  ],
			[+1.427, -2, +0.464],
			[-0.149116, 1.470788, 0.243364 ]
		]},
		{coords: [
			[0.20, 0.410450, 2.203528],
			[+2  , -2  , -2  ],
			[+1.427, -2, -0.464],
			[0.018884, 1.471331, -0.161636 ]
		]},
		{coords: [
			[0.021000, -1.179100, -0.600000],
			[-2  , -2  , -2/3],
			[+0.882, -2, -1.214],
			[1.416738, -1.218998, 0.059079 ]
		]},
		{coords: [
			[0.021000, -0.908642, -1.909915],
			[-2/3, -2  , -2/3],
			[ 0.000, -2, -1.500],
			[1.255738, -1.131975, 0.787196 ]
		]},
		{coords: [
			[-0.447000, -0.908642, -1.526250],
			[+2/3, -2  , -2/3],
			[-0.882, -2, -1.214],
			[-0.694262, -1.217374, -1.151920 ]
		]},
		{coords: [
			[-0.640852, -0.908642, -0.600000],
			[+2  , -2  , -2/3],
			[-1.427, -2, -0.464],
			[-1.024262, -1.162603, -0.981847 ]
		]},
		{coords: [
			[-0.447000, -0.908642, 0.326250],
			[-2  , -2  , +2/3],
			[-1.427, -2, +0.464],
			[1.700000, -0.113500, 0.327255 ]
		]},
		{coords: [
			[0.021000, -0.908642, 0.709915],
			[-2/3, -2  , +2/3],
			[-0.882, -2, +1.214],
			[1.700000, -0.938499, 0.326149 ]
		]},
		{coords: [
			[0.489000, -0.908642, 0.326250],
			[+2/3, -2  , +2/3],
			[ 0.000, -5/3, +1.000],
			[2.270000, 0.072500, 0.327505 ]
		]},
		{coords: [
			[0.682852, -0.908642, -0.600000],
			[+2  , -2  , +2/3],
			[+0.782, -5/3, +0.623],
			[2.410000, 0.235755, 0.137723 ]
		]},
		{coords: [
			[0.489000, -0.908642, -1.526250],
			[-2  , -2  , +2  ],
			[+0.975, -5/3, -0.223],
			[2.630000, 0.376858, 0.060913 ]
		]},
		{coords: [
			[0.021000, -0.255700, -2.452500],
			[-2/3, -2  , +2  ],
			[+0.434, -5/3, -0.901],
			[3.096000, 0.861633, 0.228563 ]
		]},
		{coords: [
			[-0.640852, -0.255700, -1.909915],
			[+2/3, -2  , +2  ],
			[-0.434, -5/3, -0.901],
			[-1.486195, 0.600000, 0.214712 ]
		]},
		{coords: [
			[-0.915000, -0.255700, -0.600000],
			[+2  , -2  , +2  ],
			[-0.975, -5/3, -0.223],
			[-2.298195, 0.572000, 0.214675 ]
		]},
		{coords: [
			[-0.640852, -0.255700, 0.709915],
			[-2  , +2  , -2  ],
			[-0.782, -5/3, +0.623],
			[-2.586195, 0.375000, 0.214410 ]
		]},
		{coords: [
			[0.021000, -0.255700, 1.252500],
			[-2/3, +2  , -2  ],
			[ 0.000, -4/3, +0.500],
			[-2.567195, -0.216732, 0.013617 ]
		]},
		{coords: [
			[0.682852, -0.255700, 0.709915],
			[+2/3, +2  , -2  ],
			[+0.433, -4/3, -0.250],
			[-1.812195, -0.746731, 0.012906 ]
		]},
		{coords: [
			[0.957000, -0.255700, -0.600000],
			[+2  , +2  , -2  ],
			[-0.433, -4/3, -0.250],
			[1.500000, 1.124999, 0.065416 ]
		]},
		{coords: [
			[0.682852, -0.255700, -1.909915],
			[-2  , +2  , -2/3],
			[0, -1, 0],
			[1.567000, 0.862414, 0.501065 ]
		]},
		{coords: [
			[0.021000, 0.397242, -1.909915],
			[-2/3, +2  , -2/3],
			[0, -0.5, 0],
			[0.825000, 0.861115, 1.470064 ]
		]},
		{coords: [
			[-0.447000, 0.397242, -1.526250],
			[+2/3, +2  , -2/3],
			[0, 0, 0],
			[0.000000, 1.122987, 1.565415 ]
		]},
		{coords: [
			[-0.640852, 0.397242, -0.600000],
			[+2  , +2  , -2/3],
			[ 0.000, +0.5, +0.375],
			[-0.436000, 0.860898, 1.632064 ]
		]},
		{coords: [
			[-0.447000, 0.397242, 0.326250],
			[-2  , +2  , +2/3],
			[+0.325, +0.5, -0.188],
			[-1.405000, 0.861893, 0.890064 ]
		]},
		{coords: [
			[0.021000, 0.397242, 0.709915],
			[-2/3, +2  , +2/3],
			[-0.325, +0.5, -0.188],
			[-1.500000, 1.124999, 0.065416 ]
		]},
		{coords: [
			[0.489000, 0.397242, 0.326250],
			[+2/3, +2  , +2/3],
			[ 0.000, +1, +0.750],
			[-1.567000, 0.863584, -0.370935 ]
		]},
		{coords: [
			[0.682852, 0.397242, -0.600000],
			[+2  , +2  , +2/3],
			[+0.586, +1, +0.468],
			[-0.825000, 0.864884, -1.339934 ]
		]},
		{coords: [
			[0.489000, 0.397242, -1.526250],
			[-2  , +2  , +2  ],
			[+0.731, +1, -0.167],
			[0.000000, 1.127011, -1.434582 ]
		]},
		{coords: [
			[0.021000, 0.667700, -0.600000],
			[-2/3, +2  , +2  ],
			[+0.325, +1, -0.676],
			[0.436000, 0.865101, -1.501934 ]
		]},
		{coords: [
			[-0.000000, 0.000000, 1.150000],
			[+2/3, +2  , +2  ],
			[-0.325, +1, -0.676],
			[1.065000, 1.126427, -0.999583 ]
		]},
		{coords: [
			[0.530330, 0.234315, 1.150000],
			[+2  , +2  , +2  ],
			[-0.731, +1, -0.167],
			[1.405000, 0.864106, -0.759934 ]
		]},
		{coords: [
			[0.375000, 0.234315, 0.825000],
			[-2  , -2/3, -2  ],
			[-0.586, +1, +0.468],
			[1.741000, 0.602999, 0.064716 ]
		]},
		{coords: [
			[-0.000000, 0.234315, 0.690381],
			[-2/3, -2/3, -2  ],
			[ 0.000, +1.5, +1.125],
			[1.236000, 0.601342, 1.300715 ]
		]},
		{coords: [
			[-0.375000, 0.234315, 0.825000],
			[+2/3, -2/3, -2  ],
			[+0.661, +1.5, +0.910],
			[0.000000, 0.600664, 1.805715 ]
		]},
		{coords: [
			[-0.530330, 0.234315, 1.150000],
			[+2  , -2/3, -2  ],
			[+1.070, +1.5, +0.348],
			[-1.236000, 0.601342, 1.300715 ]
		]},
		{coords: [
			[-0.375000, 0.234315, 1.475000],
			[-2  , +2/3, -2  ],
			[+1.070, +1.5, -0.348],
			[-1.741000, 0.602999, 0.064716 ]
		]},
		{coords: [
			[-0.000000, 0.234315, 1.609619],
			[-2/3, +2/3, -2  ],
			[+0.661, +1.5, -0.910],
			[-1.236000, 0.604657, -1.171283 ]
		]},
		{coords: [
			[0.375000, 0.234315, 1.475000],
			[+2/3, +2/3, -2  ],
			[ 0.000, +1.5, -1.125],
			[0.000000, 0.605334, -1.676282 ]
		]},
		{coords: [
			[0.750000, 0.800000, 1.150000],
			[+2  , +2/3, -2  ],
			[-0.661, +1.5, -0.910],
			[1.236000, 0.604657, -1.171283 ]
		]},
		{coords: [
			[0.530330, 0.800000, 0.690381],
			[-2  , -2/3, +2  ],
			[-1.070, +1.5, -0.348],
			[1.980000, -0.144000, 0.063714 ]
		]},
		{coords: [
			[-0.000000, 0.800000, 0.500000],
			[-2/3, -2/3, +2  ],
			[-1.070, +1.5, +0.348],
			[1.406000, -0.145886, 1.469713 ]
		]},
		{coords: [
			[-0.530330, 0.800000, 0.690381],
			[+2/3, -2/3, +2  ],
			[-0.661, +1.5, +0.910],
			[0.000000, -0.146655, 2.043713 ]
		]},
		{coords: [
			[-0.750000, 0.800000, 1.150000],
			[+2  , -2/3, +2  ],
			[ 0.000, +2, +1.500],
			[-1.406000, -0.145886, 1.469713 ]
		]},
		{coords: [
			[-0.530330, 0.800000, 1.609619],
			[-2  , +2/3, +2  ],
			[+0.697, +2, +1.328],
			[-1.980000, -0.144000, 0.063714 ]
		]},
		{coords: [
			[-0.000000, 0.800000, 1.800000],
			[-2/3, +2/3, +2  ],
			[+1.234, +2, +0.852],
			[-1.406000, -0.142114, -1.342284 ]
		]},
		{coords: [
			[0.530330, 0.800000, 1.609619],
			[+2/3, +2/3, +2  ],
			[+1.489, +2, +0.181],
			[0.000000, -0.141344, -1.916284 ]
		]},
		{coords: [
			[0.530330, 1.365685, 1.150000],
			[+2  , +2/3, +2  ],
			[+1.403, +2, -0.532],
			[1.406000, -0.142114, -1.342284 ]
		]},
		{coords: [
			[0.375000, 1.365685, 0.825000],
			[-2  , -2/3, -2/3],
			[+0.995, +2, -1.123],
			[1.870000, -0.752999, 0.062898 ]
		]},
		{coords: [
			[-0.000000, 1.365685, 0.690381],
			[-2  , +2/3, -2/3],
			[+0.359, +2, -1.456],
			[1.328000, -0.754780, 1.390896 ]
		]},
		{coords: [
			[-0.375000, 1.365685, 0.825000],
			[-2  , -2/3, +2/3],
			[-0.359, +2, -1.456],
			[0.000000, -0.755507, 1.932896 ]
		]},
		{coords: [
			[-0.530330, 1.365685, 1.150000],
			[-2  , +2/3, +2/3],
			[-0.995, +2, -1.123],
			[-1.328000, -0.754780, 1.390896 ]
		]},
		{coords: [
			[-0.375000, 1.365685, 1.475000],
			[+2  , -2/3, -2/3],
			[-1.403, +2, -0.532],
			[-1.870000, -0.752999, 0.062898 ]
		]},
		{coords: [
			[-0.000000, 1.365685, 1.609619],
			[+2  , +2/3, -2/3],
			[-1.489, +2, +0.181],
			[-1.328000, -0.751218, -1.265101 ]
		]},
		{coords: [
			[0.375000, 1.365685, 1.475000],
			[+2  , -2/3, +2/3],
			[-1.234, +2, +0.852],
			[0.000000, -0.750491, -1.807101 ]
		]},
		{coords: [
			[-0.000000, 1.600000, 1.150000],
			[+2  , +2/3, +2/3],
			[-0.697, +2, +1.328],
			[1.328000, -0.751218, -1.265101 ]
		]}
	];
	ballImg = new Image();
	ballImg.src = 'ball.png';
	vectorBallsContainer = document.createElement('div');
	vectorBallsContainer.className = 'part_container';
	vectorBallsContainer.style.display = 'none';
	canvas.appendChild(vectorBallsContainer);
	for (var i=0; i < ballCount; i++) {
		ball[i].element = document.createElement('img');
		ball[i].element.src = ballImg.src;
		ball[i].element.style.position = 'absolute';
		ball[i].element.style.left = i * 20;
		ball[i].element.style.top = i * 20;
		ball[i].element.style.width = ball[i].element.style.height = i + 5;
		vectorBallsContainer.appendChild(ball[i].element);
	}
	duckFuCaption = document.createElement('div');
	duckFuCaption.appendChild(document.createTextNode('i know duck fu'));
	duckFuCaption.className = 'duck_fu_caption';
	vectorBallsContainer.appendChild(duckFuCaption);

	/* mandelbrot */
	for (var i=0; i <= 20; i++) {
		mandelFrames[i] = new Image;
		mandelFrames[i].src = "mandelbrot/frame" + i + ".png";
	}
	mandelFrames[21] = mandelFrames[20];
	tile0 = document.createElement('img');
	tile0.className = 'sprite';
	tile0.zIndex = 10;
	canvas.appendChild(tile0);
	tile1 = document.createElement('img');
	tile1.className = 'sprite';
	tile1.zIndex = 20;
	canvas.appendChild(tile1);

	/* wolf */
	maze = [
		[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
		[1,0,1,0,0,0,0,0,0,0,2,0,0,0,0,1],
		[1,0,1,0,1,1,1,1,0,0,2,0,0,0,0,1],
		[1,0,1,0,0,0,0,1,0,0,2,0,0,0,0,1],
		[1,0,1,1,1,1,0,1,1,0,2,0,0,0,0,1],
		[1,0,0,0,0,0,0,1,0,0,2,0,0,0,0,1],
		[1,0,1,0,0,1,1,1,0,0,2,0,0,0,0,1],
		[1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,1,0,0,0,0,0,0,2,0,0,0,0,1],
		[1,1,1,1,0,0,2,2,2,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,2,0,0,0,0,2,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
	];
	wolfPath = [
		[1.47,1.5],[1.48,1.5],[1.49,1.5],[4,1],[6,1],[6,4],[6,6],[5,7],
		[3,7],[3,5.5],[4,3],[1,3],[1.5,6],[1,8],[3,10],
		[6,10],[8.5,9.5],[9,7.5],[7,7],[7.5,9.5],[7,12],[9.5,12],
		[11,11.5],[10,10],[11.5,10.5],[11.5,8.5],[11.5,7],[10,7.5],[10.5,6]
	];
	wolfContainer = document.createElement('div');
	wolfContainer.className = 'wolf_container';
	wolfContainer.style.display = 'none';
	canvas.appendChild(wolfContainer);
	var floor = document.createElement('div');
	floor.className = 'floor';
	wolfContainer.appendChild(floor);
	for (var i=0; i < 80; i++) {
		strips[i] = document.createElement('img');
		strips[i].style.position = 'absolute';
		strips[i].width = 8;
		strips[i].style.left = i * 8 + 'px';
		strips[i].style.top = '0px';
		strips[i].height = 100;
		wolfContainer.appendChild(strips[i]);
	}
	wolfImages[1] = [];
	wolfImages[2] = [];
	for (var i=0; i < 96; i++) {
		wolfImages[1][i] = new Image;
		wolfImages[1][i].src = "wolf/brick_" + i + ".png";
		wolfImages[2][i] = new Image;
		wolfImages[2][i].src = "wolf/metal_" + i + ".png";
	}

	/* gouraud */
	pseudocode = "          \n              \n               \n            \n            \n            \n          \n        \nvar vertex = {\n  tetra: [\n    {coords: [ 0, 20, 0]},\n    {coords: [ 0, -20/3, +18.856]},\n    {coords: [+16.330, -20/3, -9.428]},\n    {coords: [-16.330, -20/3, -9.428], greet: 'farbrausch'}\n  ]\n};\n\ndispTetr = [cos_b * 8, cos_c * 8, cos_a * 8];\nvar m_rot = mat3Mult(mat3Mult(m_ar, m_br), m_cr);\n\nfor (var i=0; i < 36; i++) {\n  vertex.torus[i].wc = vec3Mult(vertex.torus[i].coords, m_rot);\n\n/* bet you can't do this in flash */\n\n  vertex.tetra[i].light = Math.max(0, -vertex.tetra[i].wc[2] / 5 + 4);\n  subliminal = vote++;\n}\n\nif ((cx2-cx1) * (cy3-cy1) - (cx3-cx1) * (cy2-cy1) <= 0) {\n  greets += 'AND'; return;\n}\nfor (var y=0; y < 48; y++) {\n  switch (yBuffer[y].length) {\n    case 1:\n      var x = yBuffer[y][0][0];\n      zBuffer[y][x] = Math.max(zBuffer[y][x], Math.floor(yBuffer[y][0][1]));\n      bmp[y] = bmp[y].slice(0, x * 2) + shades[zBuffer[y][x]] + bmp[y].slice(x * 2 + 2);\n      greet(purple.motion);\n      break;\n    case 2:\n      if (yBuffer[y][0][0] < yBuffer[y][1][0]) {\n        var a = yBuffer[y][0][0]; var b = yBuffer[y][1][0];\n        var sa = yBuffer[y][0][1]; var sb = yBuffer[y][1][1];\n        greets.concat(['serzh', 'pwp', 'dekadence'])\n        oldskool.rulez()\n      } else {\n        var a = yBuffer[y][1][0]; var b = yBuffer[y][0][0];\n        var sa = yBuffer[y][1][1]; var sb = yBuffer[y][0][1];\n        greets.push('kewlers', 'replay', 'c-jeff','komplex')\n      }\n      var scanline = '';\n      var dx = b - a;\n      var greet = Math.pow(asm[org],100);\n      if (dx > 0) {\n        var sgrad = (sb - sa) / dx;\n      }\n    }\n  }\n}";
	vertex = {
		torus: [
			{coords: [ 1.5, 0, 0]},
			{coords: [ 1.25, 0.433, 0]},
			{coords: [ 0.75, 0.433, 0]},
			{coords: [ 0.5, 0, 0]},
			{coords: [ 0.75,-0.433, 0]},
			{coords: [ 1.25,-0.433, 0]},

			{coords: [ 0.75, 0, 1.299]},
			{coords: [ 0.625, 0.433, 1.083]},
			{coords: [ 0.375, 0.433, 0.650]},
			{coords: [ 0.25, 0, 0.433]},
			{coords: [ 0.375,-0.433, 0.650]},
			{coords: [ 0.625,-0.433, 1.083]},

			{coords: [-0.75, 0, 1.299]},
			{coords: [-0.625, 0.433, 1.083]},
			{coords: [-0.375, 0.433, 0.650]},
			{coords: [-0.25, 0, 0.433]},
			{coords: [-0.375,-0.433, 0.650]},
			{coords: [-0.625,-0.433, 1.083]},

			{coords: [-1.5, 0, 0]},
			{coords: [-1.25, 0.433, 0]},
			{coords: [-0.75, 0.433, 0]},
			{coords: [-0.5, 0, 0]},
			{coords: [-0.75,-0.433, 0]},
			{coords: [-1.25,-0.433, 0]},

			{coords: [-0.75, 0,-1.299]},
			{coords: [-0.625, 0.433,-1.083]},
			{coords: [-0.375, 0.433,-0.650]},
			{coords: [-0.25, 0,-0.433]},
			{coords: [-0.375,-0.433,-0.650]},
			{coords: [-0.625,-0.433,-1.083]},

			{coords: [ 0.75, 0,-1.299]},
			{coords: [ 0.625, 0.433,-1.083]},
			{coords: [ 0.375, 0.433,-0.650]},
			{coords: [ 0.25, 0,-0.433]},
			{coords: [ 0.375,-0.433,-0.650]},
			{coords: [ 0.625,-0.433,-1.083]},
		],
		tetra: [
			{coords: [ 0, 20, 0]},
			{coords: [ 0, -20/3, +18.856]},
			{coords: [+16.330, -20/3, -9.428]},
			{coords: [-16.330, -20/3, -9.428]}
		]
	}
	gouraudContainer = document.createElement('div');
	gouraudContainer.className = 'part_container';
	gouraudContainer.style.display = 'none';
	asciiCanvas = document.createElement('textarea');
	asciiCanvas.className = 'ascii_canvas';
	gouraudContainer.appendChild(asciiCanvas);
	var scienceBit = document.createElement('div');
	scienceBit.className = 'science_bit';
	var sbh1 = document.createElement('h1');
	sbh1.appendChild(document.createTextNode('here comes the'));
	sbh1.appendChild(document.createElement('br'));
	sbh1.appendChild(document.createTextNode('science bit'));
	scienceBit.appendChild(sbh1);
	var sbh2 = document.createElement('h2');
	sbh2.appendChild(document.createTextNode('(concentrate)'));
	scienceBit.appendChild(sbh2);
	gouraudContainer.appendChild(scienceBit);
	pseudocodeCanvas = document.createElement('textarea');
	pseudocodeCanvas.className = 'pseudocode_canvas';
	gouraudContainer.appendChild(pseudocodeCanvas);
	
	canvas.appendChild(gouraudContainer);
	
	/* rescale torus */
	for (var i=0; i < 36; i++) {
		vertex.torus[i].coords[0] *= 12;
		vertex.torus[i].coords[1] *= 12;
		vertex.torus[i].coords[2] *= 12;
	}

	/* landscape */
	heightmap = [
[8,6,6,5,7,6,7,9,10,11,13,14,12,10,10,6,5,5,5,5,5,5,5,6,6,5,8,10,11,10,10,9,9,7,6,7,5,5,5,5,5,6,5,7,9,13,16,19,20,20,19,20,20,19,20,20,18,16,15,12,8,7,6,7],
[6,6,5,8,10,9,9,11,13,13,14,13,12,12,12,10,9,7,6,6,5,6,6,6,7,7,8,9,12,10,9,8,8,7,7,6,6,5,5,5,6,6,7,8,7,11,15,17,19,18,17,18,18,18,19,18,17,16,15,12,10,8,6,7],
[6,8,8,10,11,11,11,12,15,15,13,13,12,13,12,11,11,9,9,9,7,8,7,7,6,8,8,8,11,11,9,8,9,7,7,5,5,6,6,6,5,5,7,9,8,10,13,15,17,16,17,16,16,17,17,17,17,16,14,11,9,7,7,7],
[5,7,7,9,11,10,11,12,14,14,13,13,13,13,12,13,12,12,12,10,9,9,9,9,9,8,6,8,10,9,7,7,8,7,6,6,5,6,6,6,6,8,9,10,9,11,11,14,16,16,16,16,15,16,15,16,17,16,13,12,10,9,8,7],
[5,9,9,9,10,9,10,13,15,13,12,13,14,14,14,15,14,14,13,10,10,11,12,10,9,8,6,8,8,7,7,7,7,6,7,6,7,6,8,7,8,10,11,12,12,12,12,12,14,15,15,16,16,15,16,15,17,17,15,13,9,9,7,7],
[6,8,9,9,11,11,11,13,15,14,14,14,14,14,14,14,13,13,12,11,11,11,12,10,10,8,6,6,6,7,6,6,7,7,7,7,7,8,9,8,8,9,10,11,12,11,10,11,12,14,16,17,18,16,15,15,16,14,12,11,8,8,7,7],
[6,8,8,8,10,12,12,13,14,14,14,16,15,14,14,14,13,14,12,12,10,10,10,9,10,9,7,6,5,6,6,5,6,8,7,8,9,10,8,7,6,7,10,10,11,10,11,11,12,12,14,17,18,16,16,15,15,12,11,11,9,7,7,6],
[7,8,9,10,12,13,13,13,12,13,14,15,16,15,14,15,15,14,12,12,11,10,9,9,9,8,6,6,5,5,5,5,5,7,8,8,8,9,10,8,8,9,10,12,14,11,10,10,11,12,13,15,15,15,15,14,13,10,8,8,7,7,7,7],
[7,8,8,12,13,13,14,13,11,14,16,15,15,15,15,16,15,15,14,13,12,11,8,8,8,8,7,6,5,5,5,6,6,5,7,8,7,9,10,9,9,11,12,14,15,11,10,9,10,10,12,14,15,15,15,13,11,7,6,5,5,6,7,7],
[7,8,9,10,11,12,13,13,12,14,15,15,15,15,14,15,15,14,13,12,11,10,8,8,8,8,6,6,5,5,5,6,5,6,6,8,9,9,10,10,11,12,13,13,13,12,10,9,8,10,13,13,14,14,13,13,13,9,7,6,5,5,7,7],
[5,8,7,9,10,10,11,12,13,13,13,14,14,14,14,15,15,13,13,10,10,11,9,9,10,9,7,5,5,6,6,7,5,6,7,7,9,9,10,10,12,12,13,13,14,12,11,10,8,9,12,12,14,13,13,15,13,10,9,8,5,5,6,6],
[5,6,7,9,9,9,10,10,11,11,12,13,14,13,12,13,14,13,13,11,10,10,8,9,9,8,7,6,6,6,6,7,6,6,7,7,8,9,9,11,14,12,12,13,13,13,14,12,11,12,13,13,13,13,13,14,15,12,10,8,7,7,8,6],
[5,5,7,9,9,8,9,9,10,9,10,12,13,12,11,10,12,11,12,11,11,10,8,7,9,9,8,7,6,7,9,7,6,5,7,7,9,10,9,10,12,12,13,13,13,14,13,13,11,14,13,12,12,13,12,15,14,12,12,8,7,8,8,7],
[5,6,9,9,10,10,11,10,9,10,11,12,12,11,11,10,11,11,11,10,9,8,7,8,9,8,6,6,6,6,7,6,5,6,7,8,9,10,11,11,12,12,11,12,13,13,13,12,10,11,11,11,11,11,11,12,14,12,11,9,7,7,8,6],
[5,7,8,9,11,10,10,11,9,10,11,13,12,11,11,9,8,10,10,10,9,7,7,7,8,7,6,7,5,5,6,5,6,8,7,8,11,10,11,10,11,13,12,12,12,12,11,12,11,10,11,9,9,10,10,10,12,11,9,7,5,5,5,6],
[6,8,11,10,10,10,11,11,10,11,12,13,13,13,13,10,8,10,12,11,9,8,7,6,7,6,6,6,5,5,5,5,5,6,8,9,11,11,12,12,13,13,13,12,12,11,9,10,10,10,10,9,7,9,10,9,9,10,9,8,6,5,6,6],
[8,9,11,11,10,11,13,12,12,11,12,14,15,15,13,11,9,11,12,11,9,8,5,6,5,5,5,6,5,5,5,5,5,5,7,9,11,11,13,14,15,14,12,13,12,10,8,8,9,10,10,8,8,8,7,7,9,9,9,9,5,5,5,7],
[9,10,10,11,10,11,12,11,10,11,12,13,14,13,10,9,7,9,9,9,7,7,5,6,6,6,7,6,5,5,5,6,6,7,8,9,10,11,13,14,15,14,12,12,11,10,9,10,11,10,9,9,8,8,9,9,9,9,8,7,6,6,7,8],
[10,10,11,11,10,10,10,10,10,11,12,13,15,13,10,9,7,7,8,7,7,7,8,7,8,7,7,6,6,7,7,8,8,9,8,8,8,10,12,12,13,12,12,12,11,10,10,11,11,11,9,9,10,9,9,10,10,8,9,7,6,7,8,10],
[8,10,11,10,10,9,9,9,10,11,11,12,13,11,9,7,6,6,6,7,7,8,9,10,11,9,8,8,8,7,7,7,6,8,10,9,9,10,12,12,11,12,12,12,12,10,10,11,11,9,6,8,9,9,9,10,11,9,8,8,8,8,9,9],
[9,11,11,10,9,8,7,7,10,10,12,12,10,9,6,6,6,6,5,7,9,10,12,12,11,10,9,10,9,8,8,7,6,7,10,9,9,10,12,11,9,12,12,11,10,10,11,11,9,7,6,6,8,9,10,8,8,7,8,8,8,9,11,10],
[9,10,11,10,9,8,7,8,10,10,11,11,10,8,7,7,6,6,7,9,11,12,13,13,13,10,9,9,8,8,9,7,7,7,8,8,9,10,10,10,8,10,10,10,8,10,12,11,10,9,9,9,10,10,9,9,8,8,8,7,6,8,9,10],
[9,9,9,8,7,7,8,8,9,9,9,9,8,8,7,7,6,7,8,9,12,13,12,13,13,10,10,9,8,7,8,6,5,6,7,8,7,9,9,9,7,9,10,10,9,10,12,10,11,10,10,9,9,11,10,11,10,9,8,7,6,8,9,9],
[8,8,9,8,6,7,10,10,11,10,9,8,8,8,8,7,7,8,9,10,10,11,10,11,10,9,8,9,10,9,9,7,6,6,7,8,9,10,11,10,9,10,9,10,10,12,14,13,13,12,11,10,8,10,10,10,10,8,7,7,7,8,10,8],
[7,8,8,8,6,7,9,9,11,11,9,8,8,7,8,8,7,8,9,9,10,11,10,11,10,8,9,10,12,10,10,8,6,5,6,7,9,10,10,10,10,11,11,11,12,14,16,16,16,14,13,11,8,9,10,8,9,7,6,8,9,9,9,7],
[10,9,8,8,8,8,9,11,12,12,11,10,10,10,11,10,9,10,12,11,12,11,11,10,9,10,11,12,13,12,11,9,7,7,8,8,9,9,11,10,10,11,11,11,12,12,13,14,14,13,12,10,9,10,11,9,8,7,7,8,9,10,9,9],
[11,11,11,9,9,9,12,14,14,15,13,12,11,10,11,13,13,12,13,12,13,11,11,10,9,12,11,14,14,13,10,10,9,8,8,8,8,8,9,8,9,11,10,9,9,10,13,13,15,13,12,11,10,12,10,9,9,8,9,10,12,12,10,12],
[12,13,13,12,11,13,14,15,15,16,15,14,13,13,13,13,13,14,15,14,13,12,12,11,11,12,13,13,12,11,9,9,10,8,8,9,10,9,10,10,11,11,11,10,9,11,14,13,13,12,12,11,9,11,13,11,10,10,10,11,11,10,8,11],
[12,15,15,15,13,16,17,18,19,19,19,16,15,15,15,15,14,17,16,15,14,13,11,12,13,13,14,13,11,10,9,8,8,7,7,9,10,10,8,10,11,12,13,11,11,12,13,11,11,11,11,11,10,12,13,12,11,10,11,12,10,9,9,11],
[12,14,16,14,12,15,17,18,19,18,17,16,15,15,15,15,14,16,17,17,16,15,13,15,15,15,15,13,12,11,11,9,9,8,7,9,9,9,9,8,7,10,12,12,11,12,12,11,11,10,10,11,11,11,13,11,10,9,9,10,9,9,10,11],
[14,14,15,14,13,16,16,17,18,18,17,15,15,15,16,17,15,15,17,19,18,18,17,19,19,18,15,13,11,10,10,9,8,8,9,9,10,10,9,6,7,8,10,12,12,12,11,11,9,8,9,11,11,10,10,9,9,8,9,9,8,9,11,13],
[14,15,15,15,14,16,17,17,19,18,18,16,16,16,17,18,17,17,18,19,20,19,17,19,20,18,15,12,10,11,12,11,9,11,12,11,11,10,10,7,5,7,10,10,12,11,10,8,6,7,8,9,11,10,9,8,7,7,6,8,8,9,9,12],
[15,15,16,17,15,17,17,18,19,18,17,16,18,17,19,20,20,19,18,20,19,19,19,20,20,17,15,12,11,11,13,12,10,12,12,13,12,10,9,7,5,5,7,7,10,10,9,6,5,5,5,7,9,9,7,6,5,6,6,7,10,9,11,12],
[14,15,15,14,13,14,15,17,18,17,17,17,17,17,17,19,19,19,19,20,20,19,18,19,20,17,14,12,12,12,12,11,10,11,13,12,13,11,9,7,5,6,8,8,9,8,7,7,6,6,6,8,11,9,7,7,7,7,6,7,8,10,12,13],
[14,13,15,13,12,13,14,16,17,16,17,16,16,16,18,20,19,19,19,20,20,20,19,18,19,18,15,11,11,11,12,11,11,11,13,12,13,11,9,6,6,7,7,8,7,9,7,8,7,9,8,10,11,9,9,9,9,7,8,7,8,9,11,14],
[16,16,17,14,13,13,12,13,14,15,15,16,17,17,18,19,19,20,20,20,19,19,17,18,18,17,14,13,13,12,11,12,13,13,14,12,13,11,10,8,5,7,9,8,8,8,7,7,7,8,8,9,10,9,10,9,9,8,8,9,10,10,11,13],
[15,17,17,15,14,13,11,11,13,13,16,17,16,17,16,19,19,19,19,19,18,18,18,17,17,16,15,15,15,14,12,13,13,15,14,11,10,9,10,8,7,8,8,7,9,8,5,6,7,8,7,7,7,9,10,9,9,10,10,10,11,12,11,12],
[12,14,14,13,13,12,12,12,14,15,17,16,16,16,15,16,17,18,19,18,17,18,19,18,18,17,16,16,16,15,13,14,13,14,13,11,10,10,9,10,10,9,9,9,11,9,7,7,8,8,8,7,6,7,8,10,11,10,8,9,9,10,10,11],
[11,12,13,11,10,11,12,13,13,15,15,15,17,17,16,16,17,17,18,17,17,19,18,19,19,18,18,17,19,18,16,15,15,15,12,11,8,10,10,11,11,10,10,10,12,11,8,8,6,7,6,6,7,6,8,10,11,10,9,8,9,9,10,10],
[10,12,12,11,10,11,12,14,16,16,15,16,18,17,17,17,19,19,19,19,18,18,17,18,18,19,18,18,17,17,17,16,17,15,12,10,8,8,8,11,13,11,10,11,13,10,8,8,7,6,5,6,6,6,6,8,10,9,7,7,9,9,9,9],
[10,12,13,11,11,13,12,15,17,17,15,15,16,16,16,17,20,20,20,20,19,19,18,19,19,20,19,17,18,17,17,16,17,15,12,10,9,8,9,10,11,9,9,11,12,10,8,7,5,5,5,6,5,5,5,6,9,8,6,6,8,9,8,8],
[9,11,12,12,12,13,12,15,18,17,16,16,18,17,17,18,19,19,19,19,18,19,18,18,18,18,19,17,16,16,17,18,19,16,14,12,11,10,11,12,12,11,10,12,14,11,9,9,8,7,5,6,6,6,7,8,10,9,8,8,8,9,9,9],
[9,10,11,12,12,14,14,16,19,18,17,17,17,18,18,20,20,19,20,18,19,18,18,18,18,17,17,15,16,16,18,18,19,16,15,13,12,12,13,14,13,12,13,13,15,13,10,11,9,8,8,6,7,7,9,10,11,10,10,9,9,9,10,9],
[11,11,11,11,12,12,13,14,16,17,17,17,16,18,18,19,18,19,19,18,17,18,19,18,18,16,15,16,16,17,18,19,19,17,16,14,14,14,16,16,16,14,15,14,14,12,10,11,11,10,10,8,8,10,11,12,14,12,11,11,11,11,12,11],
[12,12,11,10,11,11,12,13,14,16,16,15,16,18,18,18,18,19,18,19,18,17,17,17,17,16,15,16,19,19,20,20,20,19,16,16,16,16,18,18,16,15,16,13,13,11,9,11,11,10,9,9,11,12,14,15,17,13,13,12,12,12,14,12],
[12,11,11,11,11,11,12,14,15,16,16,16,15,17,17,16,14,17,18,18,18,17,17,17,17,17,17,18,18,19,19,19,19,18,16,18,19,18,18,18,17,16,17,14,13,12,10,11,11,11,10,11,13,14,15,15,16,14,12,12,11,12,12,11],
[10,9,11,12,11,11,14,16,17,17,17,17,17,17,16,14,13,15,17,18,18,18,18,18,19,19,18,19,20,19,19,19,19,18,19,20,20,20,19,18,17,15,16,14,15,14,12,12,12,13,12,13,14,14,15,15,17,15,13,12,10,11,10,9],
[8,9,10,10,9,12,16,17,19,18,16,17,17,16,16,14,12,15,17,18,18,19,19,19,19,19,19,20,19,19,19,19,20,19,19,20,20,20,20,19,19,16,14,15,14,14,12,12,13,12,11,12,12,14,16,15,15,14,12,11,10,10,9,8],
[8,10,10,8,9,12,17,18,20,19,17,18,16,16,17,14,13,15,18,20,19,20,20,20,20,20,20,20,20,20,17,20,20,19,20,20,20,20,20,20,19,16,15,15,13,14,13,13,13,13,11,12,13,15,16,14,15,14,11,12,10,8,7,7],
[7,9,10,9,9,13,17,17,18,18,18,16,16,15,16,14,13,15,18,17,17,18,20,20,20,20,20,20,20,18,17,17,18,18,19,19,20,19,18,18,16,15,14,13,11,11,11,12,13,12,11,10,11,13,14,14,14,13,11,10,10,9,8,7],
[6,7,9,10,9,13,15,15,18,17,16,15,13,12,14,14,14,13,15,15,15,17,18,19,20,19,19,18,18,17,16,15,15,15,17,17,18,18,17,15,14,14,12,11,8,10,10,10,11,9,9,8,9,11,12,13,13,12,11,9,10,8,7,5],
[8,9,10,10,10,14,18,18,18,18,16,15,14,13,11,12,12,13,15,15,15,16,17,19,20,20,20,18,17,16,16,15,15,15,15,16,17,17,15,14,12,12,12,10,9,8,7,8,9,8,8,8,9,11,12,12,12,11,10,9,10,8,7,7],
[7,9,12,12,11,14,18,20,20,19,17,15,15,13,11,12,11,13,14,15,14,16,18,19,20,19,20,18,16,14,13,13,14,15,14,15,16,16,15,12,10,10,11,9,8,7,6,5,6,7,5,6,10,10,10,10,12,10,9,8,8,7,6,6],
[7,8,11,11,11,13,15,16,16,16,15,15,14,14,12,12,11,13,13,13,13,14,16,18,18,18,18,17,15,14,14,13,13,15,16,17,18,16,15,13,12,11,10,8,8,6,6,7,8,7,6,8,10,10,10,11,12,10,9,9,9,8,7,6],
[6,6,8,10,10,11,14,14,15,16,15,16,16,14,13,12,11,12,11,11,12,12,14,17,18,18,17,17,14,15,14,14,15,16,17,17,19,16,15,13,13,10,9,6,5,5,6,7,9,8,8,10,11,11,11,11,10,11,9,9,9,8,6,5],
[5,6,7,8,9,11,14,13,12,13,13,14,15,14,12,11,10,10,11,10,10,10,12,14,16,16,15,14,12,13,13,14,14,16,16,18,18,17,15,13,11,10,10,7,5,5,7,7,9,9,9,9,10,11,12,11,11,10,10,8,7,6,5,5],
[5,6,5,8,9,10,12,11,11,12,12,11,12,14,13,11,8,8,8,9,7,8,9,10,12,14,14,13,11,11,12,13,14,16,18,18,18,17,15,14,11,10,10,7,5,5,6,6,8,7,8,8,8,10,12,11,11,9,9,7,5,5,5,5],
[5,5,5,7,8,10,12,11,11,12,13,12,12,12,10,9,6,7,7,7,5,7,9,10,12,13,13,12,11,11,11,13,15,16,17,16,17,15,13,13,11,10,10,8,7,7,8,9,11,10,10,9,9,10,12,10,10,9,7,7,5,5,5,5],
[5,6,6,6,7,9,10,10,11,12,12,11,13,12,10,9,6,6,6,6,5,6,7,7,10,12,11,11,11,11,12,14,15,16,15,13,13,14,14,13,11,11,10,10,9,10,10,13,13,12,11,8,9,10,10,9,9,8,8,6,5,5,5,5],
[5,5,6,7,8,9,10,11,12,12,13,12,12,10,7,7,6,6,6,6,5,5,5,7,10,10,11,10,10,10,9,12,15,14,14,12,12,14,15,13,11,12,11,10,9,11,12,13,15,13,11,11,11,11,10,10,11,10,9,7,5,6,7,6],
[5,5,6,7,8,9,10,12,12,11,12,12,10,9,7,6,5,5,5,5,6,5,6,7,7,8,10,9,10,10,10,10,12,13,12,11,12,14,15,14,13,13,11,12,11,12,13,14,16,13,12,13,14,12,11,11,12,12,9,9,7,7,7,7],
[7,7,7,8,8,9,9,11,12,11,11,12,12,10,9,7,6,5,5,5,5,6,6,6,6,7,8,10,12,11,10,10,11,11,10,11,12,12,13,12,12,11,10,10,10,11,13,16,19,17,15,15,16,15,15,14,13,12,11,9,7,7,6,7],
[7,7,7,8,9,9,9,11,11,11,12,11,12,11,8,6,5,5,5,5,6,6,5,5,5,8,8,10,12,12,10,9,10,10,10,10,11,11,10,9,10,8,8,7,7,12,14,18,20,20,18,18,18,18,16,16,15,13,12,11,8,8,7,7],
[6,7,7,7,8,8,8,10,11,11,12,12,13,11,10,7,5,5,6,6,7,6,5,5,5,7,9,10,12,11,10,9,8,9,9,8,8,8,7,7,6,7,6,7,8,12,14,17,19,19,17,19,19,19,19,18,17,15,13,11,6,7,6,6]
	];
	voxelContainer = document.createElement('div');
	voxelContainer.className = 'voxel_container';
	voxelContainer.style.display = 'none';
	canvas.appendChild(voxelContainer);
	for (var z = 0; z < zCount; z++) {
		voxels[z] = [];
		var realZ = z / 10;	// each successive 10 steps takes half the screenspace of the last
		var screenY = screenHeight / Math.pow(2,realZ);
		var screenX = (screenHeight - screenY) * aspect; // starting position for X
		var xStep = (screenY * aspect * 2) / xCount;	// 32 voxels per row
		for (var x = 0; x < xCount; x++) {
			var voxel = document.createElement('div');
			voxel.unitHeight = screenY / 25;
			voxel.style.position = 'absolute';
			voxel.style.left = screenX;
			screenX += xStep;
			voxel.base = screenY;
			voxel.style.top = screenY - voxel.unitHeight;
			voxel.style.height = 200;
			voxel.style.width = Math.floor(xStep) + 1;
			voxel.style.zIndex = Math.floor(screenY);
			voxels[z][x] = voxel;
			voxelContainer.appendChild(voxel);
		}
	}
	var creditData = [
		{text: 'concept - code - music', top: '-400px'},
		{text: 'by shingebis', top: '-340px'},
		{text: 'a browser demo', top: '-200px'},
		{text: "for assembly'04", top: '-140px'}
	];
	for (var i = 0; i < 4; i++) {
		credits[i] = document.createElement('div');
		credits[i].className = 'credit';
		credits[i].style.top = creditData[i].top;
		credits[i].appendChild(document.createTextNode(creditData[i].text));
		voxelContainer.appendChild(credits[i]);
	}			


	canvas.removeChild(loadingBanner);
	canvas.style.backgroundColor = '#000000';
	playMusic();
	startTime = new Date().getTime();
	tick();
}

function tick() {
	var now = new Date().getTime();
	var globalTime = now - startTime;
	if (globalTime < 33000) {
		runTitles(globalTime);
	} else if (globalTime < 39500) {
		runBump(globalTime - 33000);
	} else if (globalTime < 54500) {
		runCopper(globalTime - 39500);
	} else if (globalTime < 69000) {
		runWormhole(globalTime - 54500);
	} else if (globalTime < 90900) {
		runVectorBalls(globalTime - 69000);
	} else if (globalTime < 105500) {
		runMandelbrot(globalTime - 90900);
	} else if (globalTime < 134600) {
		runWolf(globalTime - 105500);
	} else if (globalTime < 163700) {
		runGouraud(globalTime - 134600);
	} else {
		runLandscape(globalTime - 163700);
	}
	setTimeout(tick, refreshRate);
}

function runTitles(t) {
	for (var i = 0; i < spripletCount; i++) {
		for (var j = 0; j < 3; j++) {
			var localTime = (t - i * letterGap - j * spriteGap);
			var page = Math.floor(localTime / pageGap);
			if (page >= 0 && page < 4) {
				var tk = localTime - (page * pageGap);
				var l = textData[i][page];
				if (tk < 512) {
					ht = Math.floor(104 + cosPath[tk] / 4);
					shade = Math.floor((256 - cosPath[tk]) / fudgeFactor[j]);
					zIndex = 2 - j;
				} else if (tk < switchTime1) {
					ht = 40;
					shade = 15;
					zIndex = 2 - j;
				} else if (tk <= pageEndTime - 1024) {
					ht = 40;
					shade = 15;
					zIndex = j;
				} else if (tk < pageEndTime) {
					// ht = Math.floor(104 + cosPath[pageEndTime - tk] / 4);
					ht = Math.floor(168 + cosPath[(pageEndTime - tk) >> 1] / 2);
					shade = Math.floor((pageEndTime - tk) / 64);
					zIndex = j;
				} else if (tk < switchTime2) {
					ht = 0;
					shade = 0;
					zIndex = j;
				} else {
					ht = 0;
					shade = 0;
					zIndex = 2 - j;
				}
				if (!letterImages[l.letter][shade]) {
					alert('l.letter = ' + l.letter + ', shade = ' + shade + ', tk = ' + tk + ', j = ' + j);
				}

				spriplets[i][zIndex].src = letterImages[l.letter][shade].src;
				spriplets[i][zIndex].width = letters[l.letter];
				spriplets[i][zIndex].height = ht;
				spriplets[i][zIndex].style.left = l.x + 'px';
				spriplets[i][zIndex].style.top = (l.y - ht / 2) + 'px';
			}
		}
	}
}

function initBump() {
	canvas.removeChild(titleContainer);
	bumpContainer.style.display = 'block';
}

function runBump(t) {
	if (!initedBump) {
		initBump();
		initedBump = true;
	}

	var xt = t % 2000;
	var lightX = Math.sin(xt * Math.PI / 1000) / (t/8000 + 1);
	var yt = t % 2812;
	var lightY = Math.sin(yt * Math.PI / 1406) / (t/8000 + 1);

	if (t < 500) {
		var preGamma = t/500;
	} else {
		var preGamma = 1;
	}

	if (t < 6000) {
		var postGamma = 1
	} else {
		var postGamma = Math.max(0, (6500 - t) / 500);
	}

	var faceIntensity = preGamma * (255 - Math.floor(postGamma * (180 * Math.sqrt(lightX * lightX + lightY * lightY))));
	setClassIntensity('face', faceIntensity);
	var bgIntensity = 255 - Math.floor(255 * postGamma);
	canvas.style.backgroundColor = 'rgb(' + bgIntensity + ',' + bgIntensity + ',' + bgIntensity + ')';
	setClassIntensity('left', preGamma * (255 - Math.floor(postGamma * (114 * Math.sqrt((lightX + 1) * (lightX + 1) + lightY * lightY)))));
	setClassIntensity('right', preGamma * (255 - Math.floor(postGamma * (114 * Math.sqrt((lightX - 1) * (lightX - 1) + lightY * lightY)))));
	setClassIntensity('top', preGamma * (255 - Math.floor(postGamma * (114 * Math.sqrt(lightX * lightX + (lightY + 1) * (lightY + 1))))));
	setClassIntensity('bottom', preGamma * (255 - Math.floor(postGamma * (114 * Math.sqrt(lightX * lightX + (lightY - 1) * (lightY - 1))))));
}

function setClassIntensity(blockClass, intensity) {
	for (var i = 0; i < blocks[blockClass].length; i++) {
		blocks[blockClass][i].element.style.backgroundColor = 'rgb(' + intensity + ',' + intensity + ',' + intensity + ')';
	}
}

function initCopper() {
	canvas.removeChild(bumpContainer);
	copperContainer.style.display = 'block';
}

function runCopper(t) {
	if (!initedCopper) {
		initCopper();
		initedCopper = true;
	}
	var sinepos1 = Math.floor(t * 0.2) % 360;
	var sinepos2 = Math.floor(t * 0.16) % 360;
	var backgroundPos = Math.floor(t * 0.03) % 160;
	// var scrollSinePos = (t * 0.3) % 360;
	
	var scrollPos = t / msPerLetter; /* the number of letters which have passed the left boundary */
	var startScrollyLetter = Math.floor(scrollPos);
	var x = Math.floor((startScrollyLetter - scrollPos) * pixPerLetter - 32);
	for (var i = startScrollyLetter; i < startScrollyLetter + 16; i++) {
		var slsp = i % 16;
		if (scrollyLetter[slsp].currentLetter != scrollyText[i]) {
			scrollyLetter[slsp].element.removeChild(scrollyLetter[slsp].element.firstChild);
			scrollyLetter[slsp].element.appendChild(document.createTextNode(scrollyText[i]));
			scrollyLetter[slsp].currentLetter = scrollyText[i];
		}
		scrollyLetter[slsp].element.style.left = x + 'px';
		scrollyLetter[slsp].element.style.top = 400 + (copperSine[Math.floor(x + t * 0.8) % 360] >> 2) + 'px';
		x += pixPerLetter;
		// scrollSinePos += 32; scrollSinePos %= 360;
	}
	
	copperContainer.style.backgroundPosition = '0px ' + backgroundPos + 'px';
	for (var i = 0; i < barCount; i++) {
		copperBar[i].style.left = 400 + copperSine[i * 2 + sinepos1] + copperSine[i + sinepos2];
	}
}

function initWormhole() {
	canvas.style.backgroundColor = '#000000';
	canvas.removeChild(copperContainer);
	wormholeContainer.style.display = 'block';
}

function runWormhole(t) {
	if (!initedWormhole) {
		initWormhole();
		initedWormhole = true;
	}
	t /= 1000;
	var rota = t * 50 % 512;
	var cosRota = Math.cos(rota * Math.PI / 256);
	var sinRota = Math.sin(rota * Math.PI / 256);

	var sprno = Math.floor(rota) % 16;

	var ringT = Math.ceil(t / ringSpacing) * ringSpacing;

	// var camY = 0;
	var camX = Math.sin(t / wormholeSinLen);

	for (var i = 0; i < 8; i++) {
		var z = ringT - t;
		var y = 0 // - camY;
		var x = Math.sin(ringT / wormholeSinLen) - camX;
		var scale = 300 / Math.pow(2, z);
		var scaleX = (x * cosRota - y * sinRota) * scale;
		var scaleY = (y * cosRota + x * sinRota) * scale;
		ringSprites[i].style.left = Math.floor(400 + scaleX - scale) + 'px';
		ringSprites[i].style.top = Math.floor(300 + scaleY - scale) + 'px';
		ringSprites[i].width = ringSprites[i].height = Math.floor(scale * 2);
		ringSprites[i].src = ringImages[sprno].src;
		ringT += ringSpacing;
	}
}

function initVectorBalls() {
	canvas.style.backgroundColor = '#111144';
	canvas.removeChild(wormholeContainer);
	vectorBallsContainer.style.display = 'block';
}

function runVectorBalls(t) {
	if (!initedVectorBalls) {
		initVectorBalls();
		initedVectorBalls = true;
	}
	if (t < 2000) {
		doVectorBalls(t, 0, 0, 0, (2000 - t) / 200);
	} else if (t < 7000) {
		doVectorBalls(t, 0, 0, 0, 0);
	} else if (t < 10000) {
		doVectorBalls(t, 0, 1, (t - 7000) / 3000, 0);
	} else if (t < 13000) {
		doVectorBalls(t, 1, 1, 0, 0);
	} else if (t < 14000) {
		doVectorBalls(t, 1, 2, (t - 13000) / 1000, 0);
	} else if (t < 16500) {
		doVectorBalls(t, 2, 2, 0, 0);
	} else if (t < 17500) {
		doVectorBalls(t, 2, 3, (t - 16500) / 1000, 0);
	} else if (t < 20000) {
		doVectorBalls(t, 3, 3, 0, 0);
	} else { /* t < 21000 */
		doVectorBalls(t, 3, 3, 0, (t - 20000) / 100);
	};
}

function doVectorBalls(t, shape0, shape1, morphPos, zAdjust) {

	ar = (t % 2468) / 1234;
	br = (t % 2692) / 1346;
	cr = (t % 2912) / 1456;
	
	cos_a = Math.cos(ar * Math.PI);
	sin_a = Math.sin(ar * Math.PI);
	cos_b = Math.cos(br * Math.PI);
	sin_b = Math.sin(br * Math.PI);
	cos_c = Math.cos(cr * Math.PI);
	sin_c = Math.sin(cr * Math.PI);
	
	var m_ar = [
		[1,     0,      0],
		[0, cos_a, -sin_a],
		[0, sin_a,  cos_a]
	];
	
	var m_br = [
		[ cos_b, 0, sin_b],
		[     0, 1,     0],
		[-sin_b, 0, cos_b]
	];
	
	var m_cr = [
		[cos_c, -sin_c, 0],
		[sin_c,  cos_c, 0],
		[    0,      0, 1]
	];
	
	var m_rot = mat3Mult(mat3Mult(m_ar, m_br), m_cr);
	
	for (var i=0; i < ballCount; i++) {
		mid_coords = [
			ball[i].coords[shape0][0] * (1 - morphPos) + ball[i].coords[shape1][0] * morphPos,
			ball[i].coords[shape0][1] * (1 - morphPos) + ball[i].coords[shape1][1] * morphPos,
			ball[i].coords[shape0][2] * (1 - morphPos) + ball[i].coords[shape1][2] * morphPos
		];
		var world_coords = vec3Mult(mid_coords, m_rot);
		var scaleFactor = Math.pow(2, zAdjust);
		world_coords[0] /= scaleFactor;
		world_coords[1] /= scaleFactor;
		ball[i].element.style.left = world_coords[0] * 64 + 400 + 'px';
		ball[i].element.style.top = world_coords[1] * 64 + 200 + 'px';
		var z = Math.floor((world_coords[2] + 4) * 4);
		ball[i].element.style.width = ball[i].element.style.height = z / (zAdjust + 1) + 'px';
		ball[i].element.style.zIndex = z;
	}
}

function mat3Mult(m1, m2) {
	var n = [];
	n[0] = []; n[1] = []; n[2] = [];
	n[0][0] = m1[0][0] * m2[0][0] + m1[0][1] * m2[1][0] + m1[0][2] * m2[2][0];
	n[0][1] = m1[0][0] * m2[0][1] + m1[0][1] * m2[1][1] + m1[0][2] * m2[2][1];
	n[0][2] = m1[0][0] * m2[0][2] + m1[0][1] * m2[1][2] + m1[0][2] * m2[2][2];

	n[1][0] = m1[1][0] * m2[0][0] + m1[1][1] * m2[1][0] + m1[1][2] * m2[2][0];
	n[1][1] = m1[1][0] * m2[0][1] + m1[1][1] * m2[1][1] + m1[1][2] * m2[2][1];
	n[1][2] = m1[1][0] * m2[0][2] + m1[1][1] * m2[1][2] + m1[1][2] * m2[2][2];

	n[2][0] = m1[2][0] * m2[0][0] + m1[2][1] * m2[1][0] + m1[2][2] * m2[2][0];
	n[2][1] = m1[2][0] * m2[0][1] + m1[2][1] * m2[1][1] + m1[2][2] * m2[2][1];
	n[2][2] = m1[2][0] * m2[0][2] + m1[2][1] * m2[1][2] + m1[2][2] * m2[2][2];
	
	return n;
}

function vec3Mult(v1, m) {
	var v2 = [];
	v2[0] = v1[0] * m[0][0] + v1[1] * m[0][1] + v1[2] * m[0][2];
	v2[1] = v1[0] * m[1][0] + v1[1] * m[1][1] + v1[2] * m[1][2];
	v2[2] = v1[0] * m[2][0] + v1[1] * m[2][1] + v1[2] * m[2][2];
	return v2;
}

function initMandelbrot() {
	canvas.removeChild(vectorBallsContainer);
}

function runMandelbrot(t) {
	if (!initedMandelbrot) {
		initMandelbrot();
		initedMandelbrot = true;
	}
	t /= 1000;
	var frameNumber = Math.floor(t / tileChangePeriod);
	var tileMagnification = Math.exp(t * logZoomRate - frameNumber * log2);

	if (frameNumber != lastFrameNumber) {
		tile0.src = mandelFrames[frameNumber].src;
	}

	tile0.style.left = 400 - (400 * tileMagnification);
	tile0.style.top = 300 - (300 * tileMagnification);
	tile0.style.width = 800 * tileMagnification;
	tile0.style.height = 600 * tileMagnification;
	if (frameNumber != lastFrameNumber) {
		tile1.style.left = 1000;
		tile1.src = mandelFrames[frameNumber + 1].src;
	}
	tile1.style.top = 300 - (150 * tileMagnification);
	tile1.style.width = 400 * tileMagnification;
	tile1.style.height = 300 * tileMagnification;
	tile1.style.left = 400 - (200 * tileMagnification);
	if (frameNumber != lastFrameNumber) {
		lastFrameNumber = frameNumber;
	}
}

function splinetrix(i, control) {
	var g = [control[i-3], control[i-2], control[i-1], control[i]];
	var m = bezierMatrix;
	var s = [[],[]];
	s[0][0] = g[0][0] * m[0][0] + g[1][0] * m[1][0] + g[2][0] * m[2][0] + g[3][0] * m[3][0];
	s[0][1] = g[0][0] * m[0][1] + g[1][0] * m[1][1] + g[2][0] * m[2][1] + g[3][0] * m[3][1];
	s[0][2] = g[0][0] * m[0][2] + g[1][0] * m[1][2] + g[2][0] * m[2][2] + g[3][0] * m[3][2];
	s[0][3] = g[0][0] * m[0][3] + g[1][0] * m[1][3] + g[2][0] * m[2][3] + g[3][0] * m[3][3];

	s[1][0] = g[0][1] * m[0][0] + g[1][1] * m[1][0] + g[2][1] * m[2][0] + g[3][1] * m[3][0];
	s[1][1] = g[0][1] * m[0][1] + g[1][1] * m[1][1] + g[2][1] * m[2][1] + g[3][1] * m[3][1];
	s[1][2] = g[0][1] * m[0][2] + g[1][1] * m[1][2] + g[2][1] * m[2][2] + g[3][1] * m[3][2];
	s[1][3] = g[0][1] * m[0][3] + g[1][1] * m[1][3] + g[2][1] * m[2][3] + g[3][1] * m[3][3];

	return s;
}

function spline(t, control, splinetrixCache) {
	var i = Math.floor(t);
	if (splinetrixCache[i] == null) {
		splinetrixCache[i] = splinetrix(i, control);
	}
	var gm = splinetrixCache[i];
	var tFrac = t - i;
	var tVec = [tFrac*tFrac*tFrac, tFrac*tFrac, tFrac, 1];
	return [
		gm[0][0] * tVec[0] + gm[0][1] * tVec[1] + gm[0][2] * tVec[2] + gm[0][3],
		gm[1][0] * tVec[0] + gm[1][1] * tVec[1] + gm[1][2] * tVec[2] + gm[1][3],
	];
}

function splineVelocity(t, control, splinetrixCache) {
	var i = Math.floor(t);
	var gm = splinetrixCache[i]; /* assume already cached from call to spline() */
	var tFrac = t - i;
	var tVec = [3*tFrac*tFrac, 2*tFrac, 1, 0];
	return [
		gm[0][0] * tVec[0] + gm[0][1] * tVec[1] + gm[0][2],
		gm[1][0] * tVec[0] + gm[1][1] * tVec[1] + gm[1][2],
	];
}

function initWolf() {
	canvas.style.backgroundColor = '#111144';
	canvas.removeChild(tile0);
	canvas.removeChild(tile1);
	wolfContainer.style.display = 'block';	
}

function runWolf(tm) {
	if (!initedWolf) {
		initWolf();
		initedWolf = true;
	}
	tm = tm / 2000 + 3;
	var cam = spline(tm, wolfPath, splinetrixCache);
	camX = cam[0]; camY = cam[1];
	var camVel = splineVelocity(tm, wolfPath, splinetrixCache);
	var bearing = Math.atan2(camVel[0], camVel[1]);

	var t = bearing - angleOfVision;
	for (var i = 0; i < stripCount; i++) {
		var ignoreVerticalWalls = (Math.floor(camX) == Math.floor(camX + 20 * Math.sin(t)));
		if (ignoreVerticalWalls) {
			var ignoreHorizontalWalls = false;
		} else {
			var ignoreHorizontalWalls = (Math.floor(camY) == Math.floor(camY + 20 * Math.cos(t)));
		}
		
		var hWallType = 1;
		if (ignoreHorizontalWalls) {
			var hWallX = 0;
			var hWallDistance = 10000;
		} else {
			var importantTan = Math.tan(t);
			if (Math.cos(t) > 0) {
				/* facing up */
				var isFacingUp = true;
				var wallY = Math.floor(camY) + 1;
				var dy = wallY - camY;
				var hWallX = camX + dy * importantTan;
				while (hWallX < 16 && hWallX > 0) {
					var w = maze[Math.floor(hWallX)][wallY];
					if (w) {hWallType = w; break;}
					dy++; wallY++;
					hWallX += importantTan;
				}
				var hWallDistance = dy / Math.cos(t);
			} else {
				/* facing down */
				var isFacingUp = false;
				var wallY = Math.floor(camY);
				var dy = wallY - camY;
				var hWallX = camX + dy * importantTan;
				while (hWallX < 16 && hWallX > 0) {
					var w = maze[Math.floor(hWallX)][wallY - 1];
					if (w) {hWallType = w; break;}
					dy--; wallY--;
					hWallX -= importantTan;
				}
				var hWallDistance = dy / Math.cos(t);
			}
		}
		var vWallType = 1;
		if (ignoreVerticalWalls) {
			var vWallY = 0;
			var vWallDistance = 10000;
		} else {
			var importantTan = Math.tan(t - Math.PI / 2);
			if (Math.sin(t) > 0) {
				/* facing right */
				var isFacingRight = true;
				var wallX = Math.floor(camX) + 1;
				var dx = wallX - camX;
				var vWallY = camY - dx * importantTan;
				while (vWallY < 16 && vWallY > 0) {
					var w = maze[wallX][Math.floor(vWallY)];
					if (w) {vWallType = w; break;}
					dx++; wallX++;
					vWallY -= importantTan;
				}
				var vWallDistance = dx / Math.sin(t);
			} else {
				/* facing left */
				var isFacingRight = false;
				var wallX = Math.floor(camX);
				var dx = wallX - camX;
				var vWallY = camY - dx * importantTan;
				while (vWallY < 16 && vWallY > 0) {
					var w = maze[wallX - 1][Math.floor(vWallY)];
					if (w) {vWallType = w; break;}
					dx--; wallX--;
					vWallY += importantTan;
				}
				var vWallDistance = dx / Math.sin(t);
			}
		}
		
		if (vWallDistance < hWallDistance) {
			var wallDistance = vWallDistance;
			var wallType = vWallType;
			if (!isFacingRight) {
				var imgStrip = Math.floor((vWallY - Math.floor(vWallY)) * 96);
			} else {
				var imgStrip = 95 - Math.floor((vWallY - Math.floor(vWallY)) * 96);
			}
		} else {
			var wallDistance = hWallDistance;
			var wallType = hWallType;
			if (isFacingUp) {
				var imgStrip = Math.floor((hWallX - Math.floor(hWallX)) * 96);
			} else {
				var imgStrip = 95 - Math.floor((hWallX - Math.floor(hWallX)) * 96);
			}
		}
		
		if (wallDistance < 0.01) {wallDistance = 0.01;}
		strips[i].src = wolfImages[wallType][imgStrip].src;
		strips[i].style.top = 250 - Math.floor((1 / wallDistance) * 100);
		strips[i].height = Math.floor((1 / wallDistance) * 200);

		t += dt;
	}

}

function initGouraud() {
	canvas.style.backgroundColor = '#111144';
	canvas.removeChild(wolfContainer);
	gouraudContainer.style.display = 'block';	
}

function runGouraud(t) {
	if (!initedGouraud) {
		initGouraud();
		initedGouraud = true;
	}
	asciiT = Math.floor(t / 25);
	pseudocodeCanvas.value = pseudocode.slice(asciiT, asciiT + 500);

	for (i = 0; i < 48; i++) {
		bmp[i] = "                                                                                                \n"; /* 96 spaces */
		zBuffer[i] = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
	}

	ar = (t % 4936) / 2468;
	br = (t % 5384) / 2692;
	cr = (t % 5824) / 2912;
	ar2 = (t % 5856) / 2928;
	br2 = (t % 6420) / 3210;
	cr2 = (t % 5132) / 2566;

	cos_a = Math.cos(ar * Math.PI);
	sin_a = Math.sin(ar * Math.PI);
	cos_b = Math.cos(br * Math.PI);
	sin_b = Math.sin(br * Math.PI);
	cos_c = Math.cos(cr * Math.PI);
	sin_c = Math.sin(cr * Math.PI);
	cos_a2 = Math.cos(ar2 * Math.PI);
	sin_a2 = Math.sin(ar2 * Math.PI);
	cos_b2 = Math.cos(br2 * Math.PI);
	sin_b2 = Math.sin(br2 * Math.PI);
	cos_c2 = Math.cos(cr2 * Math.PI);
	sin_c2 = Math.sin(cr2 * Math.PI);
	
	dispTetr = [cos_b * 8, cos_c * 8, cos_a * 8];
	
	var m_ar = [
		[1,     0,      0],
		[0, cos_a, -sin_a],
		[0, sin_a,  cos_a]
	];
	
	var m_br = [
		[ cos_b, 0, sin_b],
		[     0, 1,     0],
		[-sin_b, 0, cos_b]
	];
	
	var m_cr = [
		[cos_c, -sin_c, 0],
		[sin_c,  cos_c, 0],
		[    0,      0, 1]
	];
	
	var m_rot = mat3Mult(mat3Mult(m_ar, m_br), m_cr);

	for (var i=0; i < 36; i++) {
		vertex.torus[i].wc = vec3Mult(vertex.torus[i].coords, m_rot);
		vertex.torus[i].wc[0] -= dispTetr[0];
		vertex.torus[i].wc[1] -= dispTetr[1];
		vertex.torus[i].wc[2] -= dispTetr[2];
		vertex.torus[i].light = Math.max(0, -vertex.torus[i].wc[2] / 5 + 4);
	}

	var m_ar = [
		[1,     0,      0],
		[0, cos_a2, -sin_a2],
		[0, sin_a2,  cos_a2]
	];
	
	var m_br = [
		[ cos_b2, 0, sin_b2],
		[     0, 1,     0],
		[-sin_b2, 0, cos_b2]
	];
	
	var m_cr = [
		[cos_c2, -sin_c2, 0],
		[sin_c2,  cos_c2, 0],
		[    0,      0, 1]
	];
	
	var m_rot = mat3Mult(mat3Mult(m_ar, m_br), m_cr);

	for (var i=0; i < 4; i++) {
		vertex.tetra[i].wc = vec3Mult(vertex.tetra[i].coords, m_rot);
		vertex.tetra[i].wc[0] += dispTetr[0];
		vertex.tetra[i].wc[1] += dispTetr[1];
		vertex.tetra[i].wc[2] += dispTetr[2];
		if (t < 13000) {
			vertex.tetra[i].wc[0] += 100;
		} else if (t < 16000) {
			vertex.tetra[i].wc[0] += (16000 - t) / 60;
			vertex.tetra[i].wc[1] -= (16000 - t) / 120;
		}
		vertex.tetra[i].light = Math.max(0, -vertex.tetra[i].wc[2] / 5 + 4);
	}

	plotPoly(vertex.torus[0],vertex.torus[6],vertex.torus[7]);
	plotPoly(vertex.torus[0],vertex.torus[7],vertex.torus[1]);

	plotPoly(vertex.torus[1],vertex.torus[7],vertex.torus[8]);
	plotPoly(vertex.torus[1],vertex.torus[8],vertex.torus[2]);
	
	plotPoly(vertex.torus[2],vertex.torus[8],vertex.torus[9]);
	plotPoly(vertex.torus[2],vertex.torus[9],vertex.torus[3]);
	
	plotPoly(vertex.torus[3],vertex.torus[9],vertex.torus[10]);
	plotPoly(vertex.torus[3],vertex.torus[10],vertex.torus[4]);

	plotPoly(vertex.torus[4],vertex.torus[10],vertex.torus[11]);
	plotPoly(vertex.torus[4],vertex.torus[11],vertex.torus[5]);

	plotPoly(vertex.torus[5],vertex.torus[11],vertex.torus[6]);
	plotPoly(vertex.torus[5],vertex.torus[6],vertex.torus[0]);

	plotPoly(vertex.torus[6],vertex.torus[12],vertex.torus[13]);
	plotPoly(vertex.torus[6],vertex.torus[13],vertex.torus[7]);

	plotPoly(vertex.torus[7],vertex.torus[13],vertex.torus[14]);
	plotPoly(vertex.torus[7],vertex.torus[14],vertex.torus[8]);

	plotPoly(vertex.torus[8],vertex.torus[14],vertex.torus[15]);
	plotPoly(vertex.torus[8],vertex.torus[15],vertex.torus[9]);
	
	plotPoly(vertex.torus[9],vertex.torus[15],vertex.torus[16]);
	plotPoly(vertex.torus[9],vertex.torus[16],vertex.torus[10]);

	plotPoly(vertex.torus[10],vertex.torus[16],vertex.torus[17]);
	plotPoly(vertex.torus[10],vertex.torus[17],vertex.torus[11]);

	plotPoly(vertex.torus[11],vertex.torus[17],vertex.torus[12]);
	plotPoly(vertex.torus[11],vertex.torus[12],vertex.torus[6]);

	plotPoly(vertex.torus[12],vertex.torus[18],vertex.torus[19]);
	plotPoly(vertex.torus[12],vertex.torus[19],vertex.torus[13]);

	plotPoly(vertex.torus[13],vertex.torus[19],vertex.torus[20]);
	plotPoly(vertex.torus[13],vertex.torus[20],vertex.torus[14]);

	plotPoly(vertex.torus[14],vertex.torus[20],vertex.torus[21]);
	plotPoly(vertex.torus[14],vertex.torus[21],vertex.torus[15]);

	plotPoly(vertex.torus[15],vertex.torus[21],vertex.torus[22]);
	plotPoly(vertex.torus[15],vertex.torus[22],vertex.torus[16]);

	plotPoly(vertex.torus[16],vertex.torus[22],vertex.torus[23]);
	plotPoly(vertex.torus[16],vertex.torus[23],vertex.torus[17]);

	plotPoly(vertex.torus[17],vertex.torus[23],vertex.torus[18]);
	plotPoly(vertex.torus[17],vertex.torus[18],vertex.torus[12]);

	plotPoly(vertex.torus[18],vertex.torus[24],vertex.torus[25]);
	plotPoly(vertex.torus[18],vertex.torus[25],vertex.torus[19]);

	plotPoly(vertex.torus[19],vertex.torus[25],vertex.torus[26]);
	plotPoly(vertex.torus[19],vertex.torus[26],vertex.torus[20]);

	plotPoly(vertex.torus[20],vertex.torus[26],vertex.torus[27]);
	plotPoly(vertex.torus[20],vertex.torus[27],vertex.torus[21]);

	plotPoly(vertex.torus[21],vertex.torus[27],vertex.torus[28]);
	plotPoly(vertex.torus[21],vertex.torus[28],vertex.torus[22]);

	plotPoly(vertex.torus[22],vertex.torus[28],vertex.torus[29]);
	plotPoly(vertex.torus[22],vertex.torus[29],vertex.torus[23]);

	plotPoly(vertex.torus[23],vertex.torus[29],vertex.torus[24]);
	plotPoly(vertex.torus[23],vertex.torus[24],vertex.torus[18]);

	plotPoly(vertex.torus[24],vertex.torus[30],vertex.torus[31]);
	plotPoly(vertex.torus[24],vertex.torus[31],vertex.torus[25]);

	plotPoly(vertex.torus[25],vertex.torus[31],vertex.torus[32]);
	plotPoly(vertex.torus[25],vertex.torus[32],vertex.torus[26]);

	plotPoly(vertex.torus[26],vertex.torus[32],vertex.torus[33]);
	plotPoly(vertex.torus[26],vertex.torus[33],vertex.torus[27]);

	plotPoly(vertex.torus[27],vertex.torus[33],vertex.torus[34]);
	plotPoly(vertex.torus[27],vertex.torus[34],vertex.torus[28]);

	plotPoly(vertex.torus[28],vertex.torus[34],vertex.torus[35]);
	plotPoly(vertex.torus[28],vertex.torus[35],vertex.torus[29]);

	plotPoly(vertex.torus[29],vertex.torus[35],vertex.torus[30]);
	plotPoly(vertex.torus[29],vertex.torus[30],vertex.torus[24]);

	plotPoly(vertex.torus[30],vertex.torus[0],vertex.torus[1]);
	plotPoly(vertex.torus[30],vertex.torus[1],vertex.torus[31]);

	plotPoly(vertex.torus[31],vertex.torus[1],vertex.torus[2]);
	plotPoly(vertex.torus[31],vertex.torus[2],vertex.torus[32]);

	plotPoly(vertex.torus[32],vertex.torus[2],vertex.torus[3]);
	plotPoly(vertex.torus[32],vertex.torus[3],vertex.torus[33]);

	plotPoly(vertex.torus[33],vertex.torus[3],vertex.torus[4]);
	plotPoly(vertex.torus[33],vertex.torus[4],vertex.torus[34]);

	plotPoly(vertex.torus[34],vertex.torus[4],vertex.torus[5]);
	plotPoly(vertex.torus[34],vertex.torus[5],vertex.torus[35]);

	plotPoly(vertex.torus[35],vertex.torus[5],vertex.torus[0]);
	plotPoly(vertex.torus[35],vertex.torus[0],vertex.torus[30]);


	plotPoly(vertex.tetra[0],vertex.tetra[2],vertex.tetra[1]);
	plotPoly(vertex.tetra[0],vertex.tetra[1],vertex.tetra[3]);
	plotPoly(vertex.tetra[0],vertex.tetra[3],vertex.tetra[2]);
	plotPoly(vertex.tetra[1],vertex.tetra[2],vertex.tetra[3]);

	var img = '';
	for (var y = 0; y < 48; y++) {
		img += bmp[y];
	}
	asciiCanvas.value = img;
}

function plotPoly(v1,v2,v3) {
	var cx1 = v1.wc[0] + 24;
	var cy1 = v1.wc[1] + 24;
	var cs1 = v1.light;
	var cx2 = v2.wc[0] + 24;
	var cy2 = v2.wc[1] + 24;
	var cs2 = v2.light;
	var cx3 = v3.wc[0] + 24;
	var cy3 = v3.wc[1] + 24;
	var cs3 = v3.light;
	
	/* only continue if anti-clockwise */
	if ((cx2 - cx1) * (cy3 - cy1) - (cx3 - cx1) * (cy2 - cy1) <= 0) {
		return;
	}
	for (i = 0; i < 48; i++) {
		yBuffer[i] = [];
	}
	plotEdge(yBuffer, cx1, cy1, cs1, cx2, cy2, cs2);
	plotEdge(yBuffer, cx2, cy2, cs2, cx3, cy3, cs3);
	plotEdge(yBuffer, cx3, cy3, cs3, cx1, cy1, cs1);
	for (var y=0; y < 48; y++) {
		switch (yBuffer[y].length) {
			case 1:
				var x = yBuffer[y][0][0];
				zBuffer[y][x] = Math.max(zBuffer[y][x], Math.floor(yBuffer[y][0][1]));
				bmp[y] = bmp[y].slice(0, x * 2) + shades[zBuffer[y][x]] + bmp[y].slice(x * 2 + 2);
				break;
			case 2:
				if (yBuffer[y][0][0] < yBuffer[y][1][0]) {
					var a = yBuffer[y][0][0]; var b = yBuffer[y][1][0];
					var sa = yBuffer[y][0][1]; var sb = yBuffer[y][1][1];
				} else {
					var a = yBuffer[y][1][0]; var b = yBuffer[y][0][0];
					var sa = yBuffer[y][1][1]; var sb = yBuffer[y][0][1];
				}
				var scanline = '';
				var dx = b - a;
				if (dx > 0) {
					var sgrad = (sb - sa) / dx;
				} else {
					var sgrad = 0;
				}
				var s = sa;
				for (var x = a; x < b; x++) {
					zBuffer[y][x] = Math.max(zBuffer[y][x], Math.floor(s));
					scanline += shades[zBuffer[y][x]];
					s += sgrad;
				}
				bmp[y] = bmp[y].slice(0, a * 2) + scanline + bmp[y].slice(b * 2);
				break;
		}
	}
}

function plotEdge(yBuffer, xo1, yo1, so1, xo2, yo2, so2) {
	if (yo2 < yo1) {
		var y1 = yo2;
		var x1 = xo2;
		var s1 = so2;
		var y2 = yo1;
		var x2 = xo1;
		var s2 = so1;
	} else {
		var y1 = yo1;
		var x1 = xo1;
		var s1 = so1;
		var y2 = yo2;
		var x2 = xo2;
		var s2 = so2;
	}
	var dy = y2 - y1;
	if (dy < 0.001) {return;}
	var gradient = (x2 - x1) / dy;
	var sgradient = (s2 - s1) / dy;
	
	var Ay = Math.floor(y1 + 1);
	var ey = Ay - y1;
	var x = x1 + gradient * ey;
	var s = s1 + sgradient * ey;
	var By = Math.floor(y2);
	
	for (var y = Ay; y <= By && y < 48; y++) {
		if (y >= 0) {
			yBuffer[y].push([Math.min(47,Math.max(0,Math.floor(x))), s]);
		}
		x += gradient;
		s += sgradient;
	}
}

function initLandscape() {
	canvas.style.backgroundColor = '#bbffff';
	canvas.removeChild(gouraudContainer);
	voxelContainer.style.display = 'block';	
}
function runLandscape(t) {
	if (!initedLandscape) {
		initLandscape();
		initedLandscape = true;
	}
	for (var i = 0; i < 4; i++) {
		var creditTime = t - i * 1000;
		if (creditTime > 0 && creditTime < 5000) {
			credits[i].style.letterSpacing = Math.max(8, Math.floor(24 - creditTime/125)) + 'px';
			var rVal = Math.max(170, 187 - Math.floor(creditTime * 17 / 2000));
			var gbVal = Math.max(170, 255 - Math.floor(creditTime * 85 / 2000));
			credits[i].style.color = 'rgb(' + rVal + ',' + gbVal + ',' + gbVal + ')';
		}
	}

	var dist = Math.floor(t * 6) & 16383;
	var bearing = Math.sin(Math.PI * ((t / 4000) % 2));
	
	xStepDx = zStepDz = Math.floor(Math.cos(bearing) * 256);
	zStepDx = Math.floor(Math.sin(bearing) * 256);
	xStepDz = -zStepDx;

	rowMiddleX = 0;
	rowStartX = rowMiddleX - (xStepDx * xCount >> 1);
	rowStartZ = dist - (xStepDz * xCount >> 1);
	for (z = 0; z < zCount; z++) {
		posX = rowStartX; posZ = rowStartZ;
		for (x = 0; x < xCount; x++) {
			voxel = voxels[z][x];
			actualHeight = heightmap[(posZ >> 8) & 63][(posX >> 8) & 63];
			height = voxel.unitHeight * actualHeight;
			voxel.style.top = voxel.base - height;
			voxel.style.backgroundColor = landColor[actualHeight >> 1];
			posX += xStepDx; posZ += xStepDz;
		}
		rowStartZ += zStepDz; rowStartX += zStepDx;
	}	
}