#include "glJPEG.h"

void jpeg_loader :: add_alpha (unsigned char mask[3]=NULL)
{
    unsigned char *data = new unsigned char[width*height*4];
    long int q = 0;
    long int s = 0;
    for (int i=0; i<width*height; i++) {
        data[q+0] = bitmap[s+0];
        data[q+1] = bitmap[s+1];
        data[q+2] = bitmap[s+2];
        //data[q+3] = 255;
        if (mask) {
            if ((bitmap[s+0]==mask[0])&&(bitmap[s+1]==mask[1])&&(bitmap[s+2]==mask[2]))
                data[q+3]=0;
            else data[q+3]=255;
        } else data[q+3]=255;
        q+=4;
        s+=3;
    }
    delete [] bitmap;
    bitmap = data;
    bpp=4;
}

int jpeg_loader :: upload (bool delete_after)
{
    glGenTextures(1,&texture_id);
 	glBindTexture(GL_TEXTURE_2D, texture_id);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if (bpp==3)
	   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, width, height, 0, GL_RGB, GL_UNSIGNED_BYTE, bitmap);
    else
	   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, bitmap);

    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	
	if (delete_after) delete [] bitmap;
	return texture_id;
}

jpeg_loader :: jpeg_loader ()
{ bitmap=NULL; }

jpeg_loader :: ~jpeg_loader ()
{ if (bitmap) delete [] bitmap; }

bool jpeg_loader :: load (char *filename) {

    FILE *f = fopen(filename, "rb");
    if (f == NULL) return false;

    jpeg_decompress_struct cinfo;
    jpeg_error_mgr jerr;
    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_decompress(&cinfo);
    jpeg_stdio_src(&cinfo, f);
    jpeg_read_header(&cinfo, TRUE);
    cinfo.dither_mode = DITHER_MODE;
    cinfo.two_pass_quantize = TWO_PASS_QUANTIZE;
    jpeg_start_decompress(&cinfo);
    width = cinfo.image_width;
    height = cinfo.image_height;
    bpp = cinfo.num_components;
    JSAMPARRAY buffer;
    JDIMENSION buffer_height;
    bitmap = new (unsigned char)[width*height*bpp];
    //*bitmap = (unsigned char)malloc(width * height * bpp);
    //char *pos = data + width * height * bpp;
    unsigned char *pos = bitmap;
    buffer_height = height;
    bool success = true;
    // XXX Maybe this will be faster if we read more than one
    // scanline at a time (requires setting up array of char **).
    while (cinfo.output_scanline < cinfo.output_height) {
        buffer = (unsigned char **)&pos;
        int num_scanlines = jpeg_read_scanlines(&cinfo, buffer, 1);
        pos += width * bpp;

        if (num_scanlines == 0) {
            success = false;
            break;
        }

        buffer_height -= num_scanlines;
    }

    jpeg_finish_decompress(&cinfo);
    jpeg_destroy_decompress(&cinfo);

    fclose(f);

    if (jerr.num_warnings) success = false;
    if (bpp != 3) success = false;

    if (!success) {
        //free(bitmap);
        delete [] bitmap;
        return false;
    }
    return true;
}

