#ifndef __DATATYPES_
#define __DATATYPES_

typedef char int8;
typedef short int16;
typedef int int32;
typedef long int64;
typedef struct int128
{
  int64 lo,hi;
}int128 __attribute__((aligned(16)));

typedef struct fvec
{
  float x,y,z,w;
#ifdef __cplusplus
  fvec& operator+=(const fvec &a){x+=a.x;y+=a.y;z+=a.z;w+=a.w;return *this;}
  fvec& operator-=(const fvec &a){x-=a.x;y-=a.y;z-=a.z;w-=a.w;return *this;}
  fvec& operator*=(const fvec &a){x*=a.x;y*=a.y;z*=a.z;w*=a.w;return *this;}
  friend fvec operator+(const fvec &a, const fvec &b){fvec c=a;c+=b;return c;}
  friend fvec operator-(const fvec &a, const fvec &b){fvec c=a;c-=b;return c;}
  friend fvec operator*(const fvec &a, const fvec &b){fvec c=a;c*=b;return c;}
  friend fvec operator*(const float a, const fvec &b){fvec c=b;c.x*=a;c.y*=a;c.z*=a;c.w*=a;return c;}
  friend float dot(const fvec &a, const fvec &b){return a.x*b.x+a.y*b.y+a.z*b.z+a.w*b.w;}
  friend float dot3(const fvec &a, const fvec &b){return a.x*b.x+a.y*b.y+a.z*b.z;}
  friend float length(const fvec &a){return sqrt(dot(a,a));}
  friend fvec cross(const fvec &a, const fvec &b){fvec c;c.x=a.y*b.z-a.z*b.y;c.y=a.z*b.x-a.x*b.z;c.z=a.x*b.y-a.y*b.x;c.w=0;return c;}
  friend fvec normalized(const fvec &a){return (1.0f/sqrt(dot(a,a)))*a;};
#endif
}fvec __attribute__((aligned(16)));

#ifdef __cplusplus
inline fvec fvec_(float x_, float y_, float z_){fvec v;v.x=x_;v.y=y_;v.z=z_;return v;}
inline fvec fvec_(float x_, float y_, float z_, float w_){fvec v;v.x=x_;v.y=y_;v.z=z_;v.w=w_;return v;}
#endif


typedef struct ivec
{
  int32 x,y,z,w;
}ivec __attribute__((aligned(16)));

typedef union vec{
  int128 i128;
  fvec fv;
  ivec iv;
}vec __attribute__((aligned(16)));

static inline fvec new_fvec(float x, float y, float z)
{
  fvec v;
	
  v.x=x;
  v.y=y;
  v.z=z;
  v.w=0;

  return v;
}

#define dd(a,b) a,b
#define wwd(a,b) ((((long)b)<<32)+(long)a)
#define hhw(a,b) ((((long)b)<<16)+(long)a)

#endif
