#ifndef SPLINE_H_INCLUDED
#define SPLINE_H_INCLUDED

#include "types.h"

class linearSplineKey
{
 public:
  float time;
  float value;
  class linearSplineKey *next,*prev;
};

class linearSpline
{
  linearSplineKey head;
  linearSplineKey *cached;
  bool interpolationEnabled;
  void search(float time);
 public:
  void init();
  void setInterpolationEnabled(bool enabled);
  void addKeyValue(float time, float value);
  float evaluate(float time);
  void print();
};


class linearVectorSpline
{
  linearSpline x,y,z;
 public:
  void init(){x.init();y.init();z.init();}
  void addKeyValue(float time, fvec v){x.addKeyValue(time,v.x);y.addKeyValue(time,v.y);z.addKeyValue(time,v.z);}
  void setInterpolationEnabled(bool enabled){x.setInterpolationEnabled(enabled);y.setInterpolationEnabled(enabled);z.setInterpolationEnabled(enabled);}
  fvec evaluate(float time){return fvec_(x.evaluate(time),y.evaluate(time),z.evaluate(time),0);}
};

#endif
