#include "qsort.h"
#include "myassert.h"

void swap(void *a, void *b, int size)
{
  char *A=(char*)a;
  char *B=(char*)b;
  int t;
  for(t=0;t<size;t++)
    {
      char c;
      c=A[t];
      A[t]=B[t];
      B[t]=c;
    }
}

void qsort(void *base, int n, int size, int (*cmp)(const void *a, const void *b))
{
  int left=0;
  int right=n-1;
  // Kernighan, Ritchie second edition page 87
  int i, last;

  if(left>=right)return;
  swap(base+size*(left),base+size*((left+right)/2),size);
  last=left;
  for(i=left+1;i<=right;i++)
    if(cmp(base+size*i,base+size*left)<0)
      swap(base+size*(++last),base+size*i,size);
  swap(base+size*left,base+size*last,size);
  qsort(base+size*left,last-left,size,cmp);
  qsort(base+size*(last+1),right-last,size,cmp);

  for(i=left+1;i<=right;i++)
    myassert(cmp(base+size*(i-1),base+size*(i))<0);
}
