#ifndef __my_math
#define __my_math

#include "types.h"

#define __my_math_iter 20
#define pi 3.14159265358
#define MATH_N (32)

#ifdef __cplusplus
extern "C" {
#endif


  double fabs(double x);
  int abs(int x);
  long labs(long x);
  float floor(float x);
  float ceil(float x);
  float rint(float x);
  float exp(float x);
  float atan(float x);
  float acos(float x);
  float log(float x);
  float pow(float x, float y);
  float ldexp(float x, int n);
  float frexp(float x, int *exp);

  double cos(double v);
  double sin(double v);
  int rand();

inline static float sqrt(float a)
{
  float b;
  
  asm(
      "sqrt.s %0,%1;"
      : "=f" (b)
      : "f" (a));
  
  return b;
}


extern float math_sinetable[MATH_N][4]  __attribute__((aligned(16)));

void math_init();

inline static float max(float a, float b){if(a>b)return a;return b;}
inline static float min(float a, float b){if(a<b)return a;return b;}

// Polynomial approximation using sine table (degree 3)
inline static float sin2(float v)
{
  int i=(int)(((int)((v)*(1.0/(2*pi/MATH_N))+10000))-10000.0);
  v-=i*(2*pi/MATH_N);
  i&=MATH_N-1;
  
  return v*v*v*math_sinetable[i][3]+v*v*math_sinetable[i][2]+v*math_sinetable[i][1]+math_sinetable[i][0];
}

inline static float cos2(float v)
{
  int i=(int)(((int)((v)*(1.0/(2*pi/MATH_N))+10000))-10000.0);
  v-=i*(2*pi/MATH_N);
  i+=MATH_N/4;
  i&=MATH_N-1;
  
  return v*v*v*math_sinetable[i][3]+v*v*math_sinetable[i][2]+v*math_sinetable[i][1]+math_sinetable[i][0];
}

inline static void cossin2(float v)
{
  // vf11x=cos(v);vf11x=sin(v);
  int i=(int)(((int)((v)*(1.0/(2*pi/MATH_N))+10000))-10000.0);
  int j;
  fvec v2;
  v2.x=1;
  v2.y=1;
  v2.z=1;
  v2.w=v-i*(2*pi/MATH_N);
  
  __asm__ ("lqc2	vf11, 0x0(%0)"
	   : : "r" (&v2));
  
  j=i+MATH_N/4;
  i&=MATH_N-1;
  j&=MATH_N-1;
  __asm__ ("vmulw.zw vf11,vf11,vf11w"
	   : : );
  
  
  __asm__ __volatile__("vmulz.yzw vf11,vf11,vf11z\n"
		       "lqc2	vf9, 0x0(%0)\n"
		       "lqc2	vf10, 0x0(%1)\n"
		       
		       
		       "vmul.xyzw vf9,vf9,vf11\n"
		       "vmul.xyzw vf10,vf10,vf11\n"
		       

		       "vaddw.x vf9,vf9,vf9w\n"
		       "vaddw.y vf10,vf10,vf10w\n"
		       "vaddz.y vf9,vf9,vf9z\n"
		       "vaddz.x vf10,vf10,vf10z\n"
		       
		       
		       "vaddy.x vf11,vf9,vf9y\n"
		       "vaddx.y vf11,vf10,vf10x\n"
		       
		       : : "r" (math_sinetable+j),"r" (math_sinetable+i));
}

float atan2(float y, float x);

#ifdef __cplusplus
}
#endif

#endif
