#include "jpguse.h"

#include "myassert.h"
#include "gif.h"

#include "jpgd093bps2/jpegdecoder.h"

#define JPEGMEMSIZE 70*1024
static int mem[JPEGMEMSIZE/4];

void loadJpegToTextureEvenLines(char *dataBegin, char *dataEnd, texture *t, int alpha)
{
  loadJpegToTexture(dataBegin, dataEnd, t, 0, 2, alpha);
}


void loadJpegToTextureOddLines(char *dataBegin, char *dataEnd, texture *t, int alpha)
{
  loadJpegToTexture(dataBegin, dataEnd, t, 1, 2, alpha);
}


void loadJpegToTexture(char *dataBegin, char *dataEnd, texture *t, int startY, int stepY, int alpha)
{
  alpha/=2;
  static jpeg_decoder_stream s;

  s.init(dataBegin,dataEnd);
  
  static jpeg_decoder d;

  d.initMalloc((char*)mem,JPEGMEMSIZE);
  d.myinit(&s);
  
  myassert(d.get_error_code()==0);

  //  printf("Loading jpeg. Width: %i, Heignt: %i, Num Components: %i\n",d.get_width(),d.get_height(),d.get_num_components());

  if(d.begin())myassert(0);

  myassert(d.get_num_components()==3);


  for(int y=0;y<t->height*stepY;y++)
    {
      //      printf("%i\n",y);
      void *Pscan_line_ofs;
      unsigned int scan_line_len;

      if(d.decode(&Pscan_line_ofs,&scan_line_len))break;
      unsigned char *line=(unsigned char*)Pscan_line_ofs;

      if((y%stepY)==startY)
	{
	  int width=d.get_width();
	  for(int x=0;x<width;x++)
	    {
	      t->image[((y-startY)/stepY)*t->width+x]=rgb(line[x*4],line[x*4+1],line[x*4+2])+(alpha<<24);
	    }
	}
    }
}
