#include "hsvrgb.h"
#include "types.h"
#include "gif.h"
#include "matrix.h"
#include <kernel.h>
#define max(x,y) (x)>(y)?(x):(y)
#define min(x,y) (x)<(y)?(x):(y)


fvec rgbToFvec(int c)
{
  return fvec_(((c)&255)/255.0f,((c>>8)&255)/255.0f,((c>>16)&255)/255.0f);
}


int fvecToRgb(fvec c)
{
  return rgb(int(255*c.x),int(255*c.y),int(255*c.z));
}


fvec rgbToHsv(fvec rgb)
{
  float m=min(rgb.x,rgb.y);
  m=min(rgb.z,m);
  float M=max(rgb.x,rgb.y);
  M=max(rgb.z,M);

  float s=M?(M-m)/M:0;
  float v=M;
  float h;
  if(s==0)
    h=1000000;
  else
    {
      float delta=M-m;
      if(rgb.x==M)h=(rgb.y-rgb.z)/delta;
      else if(rgb.y==M)h=2+(rgb.z-rgb.x)/delta;
      else if(rgb.z==M)h=4+(rgb.x-rgb.y)/delta;
      h*=60;
    }
  return fvec_(h,s,v);
}

fvec hsvToRgb(fvec hsv)
{
  float h=hsv.x;
  float s=hsv.y;
  float v=hsv.z;

  if(s==0)
    {
      //      if(h>100000)
	{
	  return fvec_(v,v,v);
	}
      //error
    }
  else
    {
      float H=h/360;
      H+=10000;
      H=H-int(H);
      H*=6;

      int i;
      if(H>=5)i=5;
      else if(H>=4)i=4;
      else if(H>=3)i=3;
      else if(H>=2)i=2;
      else if(H>=1)i=1;
      else i=0;

      float f=H-i;
      float p=v*(1-s);
      float q=v*(1-(s*f));
      float t=v*(1-(s*(1-f)));

      switch(i)
	{
	case 0:
	  return fvec_(v,t,p);
	case 1:
	  return fvec_(q,v,p);
	case 2:
	  return fvec_(p,v,t);
	case 3:
	  return fvec_(p,q,v);
	case 4:
	  return fvec_(t,p,v);
	case 5:
	  return fvec_(v,p,q);
	}
    }
  return fvec_(0,0,0);
}
