#include "font.h"

#include "gif.h"

letter::letter()
{
}


letter::letter(int x1, int y1, int x2, int y2)
{
  this->x1=x1;
  this->y1=y1;
  this->x2=x2;
  this->y2=y2;
  
  compute();
}


void letter::compute()
{
  upperleft=hhw((x1)*16,(y1)*16);
  lowerright=hhw((x2)*16,(y2)*16);
  width=x2-x1;
}


static int lineempty(texture *tex, int x, int y, int height, int mask)
{
  for(int i=y;i<y+height;i++)
    {
      if(tex->image[x+i*tex->width]&mask)return 0;
    }
  return 1;
}


void font::setalpha(int alpha)
{
  this->alpha=alpha;
}


void font::setadditive(bool additive)
{
  this->additive=additive;
}


void font::init(texture *tex, int height, int xoffset, int yoffset, char *charlist, int mask)
{
  char *c=charlist;
  int x,y;
  
  additive=false;
  alpha=256;
  monospacing=0;
  
  this->tex=tex;
  this->height=height;
  
  for(int i=0;i<256;i++)letterlist[i]=letter(0,0,tex->width,tex->height);
  
  x=xoffset;
  y=yoffset;
  
  while(*c)
    {
      if(*c=='\n')
	{
	  x=xoffset;
	  y+=height;
	}
      else
	{
	  while(lineempty(tex,x,y,height,mask))x++;
	  int startx=x;
	  while(!lineempty(tex,x,y,height,mask))x++;
	  int endx=x;
	  letterlist[(unsigned char)*c]=letter(startx,y,endx,y+height);
	}
      
      c++;
    }
  
  letterlist[(unsigned char)' ']=letter(1,1,1,1);
  letterlist[(unsigned char)' '].width=height/4;
}


void font::putchar(char c, int x, int y)
{
  letter &r=letterlist[(unsigned char)c];
  
  //	tex->boxuv(16*x+32000,16*y+32000,16*(x+40)+32000,16*(y+40)+32000,r.upperleft,r.lowerright);
    tex->boxuv(16*x,16*y,16*(x+r.width),16*(y+height),r.upperleft,r.lowerright,additive? 0x4000000048: 0x4000000044,0x808080+((alpha/2)<<24));
  //	tex->boxuv(16*0+32000,16*0+32000,16*(200)+32000,16*(200)+32000,0,hhw(16*400,16*400));
}


void font::putstring(char *s, int x, int y)
{
  while(*s)
    {
      putchar(*s,x,y);
      if(monospacing)
	x+=monospacing;
      else
	x+=letterlist[(unsigned char)*s].width;
      s++;
    }
}


int font::pixlen(char *s)
{
  int l=0;
  while(*s)
    {
      if(monospacing)
	l+=monospacing;
      else
	l+=letterlist[(unsigned char)*s].width;
      s++;
    }

  return l;
}


void font::monospacingon(int width)
{
  monospacing=width;
}


void font::monospacingoff()
{
  monospacing=0;
}







