#ifndef __DMA_H
#define __DMA_H

#include "hwreg.h"

#ifdef __cplusplus
extern "C" {
#endif

#define dd(a,b) a,b
#define wwd(a,b) ((((long)b)<<32)+(long)a)
#define hhw(a,b) ((((long)b)<<16)+(long)a)

void FlushCache(int);
inline static void dma02_wait(){while(D2_CHCR&0x100);}
inline static void dma01_wait(){while(D1_CHCR&0x100);}

inline static void dma02_send(volatile void *start, int32 size, int32 chcr)
{
  D2_MADR=(int32)start;
  D2_QWC=size;
  D2_CHCR=chcr;
}

void dma_reset();

//macros for simple chain mode using dma02

extern int128 *dma_chainmem;
extern int128 *dma_chainnext;

inline static void dma_beginchain(void *mem)
{
  dma_chainmem=(int128*)mem;
  dma_chainnext=dma_chainmem;
}

inline static void dma_endchain()
{
  dma_chainnext->lo=0x70000000;
}

inline static void dma_sendchain()
{
  D2_MADR=(int32)dma_chainmem;
  D2_TADR=(int32)dma_chainmem;
  D2_QWC=0;
  D2_CHCR=0x105;//+64;
}

#define dma_begingp(){gif_begin(dma_chainnext+1);}

#define dma_endgp(){dma_chainnext->lo=0x10000000+gif_length;dma_chainnext+=gif_length+1;}
#define dma_endgp_(gl){int gl_=gl;dma_chainnext->lo=0x10000000+gl_;dma_chainnext+=gl_+1;}


//macros for simple chain mode using dma01

extern int128 *dma01_chainmem;
extern int128 *dma01_chainnext;
extern int32 *dma01_currentpos;
extern int32 *dma01_currentpacket;

inline static void dma01_beginchain(void *mem)
{
  dma01_chainmem=(int128*)mem;
  dma01_chainnext=dma01_chainmem;
}

inline static void dma01_endchain()
{
  dma01_chainnext->lo=0x70000000;
}

inline static void dma01_sendchain()
{
  D1_MADR=(int32)dma01_chainmem;
  D1_TADR=(int32)dma01_chainmem;
  D1_QWC=0;
  D1_CHCR=0x105;//+64;
}

#define dma01_beginp(){dma01_currentpos=dma01_currentpacket=(int32*)(dma01_chainnext+1);}
#define dma01_ref(start,end){dma01_chainnext->lo=0x30000000+(((char*)(end)-(char*)(start))>>4)+(((long)((unsigned int)start))<<32);dma01_chainnext->hi=0x70000000;dma01_chainnext++;}

#define dma01_endpchainend(){dma01_chainnext->lo=0x70000000+((dma01_currentpos-dma01_currentpacket)>>2);dma01_chainnext=(int128*)dma01_currentpos;}
#define dma01_endp(){dma01_chainnext->lo=0x10000000+((dma01_currentpos-dma01_currentpacket)>>2);dma01_chainnext=(int128*)dma01_currentpos;}
#define dma01_endpret(){dma01_chainnext->lo=0x60000000+((dma01_currentpos-dma01_currentpacket)>>2);dma01_chainnext=(int128*)dma01_currentpos;}
#define dma01_endpcall(addr){dma01_chainnext->lo=0x50000000+((dma01_currentpos-dma01_currentpacket)>>2)+(((long)((unsigned int)addr))<<32);dma01_chainnext=(int128*)dma01_currentpos;}

#define vif_nop(){*dma01_currentpos++=0;}
#define vif_stmask(mask){*dma01_currentpos++=((int)0x20<<24);*dma01_currentpos++=((int)mask);}
#define vif_stcycl(cycl){*dma01_currentpos++=((int)0x01<<24)+cycl;}
#define vif_flushe(){*dma01_currentpos++=((int)0x10<<24);}
#define vif_flusha(){*dma01_currentpos++=0x13000000/*((int)0x13<<24)*/;}
#define vif_flush(){*dma01_currentpos++=((int)0x11<<24);}
#define vif_mscnt(){*dma01_currentpos++=((int)0x17<<24);}
#define vif_mscal(addr){*dma01_currentpos++=((int)0x14<<24)+(addr);}
#define vif_mscalf(addr){*dma01_currentpos++=((int)0x15<<24)+(addr);}
#define vif_mpg(num,addr){*dma01_currentpos++=((int)0x4a<<24)+(num<<16)+addr;}
#define vif_unpack(num,addr){*dma01_currentpos++=((int)0x6c<<24)+(num<<16)+addr;}
#define vif_unpack_s32(num,addr){*dma01_currentpos++=((int)0x60<<24)+(num<<16)+addr;}
#define vif_128(data){*(int128*)dma01_currentpos=(data);dma01_currentpos+=4;}
#define vif_32(data){*(int32*)dma01_currentpos=(data);dma01_currentpos+=1;}
#define vif_direct_begin(){dma01_currentpos++;gif_begin(dma01_currentpos);}
#define vif_direct_end(){*(dma01_currentpos-1)=((int)0x50<<24)+gif_length;dma01_currentpos+=4*gif_length;}
#define vif_direct_end_(gl){int gl_=gl;*(dma01_currentpos-1)=((int)0x50<<24)+gl_;dma01_currentpos+=4*gl_;}
#define vif_directhl(num){*dma01_currentpos++=((int)0x51<<24)+(num);}
#define vif_mskpath3(f){*dma01_currentpos++=((int)0x06<<24)+(f<<15);}

#define vif_base(addr){*dma01_currentpos++=((int)0x03<<24)+(addr);}
#define vif_offset(addr){*dma01_currentpos++=((int)0x02<<24)+(addr);}

//-----------------------------------------------------------------------
// Functions adding unpack and mpg commands to the current vif1 dma list
// (using dma ref to refer to data/code)
//-----------------------------------------------------------------------
void uploadvucode(unsigned int* begin, unsigned int *end);
void uploadvudata(char* begin, char *end, int pos=0);
void clearvudata();

#ifdef __cplusplus
}
#endif

void initvifdmalist();


#endif
