#include "dma.h"
#include <kernel.h>

int128 *dma_chainmem;
int128 *dma_chainnext;

int128 *dma01_chainmem;
int128 *dma01_chainnext;
int32 *dma01_currentpos;
int32 *dma01_currentpacket;


void dma_reset()
{
  DMA02[32]=0;
  D2_CHCR=0;
  D2_TADR=0;
  D2_MADR=0;
  DMA02[20]=0;
  DMA02[16]=0;
  
  DMA01[32]=0;
  D1_CHCR=0;
  D1_TADR=0;
  D1_MADR=0;
  DMA01[20]=0;
  DMA01[16]=0;
  
  DMA_[4]=0xff1f;
  DMA_[4]=DMA_[4]&0xff1f;

  DMA_[0]=0;
  DMA_[8]=0;
  DMA_[12]=0;
  DMA_[20]=0;
  DMA_[16]=0;
  
  DMA_[0]=DMA_[0]|1;
}

void initvifdmalist()
{
  static int sdma=-1;
  static int128 dmamem1a[1024*40*3];
  static int128 dmamem1b[1024*40*3];
  
  if(sdma==-1)
    sdma=0;
  else
    {
      FlushCache(0);
      dma01_wait();
      if(sdma==0)
	dma01_chainmem=dmamem1a;
      else
	dma01_chainmem=dmamem1b;
      dma01_sendchain();
      sdma=1-sdma;
    }
  if(sdma==0)
    dma01_beginchain(dmamem1a);
  if(sdma==1)
    dma01_beginchain(dmamem1b);
}

void uploadvucode(unsigned int* begin, unsigned int *end)
{
  int pos=0;
  int maxsize=100;
  
  dma01_beginp();
  vif_nop();
  vif_flusha();
  vif_flushe();
  vif_flush();
  dma01_endp();
  
  if(1&((((char*)end)-((char*)begin))>>3))end+=2;
  
  while(((((char*)end)-((char*)begin))>>3)>maxsize)
    {
      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_mpg(maxsize,pos);
      dma01_endp();
      dma01_ref(begin,((unsigned int*)((((char*)begin)+maxsize*8))));
      begin+=maxsize*2;
      pos+=maxsize;
    }
  if(end!=begin)
    {
      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_mpg((((char*)end)-((char*)begin))>>3,pos);
      dma01_endp();
      dma01_ref(begin,end);
    }
}


void uploadvudata(char* begin, char *end, int pos)
{
  //begin should be 128bit aligned
  int maxsize=100;
  
  end=begin+(((end-begin)+15)&(-16));
  
  dma01_beginp();
  vif_offset(0);
  vif_base(0);
  vif_nop();
  vif_nop();
  dma01_endp();

  while(((((char*)end)-((char*)begin))>>4)>0)
    {
      int s=maxsize;

      if(begin+s*16<end)s=(end-begin)>>4;

      dma01_beginp();
      vif_stcycl(0x101);
      vif_stmask(0);
      vif_unpack(((char*)(begin+s*16)-(char*)begin)>>4,pos);
      dma01_endp();
      
      dma01_ref(begin,(begin+s*16));
      
      begin+=s*16;
      pos+=s;
    }
}

void clearvudata()
{
  static int128 cleanmem[128];

  for(int t=0;t<8;t++)uploadvudata((char*)cleanmem,(char*)(cleanmem+128),t*128);
}
