#ifndef CUBEMAP_H_INCLUDED
#define CUBEMAP_H_INCLUDED

#include "texture.h"
#include "matrix.h"
#include "mesh.h"

class CubeMap
{
  mesh theMeshes[6];
  int newCubeTextureSize;
  int newEnvTextureSize;
  texture *sourceTextures[6];
  texture envMap;
  //  static int128 gifList[];
  int128 *gifLists[6][2];
  int128 *gifListsEnd[6][2];
  float camDistance;
  
  fvec rayCast(int x, int y, fvec *refraction);
  void showTexture(texture *t, int x, int y);
  void renderSide(fmatrix *m, texture *t);
  void generateGifLists();
  void getMappingCoordinates(fvec v, int &x, int &y, int &n);
 public:
  void init(float camDistance, int newCubeTextureSize, int newEnvTextureSize, texture *t0, texture *t1, texture *t2, texture *t3, texture *t4, texture *t5);
  void deinit();
  texture *getEnvMap(int addr);

  texture *computeEnvMap(fmatrix *m, int addr);
};


#endif
